# Node.js LTS meeting 19 September 2017

- [Github Issue](https://github.com/nodejs/Release/issues/244)
- [Meeting Video](https://www.youtube.com/watch?v=Y01b-pMIp8E)
- [Previous meeting](https://github.com/nodejs/Release/issues/243)
- Next meeting: 9 October 2017

## Present

- Myles Borins (@mylesborins)
- James Snell (@jasnell)
- Jeremiah Senkpiel (@fishrock123)
- Sam Roberts (@sam-github)
- Michael Dawson (@mhdawson)
- Ali Iyaz Sheikh (@ofrobots)

## Agenda

### V8 6.1 in Node 8.x

- Myles: V8 6.1 Branch is now ABI compatible with Node 8.x.
- Myles: Propose October 31st for Node 8.x LTS
- Jeremiah: If it slips it’ll be November, I’d prefer 24th
- James: Planning 30th for 9.0.0
- Myles: We could do a cutoff of 24th and do builds then, then promote on 31st
- Jeremiah: Sounds good
- Rod: 6.1 of v8 gives us what over 6.0?
- Myles: modern v8
- Ali: Lots of performance fixes for 6.1
- Jeremiah: Does it have import module support?
- Myles: That’s 6.2
- Rod: Want to reiterate reasons we previously had for not upgrading last minute. I think we can make a special allowance in this case for Turbofan, as that itself is unstable.
- Rod: Don’t want to get into a pattern of dumping stuff into LTS up to the last minute, negating part of the point of having LTS.
- Myles: Having managed the LTS branches, I’m not sure it’s possible to stabilise a release over 6 months, given that we’re constantly releasing minors.
- Rod: I was thinking about this too w.r.t the c-ares patch.
- Rod: It increases the likelihood of unavoidable semver-majors
- Sam: For V8 6.1, I think we need to get it out there. But I’m also concerned about the general precedent. Maybe we could not have minors over the last 3 months of current. The first thing that is called LTS should actually be LTS.
- Myles: I think the amount of work that it takes to manage these branches means that it’s not feasible to diverge greatly from master for the first six months.
- Michael: I think semver-minors are not all equal, something like a V8 update is a lot different from adding a new API or something.
- Ali: I think the risk of a V8 upgrade is less destabilising than the diffs would suggest, it has been used in Chrome by millions of users.
- Jeremiah: True, but it is more destabilising than the average semver-minor, and we have to discuss those.
- Rod: It’s not just V8 6.1, we’ve had to shake out things that are different in Node to the browser. Stability has increased greatly, but there’s still a shaking-out period. It’s not entirely the same.
- Ali: I think I’d like to see a month of feedback from Node regarding performance.
- James: Yeah, but that month of feedback is before the release.
- Myles: I think users want newer features as well as stability, we have to balance the two.
- Michael: Specifically for 6.1 I think it’s worth the risk, in general we probably need to have more discussion about this not being general practice.
- James: Agreed on both.
- Myles: Perhaps we should revive the PR for a 2 month cutoff before semver-minors
- Jeremiah: I think I like Sam’s idea from earlier
- Michael to raise PR for policy, general agreement on V8 6.1 backport.

### Review of semver-minors for 6.x

- _Notes in individual PRs_
