# Node.js LTS meeting 15 May 2017

- Github issue: https://github.com/nodejs/LTS/issues/213
- Meeting Video: https://youtu.be/UFBMF9ndBDo
- Next meeting: 05 June 2017
- Previous meetings: https://github.com/nodejs/LTS/issues/201

## Present

- Michael Dawson (@mhdawson)
- Myles Borins (@MylesBorins)
- Jeremiah Senkpiel (@fishrock123)
- Sam Roberts (@sam-github)
- Gibson Fahnestock (@gibfahn)


## Agenda

### nodejs/LTS
- meta: updated messaging regarding dates [#141](https://github.com/nodejs/LTS/pull/141)
- Clarify what happens with odd-numbered releases in April [#128](https://github.com/nodejs/LTS/pull/128)
- meta: charter the LTS Working Group [nodejs/CTC#122](https://github.com/nodejs/CTC/pull/122)
- Potential Semver Minor Backports [#177](https://github.com/nodejs/LTS/issues/188)


## Minutes

### meta: updated messaging regarding dates [#141](https://github.com/nodejs/LTS/pull/141)

All: No objections


### Clarify what happens with odd-numbered releases in April [#128](https://github.com/nodejs/LTS/pull/128)

- Myles: I’m not sure we need to declare a support statement at all, we
  definitely don’t want to call it maintenance, that conflates it with LTS
  maintenance mode, which is different.
- Sam: if we describe odd-numbered as stable then do we need maintenance?
- Myles: we shouldn’t call odd-numbered releases stable, they are current
  because they don’t have a support process.
- Myles: We could say: “After the next Current release line comes out, there
  will be no more scheduled releases. Further releases will be agreed on a
  case-by-case basis.”
- Michael: how about: "An odd-numbered major release will cease to be actively 
  updated when the subsequent even-numbered major release is cut."
- All: agreed
- Myles: I think the bigger issue is that we are inconsistent about how stable
  current is, and whether it’s recommended for more general use.
- Myles to raise CTC issue

### meta: charter the LTS Working Group [nodejs/CTC#122](https://github.com/nodejs/CTC/pull/122)

 - Myles: I think the release team should include the LTS team, and a team of
   people who do releases.
 - Myles: Also the current Release WG should have meetings, even infrequent
   ones, that would help us stay on top of our release process.
 - Michael: I think it’s still good to have a `releasers` team under the
   proposed Release WG that actually handles the release process, so that we
   can have a wider Release team that aren’t required to all have release
   access.
- Jeremiah: Yeah, there probably will be a lot of overlap between what the
  current Release and LTS teams talk about.
- Jeremiah: If we do this, then the Release team might not all need to have the
  responsibility to do releases.
- Myles: So maybe the rule should be that to add someone to the releasers team
  requires signoff from the CTC.
- Michael: We need to make sure the other Release team members are on board.
- Michael to write up a first draft of the proposal, Myles can review before
  the issue is created.


