# Node.js LTS meeting 24 April 2017

- Github issue: https://github.com/nodejs/LTS/issues/201
- Meeting Video: https://www.youtube.com/watch?v=CVPtof6dZLc
- Next meeting: May 15 2017
- Previous meetings: https://github.com/nodejs/LTS/issues/194
https://github.com/nodejs/LTS/issues/185

## Present

- Michael Dawson (@mhdawson)
- Myles Borins (@MylesBorins)
- James Snell (@jasnell)
- Jeremiah Senkpiel (@fishrock123)
- Sam Roberts (@sam-github)
- Gibson Fahnestock (@gibfahn)


## Agenda

### nodejs/LTS
- Limit push access to LTS staging branches to backport team [#199](https://github.com/nodejs/LTS/issues/199)
- Node-v8 LTS support end on 2019-12-31 to meet EOSL of openssl-1.0.2 [#186](https://github.com/nodejs/LTS/issues/186)
- Backporting test fixes to maintenance branches [#205](https://github.com/nodejs/LTS/issues/205)
- Inspector - retain support for `--inspect --debug-brk` https://github.com/nodejs/node/issues/12364 (related: https://github.com/nodejs/node/pull/12615)
- Plan for triaging semver-minor backports in LTS meetings [#204](https://github.com/nodejs/LTS/issues/204)
- Potential Semver Minor Backports [#177](https://github.com/nodejs/LTS/issues/188)

## Minutes

### Limit push access to LTS staging branches to backport team [#199](https://github.com/nodejs/LTS/issues/199)

- Myles: knowing that only people with backporting auth allows more trust, as-is, myles has to audit the -staging branch before starting to land commits, which is time consuming.
- Myles: also, everyone should turn on signed commits
- Myles: doesn’t think 7.x-staging (current) needs this kind of protection, for now
- Gibson: +1
- Sam: +1
- Michael: has only pushed to -staging when asked, would this be an issue?
- Myles: would prefer to pick peoples commits to staging
- James: +1
- Myles: mark ctc-review and give it a few days to ensure no objections?
- James: good idea


### Node-v8 LTS support end on 2019-12-31 to meet EOSL of openssl-1.0.2 [#186](https://github.com/nodejs/LTS/issues/186)

- Gibson: would shorten by 3 months
- Gibson: objections?
- All: … (no objections)
- Myles: what is next version of OpenSSL with long support
- Michael: 1.2?
- Myles: concerned that there is not a more proactive approach to planning when we upgrade openssl
- Michael: lets wait until 8.0, then start talking about it


### Backporting test fixes to maintenance branches [#205](https://github.com/nodejs/LTS/issues/205)

- Myles: there are already 2 test commits in that fix very broken behaviour
- Myles: concerned about a slippery slope, and that there isn’t a clear policy, and that one test may pull more tests in
- Myles: also concerned that anybody (not just LTS members) feel they have equal access to request backport, and if anybody can request backports, will there be too many?
- James: active, we backport things we think can go, maintainance, we only backport when people request (and after considering the request)
- Michael: feels it should be request driven, and based 
- Myles: what about semver-minor? Are we going to allow minors on things in maintenance?
- Sam: I’m OK, if its high value, and VERY low risk
- James: we’ve done this on a case-by-case basis in the past (0.10, 0.12)
- Myles: OK, but we should change the process to express that people may request backports to the maintenance branch, and LTS WG will consider
- Jeremiah: we should always backport tests along with features/fixes
- Myles: need to add wording to that non-critical changes can land with LTS WG consensus, hopefully without a full meeting
- Sam: thinks the test problem under consideration is critical…
- Myles: wants critical to be high bar, something that EVERY user should update to get the fix for
- Michael: willing to take a shot at a new language
- Myles: “will land fixes into maintenance as considered necessary for the stability of the maintenance release” - but we are much less proactive in landing things. Stability is the most important value.
- ... Much description
- Myles: this specific test can land, if there are no objections, but we should change the docs and be very conservative
- ... we all seem to want to be conservative in accepting changes into maintainence releases



### Inspector - retain support for `--inspect --debug-brk` [nodejs/node#12364](https://github.com/nodejs/node/issues/12364) (related: [nodejs/node#12615](https://github.com/nodejs/node/pull/12615))

- [2017-04-24 14:45] <refack> If you read me. I say remove `--inspect-brk`, it won't be adopted
- [2017-04-24 14:46] <octetcloud> refack: you listing to the LTS meeting? I'm OK with removing --inspect-brk as well.
- Gibson: thinks we should backport --inspect-brk
- Myles: `node debug` already aliased, why not alias `--debug-brk`?
- Gibson: if we are going to use `--inspect-brk` in the future, we should backport it, if we are going to instead just use `--debug-brk` in the future, we should bring it back on master. Conversation about what to do should happen in a new issue.
- [2017-04-24 15:02] <refack> octetcloud: new meta issue https://github.com/nodejs/node/issues/12630

### Plan for triaging semver-minor backports in LTS meetings [#204](https://github.com/nodejs/LTS/issues/204)

- Gibson: can we agree on a async review process? If so, we can do triaging online.
- ... no objections in theory

### Potential Semver Minor Backports [#177](https://github.com/nodejs/LTS/issues/188)

- Skipped this time as the list wasn't filtered.
