# Node.js LTS meeting 13 March 2017

* Github issue: https://github.com/nodejs/LTS/issues/185
* Meeting video: https://www.youtube.com/watch?v=w45MlYvMSQM
* Previous meeting: https://docs.google.com/document/d/1YK6hYnaVAgGIYC50I8utpx7mD_L-E_127CuuymE3YvU/edit
* Next meeting: April 24 2017

## Present

* Michael Dawson (@mhdawson)
* Myles Borins (@MylesBorins)
* James Snell (@jasnell)
* Jeremiah Senkpiel (@fishrock123)
* Gibson Fahnestock (@gibfahn)

## Agenda
* Potential Semver Minor Backports [#177](https://github.com/nodejs/LTS/issues/177)
* Should we consider swapping the timeframe for Active LTS and
  maintenance [#130](https://github.com/nodejs/LTS/issues/130)
* Managing floating V8 patches [#111](https://github.com/nodejs/LTS/issues/111)
* Backporting WG [#184](https://github.com/nodejs/LTS/issues/184)

## Minutes

### Potential Semver Minor Backports [#177](https://github.com/nodejs/LTS/issues/177)
  * These have already landed, minor went out 2 weeks ago
  * Need to create newer list, to review next meeting.

### Should we consider swapping the timeframe for Active and Maintenance [#130](https://github.com/nodejs/LTS/issues/130)
* Myles: seems like longer Active was useful, so he's ok
  with keeping as it for now
* James: have been some calls to have longer LTS period (5 year period),
  this is a request for a longer overall LTS period as opposed to
  changing the split.  But probably points to us not wanting to
  shorten the active period.
* Jeremiah - suggested we might be able to let more changes into Maintenance.
  If no request will just do critical/security fixes.  Could allow other
  changes on request at the discretion of the LTS team.
* James/Michael - we could allow on request.  Maintenance, we
  do not do it actively but if somebody wanted to backport we could
  land, not necessarily create a release. Would be limited to patch.
* Michael ok, but limited to releases that are not EOL.
  Myles should not land unless we are going to do a release.
* If we do takes more changes into Maintenance phase, when will
  builds actually go out.  Mostly in the past those have been
  for security releases, and we don't include any other
  changes with those, so when would the changes go in ?
* Myles, possibly if in Maintenance mode, if we accept PRs
  outside the critical ones, then we should have a release once/quarter.

Next actions:
* leave Active/Maintenance as is for now
* open new issue to better define release schedule, this might
  include release 1/quarter once in Maintenance.  For scheduled minors,
  might just be where it would be if the minor is needed.  Myles will
  take action to open issue, it will include proposed release schedule template.

### Managing floating V8 patches [#111]https://github.com/nodejs/LTS/issues/111)
* Myles: This has been pretty much under control.  Ali(@ofrobots) has created good
  backporting guide.  What was not resolved in this issue was how we manage v8.
  We had discussed having nodejs/v8 tree, but we are still just floating in
  the node repo. https://github.com/nodejs/v8 exists but Myles does not
  believe we are using as a staging group.  Seems ok now as
  we don't need an extra stage of indirection until we have tooling
  to automate the flow.  Ali has the TODO on a proposal for using the
  nodejs/v8 repo.  Remove from lts-agenda until there is more progress in issue.

### Backporting WG [#184](https://github.com/nodejs/LTS/issues/184)
* Myles (open issue on main repo [11099](https://github.com/nodejs/node/pull/11099)
  request to add guide for backporting PRs.  Has evolved from documenting
  existing process to people defining new process.
* other info, turns out to be just as easy to audit without labels,
  just audit everything, and just use tag to mark those that
  are blocked on something.
* Myles suggesting that we have separate WG, they would define process
  and commit to spend time to do the backports.  Each person should
  donate 10-15 hours/month.
* Michael, is that document useful for when we ask people to do backport
  because it did not land cleanly.
* Jeremiah, doc was supposed to cover all release branches, but current
  versus LTS releases may be different.
* Myles, process really should be the same, same meta data etc.
* Generally we are agreed, that a team for backporting would make sense.

Next actions:
  * Volunteers, James, Gibson, Myles, Sam  (10 hours each ?)
  * Myles will send out email to arrange time.
