import API from '@/api'

const user = {
  state: {},
  mutations: {},
  actions: {
    async delUser (context, reqData) {
      try {
        let { data } = await API['system/user'].del(reqData)
        return Promise.resolve(data)
      } catch (error) {
        return Promise.reject(error)
      }
    },

    async modifyStatus (context, reqData) {
      try {
        let { data } = await API['system/user'].modifystatus(reqData)
        return Promise.resolve(data)
      } catch (error) {
        return Promise.reject(error)
      }
    },

    async resetPassword (context, reqData) {
      try {
        let { data } = await API['system/user'].resetPassword(reqData)
        return Promise.resolve(data)
      } catch (error) {
        return Promise.reject(error)
      }
    },

    async allocationRole (context, reqData) {
      try {
        let { data } = await API['system/user'].allocationRole(reqData)
        return Promise.resolve(data)
      } catch (error) {
        return Promise.reject(error)
      }
    },

    async registered (context, reqData) {
      try {
        let { data } = await API['system/user'].registered(reqData)
        return Promise.resolve(data)
      } catch (error) {
        return Promise.reject(error)
      }
    }
  }
}

export default user
