<?php

namespace tn\phpmvc;
use tn\phpmvc\db\Database;
use tn\phpmvc\DbModel;
use tn\phpmvc\utils\Mailer;

/**
 * Application File Doc Comment
 * 
 * PHP version 7.4
 * 
 * @category Application
 * @package  tn\phpmvc
 * @author   Titus Njiru <njirutitus@gmail.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.hashbangcode.com/
 */
class Application
{
    public string $layout = 'main';
    public string $userClass;
    public Router $router;
    public Request $request;
    public Response $response;
    public Session $session;
    public Database $db;
    public ?UserModel $user;
    public View $view;
    public Mailer $mailer;


    public static string $ROOT_DIR;
    public static Application $app;
    public ?Controller $controller = null;

    
    public function __construct($rootPath, array $config)
    {
        $this->userClass = $config['userClass'];
        self::$ROOT_DIR = $rootPath;
        self::$app = $this;
        $this->request = new Request();
        $this->response = new Response();
        $this->session = new Session();
        $this->router = new Router($this->request,$this->response);
        $this->view = new View();

        $this->db = new Database($config['db']);

        $this->mailer = new Mailer($config['mail']);

        $primaryValue = $this->session->get('user');

        if($primaryValue) {
            $primaryKey = $this->userClass::primaryKey();
            if($this->userClass::findOne([$primaryKey => $primaryValue]))
            $this->user = $this->userClass::findOne([$primaryKey => $primaryValue]);
            else {
                $this->session->remove('user');
                $this->user = null;
            }
        }
        else {
            $this->user = null;
        }

    }

    public static function isGuest()
    {
        return !self::$app->user;
    }

    public static function isStaff()
    {
        return self::$app->user->is_staff ?? false;
    }

    public static function isSuperAdmin()
    {
        return self::$app->user->is_super_admin ?? false;
    }

    public function run()
    {
        try {
            echo $this->router->resolve();
        }
        catch (\Exception $e) {
            $this->response->setStatusCode($e->getCode());
            echo $this->view->renderView('_error',[
                'exception' => $e
            ]);
        }


    }

    /**
     * @return Controller
     */
    public function getController(): Controller
    {
        return $this->controller;
    }

    /**
     * @param Controller $controller
     */
    public function setController(Controller $controller): void
    {
        $this->controller = $controller;
    }

    public function login(DbModel $user)
    {
        $this->user = $user;
        $primaryKey = $user->primaryKey();
        $primaryValue = $user->{$primaryKey};
        $this->session->set('user',$primaryValue);

        return true;
    }

    public function logout()
    {
        $this->user = null;
        $this->session->remove('user');
    }

}