<h1 align="center" width="100%">
    <a href="https://github.com/nicolasebastianelli/speech-ai">
        <img width="50%" src="https://github.com/nicolasebastianelli/speech-ai/blob/main/images/logo.png">
    </a>
</h1>

<div align="center">
  <b>SpeechAI 🔉 - Generate conversational speech! </b>
  <br />
  <br />
  <a href="https://github.com/nicolasebastianelli/speech-ai/issues/new?assignees=&labels=bug&template=01_BUG_REPORT.md&title=bug%3A+">Report a Bug</a>
  ·
  <a href="https://github.com/nicolasebastianelli/speech-ai/issues/new?assignees=&labels=enhancement&template=02_FEATURE_REQUEST.md&title=feat%3A+">Request a Feature</a>
  ·
  <a href="https://github.com/nicolasebastianelli/speech-ai/discussions">Ask a Question</a>
</div>

<div align="center">
<br />

[![Release](https://img.shields.io/pypi/v/speechai?label=release)](https://pypi.org/project/speechai/)
[![Downloads](https://static.pepy.tech/badge/speechai/month)](https://pepy.tech/project/speechai)
[![License](https://img.shields.io/pypi/l/speechai.svg)](https://github.com/nicolasebastianelli/speech-ai/blob/main/LICENSE)
[![codecov](https://codecov.io/gh/nicolasebastianelli/speech-ai/branch/main/graph/badge.svg?token=CvXgrbE8Mh)](https://codecov.io/gh/nicolasebastianelli/speech-ai)
[![Open Source Helpers](https://www.codetriage.com/nicolasebastianelli/speech-ai/badges/users.svg)](https://www.codetriage.com/nicolasebastianelli/speech-ai)

[![CI](https://github.com/nicolasebastianelli/speech-ai/actions/workflows/ci.yaml/badge.svg)](https://github.com/nicolasebastianelli/speech-ai/actions/workflows/ci.yaml)
[![CD](https://github.com/nicolasebastianelli/speech-ai/actions/workflows/cd.yaml/badge.svg)](https://github.com/nicolasebastianelli/speech-ai/workflows/cd.yaml)
[![CodeQL](https://github.com/nicolasebastianelli/speech-ai/actions/workflows/github-code-scanning/codeql/badge.svg)](https://github.com/nicolasebastianelli/speech-ai/actions/workflows/github-code-scanning/codeql)

[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Imports: isort](https://img.shields.io/badge/imports-isort-edfaca.svg)](https://pycqa.github.io/isort/)
[![Imports: isort](https://img.shields.io/badge/linter-flake8-a63d42.svg)](https://github.com/PyCQA/flake8)
[![Imports: isort](https://img.shields.io/badge/linter-pylint-5e8db2.svg)](https://github.com/pylint-dev/pylint)
[![Imports: isort](https://img.shields.io/badge/test-pytest-f2c3c9.svg)](https://docs.pytest.org/en/7.3.x/)
</div>

## What is it?

SpeechAI 🔈 is a Python package which empowers you to receive vocal responses directly from LLM with few lines of code.
Its flexibility plays nice with any LLM and voice tools out there (online and offline), making it easy integrate it into your own projects.


Just install it, import the desired LLM and TTS from SpeechAI.
Once done, you can query the model with your question and promptly receive an audio response, ready for download.
As easy as that!

Here you can find a couple of examples:

* SpeechAI with **OpenAI**: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/17Badf1f2H6YU8Go-a9IfrZ3r2xmG0h6A)
* SpeechAI with **Cohere**: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/1DRylc8BvvH8RNIPGteLIE-AAYQDUgWPm)


## Install
The source code is currently hosted on GitHub at:
https://github.com/nicolasebastianelli/speech-ai

Binary installers for the latest released version are available at the [Python
Package Index (PyPI)](https://pypi.org/project/speechai).

```sh
# PyPI
pip install speechai
```

The list of changes to speechai between each release can be found
[here](https://github.com/nicolasebastianelli/speech-ai/releases). For full
details, see the commit logs at https://github.com/nicolasebastianelli/speech-ai/commits/main.


## Contributing

First off, thanks for taking the time to contribute! Contributions are what makes the open-source community such an amazing place to learn, inspire, and create. Any contributions you make will benefit everybody else and are **greatly appreciated**.

Please follow the [contributing guidelines](docs/CONTRIBUTING.md) and try to create bug reports that are:

- _Reproducible._ Include steps to reproduce the problem.
- _Specific._ Include as much detail as possible: which version, what environment, etc.
- _Unique._ Do not duplicate existing opened issues.
- _Scoped to a Single Bug._ One bug per report.

Please adhere to this project's [code of conduct](docs/CODE_OF_CONDUCT.md).

## Support

Reach out to the maintainer at one of the following places:

- [GitHub discussions](https://github.com/nicolasebastianelli/speech-ai/discussions)
- The email which is located [in GitHub profile](https://github.com/nicolasebastianelli)

## License

This project is licensed under the **Apache-2.0 license**.

See [LICENSE](LICENSE) for more information.

## Sustain us
[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://bmc.link/nsebastianelli)
