## How to Contribute
We welcome community contributions, whether they are documentations, refactoring, tests, or new features.

You can contribute to PyGraft in the following ways:

- File a [bug report](https://github.com/nicolas-hbt/pygraft/issues/new?assignees=&labels=&template=bug_report.md&title=)

- File a [feature request](https://github.com/nicolas-hbt/pygraft/issues/new?assignees=&labels=&projects=&template=feature_request.md&title=)

- Help other users by commenting on [pending issues](https://github.com/nicolas-hbt/pygraft/issues)

- Help implementing unit tests

- Help refactoring code and ensuring best practices are respected

- Generate clean docstrings for the existing code base

- Implement a new feature (see [Desirable Features](#desirable-features))


> [!IMPORTANT] 
> PyGraft is a nascent project. It still lacks unit tests and a clear choice of code formatting and documentation standards. We plan on using [black](https://github.com/psf/black) as code formatter and the [Google Python guidelines](https://github.com/google/styleguide/blob/gh-pages/pyguide.md) for the documentation. We welwome any open discussion on this topic. Later on, this section will be modified to reflect our strict commitment to our chosen code formatting and documentation standards.


<a name="desirable-features"></a>

## Desirable Features

Additional features will be provided in the next versions of PyGraft. You want to contribute but do not know how? Here are a few desirable features to implement to get you up and running:

**High Priority**

- [ ] Allow support for any input schema (and not only the schemas generated by PyGraft).
- [ ] Allow explanations for inconsistencies to be parsed from HermiT API. This would make it possible to remove a subset of triples from inconsistent KGs to make them consistent, without needing the user to run the KG generation pipeline again. This is especially true for very large graphs, or if the user comes with an already existing schema which is not perfectly consistent.

**Medium Priority**

- [ ] Fix the conflict between the following properties ``rdfs:subPropertyOf``, ``owl:FunctionalProperty``, and ``owl:InverseFunctionalProperty``, as a non-zero value for the three of them at the same time can lead to inconsistent KGs.

**Low Priority**

- [ ] Facilitate the generation of larger KGs (this would imply removing any dependency to [rdflib](https://github.com/RDFLib/rdflib/)).
- [ ] Add support for literals.