## 基础篇

- [WebAssembly Design Documents](https://github.com/WebAssembly/design)
- [A cartoon intro to WebAssembly](https://hacks.mozilla.org/2017/02/a-cartoon-intro-to-webassembly/)
- [WebAssembly High-Level Goals](http://webassembly.org/docs/high-level-goals/)
- [WebAssembly MDN](https://developer.mozilla.org/en-US/docs/WebAssembly)
- [Goodbye JavaScript, Hello WebAssembly](https://www.telerik.com/blogs/goodbye-javascript-hello-webassembly)

## 进阶篇

## 周边篇

- [WebAssemblyStudio](https://github.com/wasdk/WebAssemblyStudio): <sub>Learn, Teach, Work and Play in the WebAssembly Studio</sub>
- [WebAssembly’s post-MVP future: A cartoon skill tree](https://hacks.mozilla.org/2018/10/webassemblys-post-mvp-future/)
- [如何评论浏览器最新的 WebAssembly 字节码技术？](https://www.zhihu.com/question/31415286)
- [Compile WebAssembly to JVM and other WASM tools ](https://github.com/cretz/asmble)
- [asm.js 和 Emscripten 入门教程](http://www.ruanyifeng.com/blog/2017/09/asmjs_emscripten.html)

## 实例篇

- [人脸、人眼检测 (WebAssembly ASM JS)](https://websightjs.com/index.html)
- [Unity tutorial game ](http://webassembly.org/demo/)
- [A minimal WebAssembly virtual DOM to build C++ SPA](https://github.com/mbasso/asm-dom)
- [ffmpegwasm/ffmpeg.wasm](https://github.com/ffmpegwasm/ffmpeg.wasm): <sub>FFmpeg for browser and node, powered by WebAssembly</sub>

## 工具篇

- [wasmerio/wasmer](https://github.com/wasmerio/wasmer): <sub>Universal WebAssembly runtime</sub>
- [wasm3/wasm3](https://github.com/wasm3/wasm3): <sub>🚀 The fastest WebAssembly interpreter</sub>
- [wasmtime](https://github.com/CraneStation/wasmtime): <sub>Standalone JIT-style runtime for WebAssembly, using Cranelift</sub>
- [AssemblyScript](https://github.com/AssemblyScript/assemblyscript): <sub>Definitely not a TypeScript to WebAssembly compiler 🚀 https://assemblyscript.org</sub>
- [vugu](https://github.com/vugu/vugu): <sub>Vugu: A modern UI library for Go+WebAssembly (experimental) https://www.vugu.org/</sub>
- [WebAssembly 的在线 IDE](https://webassembly.studio/): <sub>WebAssembly 的在线 IDE，支持 C / C ++ / Rust 程序在线编译成 WASM</sub>
- [perlin-network/life](https://github.com/perlin-network/life): <sub>A secure WebAssembly VM catered for decentralized applications.</sub>
- [wasm-pack ](https://github.com/rustwasm/wasm-pack): <sub>📦✨ your favorite rust -> wasm workflow tool! rustwasm.github.io/wasm-pack</sub>
- [wasm-micro-runtime](https://github.com/bytecodealliance/wasm-micro-runtime): <sub>WebAssembly Micro Runtime (WAMR)</sub>
- [google/schism](https://github.com/google/schism): <sub>A self-hosting Scheme to WebAssembly compiler</sub>
- [wasm3/wasm3](https://github.com/wasm3/wasm3): <sub>🚀 The fastest WebAssembly interpreter</sub>
- [lys-lang/lys](https://github.com/lys-lang/lys): <sub>⚜︎ A language that compiles to WebAssembly https://lys-lang.dev</sub>
