## 基础篇

* [Web Security（MDN ）](https://developer.mozilla.org/en-US/docs/Web/Security)
* [Front-End-Checklist | Security](https://github.com/thedaviddias/Front-End-Checklist#security)
* [HTTP Security Best Practice](https://httpsecurityreport.com/best_practice.html)
* [Security Guide for Developers ( 实用性开发人员安全须知 ) ](https://github.com/FallibleInc/security-guide-for-developers)
* [Web Security Basics](https://github.com/vasanthk/web-security-basics)
* [Find and Fix Node.js Security Flaws](https://blog.liftsecurity.io/)
* [Web 安全的三个攻防姿势](https://juejin.im/post/59e6b21bf265da43247f861d)
* [HTTP 安全最佳实践](https://juejin.im/entry/59127ac32f301e0057ef7cfc)
* [程序猿必读 - 防范 CSRF 跨站请求伪造](https://aicode.cc/cheng-xu-yuan-bi-dufang-fancsrf-kua-zhan-qing-qiu.html)
* [Understanding CORS](https://medium.com/@baphemot/understanding-cors-18ad6b478e2b)
* [黑客 & 网络攻击 (video)](https://www.bilibili.com/video/av20831479/), 原视频地址：[Hackers & Cyber Attacks](https://www.youtube.com/watch?v=_GzE99AmAQU)
* [Web-Security-Learning](https://github.com/CHYbeta/Web-Security-Learning): <sub>Web-Security-Learning</sub>

### 相关篇

* [I’m harvesting credit card numbers and passwords from your site. Here’s how.](https://hackernoon.com/im-harvesting-credit-card-numbers-and-passwords-from-your-site-here-s-how-9a8cb347c5b5)
* [The Open Web Application Security Project](https://www.owasp.org/)
* [练习黑客技术的在线网站大全](https://blog.lovejade.cn/2017/10/22/online-website-for-hacking-techniques.html)
* [The Internet: Encryption & Public Keys(Video)](https://www.youtube.com/watch?v=ZghMPWGXexs&index=6&list=PLzdnOPI1iJNfMRZm5DDxco3UdsFegvuB7)
* [The Internet: Cybersecurity & Crime(Video)](https://www.youtube.com/watch?v=AuYNXgO_f3Y&list=PLzdnOPI1iJNfMRZm5DDxco3UdsFegvuB7&index=7)
* [awesome-static-analysis](https://github.com/mre/awesome-static-analysis): <sub>A curated list of static analysis tools, linters and code quality checkers for various programming languages</sub>

### 相关库

* [nodesecurity/eslint-plugin-security](https://github.com/nodesecurity/eslint-plugin-security)
