**导语：** [VueJS](https://nicelinks.site/redirect?https://vuejs.org/) 是一款友好的、多用途且高性能的渐进式 `JavaScript` 框架；它能帮助你创建可维护性和可测试性更强的代码库；它具有许多令人难以抗拒的优势，诸如极其**易用**，如果你已经会了 HTML、CSS、JavaScript？即刻阅读指南开始构建应用！非常**灵活**，不断繁荣的生态系统，可以在一个库和一套完整框架之间自如伸缩。十分**高效**，20kB min+gzip 运行大小，超快虚拟 DOM ，最省心的优化。经过几年的发展，`Vue` 在构建`原生应用`、`小程序`等方面，也是大放异彩，成为时下发展最为迅猛的开放框架，堪称业界无冕之王。── 出自[倾城之链 | Vue.js - The Progressive JavaScript Framework](https://nicelinks.site/post/5b1a221c0526c920d6dfaada)。

## 基础篇

- [**Vue 官方文档**](https://cn.vuejs.org/)
- [Some of the vue-tutorial](https://github.com/Wscats/vue-tutorial)
- [从零搭建 vue2+vue-router2+webpack3 工程](http://www.qinshenxue.com/article/20161118151423.html)
- [Vue.js 2.0 快速上手精华梳理](https://juejin.im/post/59aa1248518825392656a86a)
- [Building a Modal Component with Vue.js](https://alligator.io/vuejs/vue-modal-component/)

## 进阶篇

- [Authentication Best Practices for Vue](https://blog.sqreen.io/authentication-best-practices-vue/)
- [逐行剖析 Vue.js 源码](https://github.com/NLRX-WJC/Learn-Vue-Source-Code)
- [如何写一手漂亮的 Vue](http://jeffjade.com/2017/03/11/120-how-to-write-vue-better/?me)
- [Vue 2.0 源码学习](https://segmentfault.com/a/1190000007484936)
- [vue2.0 源码分析之理解响应式架构](https://segmentfault.com/a/1190000007334535)
- [『翻译』深入理解 Vue.js 响应式原理](https://juejin.im/post/59a7b01f6fb9a0249975d39f)
- [Vue 源码解析：深入响应式原理](https://juejin.im/entry/5834992667f356006c395b31)
- [Vue 中你不知道但却很实用的黑科技](https://juejin.im/post/5843dcad128fe100577876e1)
- [Vue 源码详解之 v-for](https://chuckliu.me/#!/posts/58c650a0b5187d2fb51c04fa)
- [深入浅出基于 “ 依赖收集 ” 的响应式原理](https://segmentfault.com/a/1190000011153487)
- [XCel 项目总结 - Electron 与 Vue 的性能优化](https://aotu.io/notes/2016/11/15/xcel/index.html)
- [逐行级别的源码分析](https://github.com/HcySunYang/vue-design): <sub>逐行级别的源码分析 http://hcysun.me/vue-design/</sub>
- [Useful Vue patterns, techniques, tips and tricks and helpful curated links. ](https://github.com/learn-vuejs/vue-patterns)
- [Vue.js Authentication System with Node.js Backend](https://blog.jscrambler.com/vue-js-authentication-system-with-node-js-backend/): <sub>In this tutorial, ll explore different authentication types for JavaScript applications and build a Vue authentication system with a Node.js backend.</sub>

## 资源篇

- [vuejs/awesome-vue](https://github.com/vuejs/awesome-vue)
- [OverVue](https://github.com/open-source-labs/OverVue): <sub>Prototyping Tool For Vue Devs 适用于 Vue 的原型工具</sub>
- [VueJS 开发常见问题集锦](https://blog.beard.ink/JavaScript/VueJS-开发常见问题集锦/)

### UI 组件框架

- [element-plus/element-plus](https://github.com/element-plus/element-plus): <sub>🎉 A Vue.js 3.0 UI Library</sub>
- [11 Vue.js Component Libraries You Should Know In 2018](https://blog.bitsrc.io/11-vue-js-component-libraries-you-should-know-in-2018-3d35ad0ae37f)
- [element](https://github.com/ElemeFE/element): <sub>A Vue.js 2.0 UI Toolkit for Web https://element.eleme.io/ </sub>
- [buefy](https://github.com/buefy/buefy): <sub>Lightweight UI components for Vue.js based on Bulma https://buefy.org</sub>
- [vuetify](https://github.com/vuetifyjs/vuetify): <sub>Material Component Framework for Vue.js 2 https://vuetifyjs.com</sub>
- [bootstrap-vue](https://github.com/bootstrap-vue/bootstrap-vue): <sub>BootstrapVue provides one of the most comprehensive implementations of Bootstrap 4 components and grid system for Vue.js and with extensive and automated WAI-ARIA accessibility markup.</sub>
- [cube-ui](https://github.com/didi/cube-ui): <sub>🔶 A fantastic mobile ui lib implement by Vue https://didi.github.io/cube-ui/</sub>
- [mand-mobile](https://github.com/didi/mand-mobile): <sub>💰 A mobile UI toolkit, based on Vue.js 2, designed for financial scenarios. https://didi.github.io/mand-mobile</sub>
- [lusaxweb/vuesax](https://github.com/lusaxweb/vuesax): <sub>Frontend vue Components Framework for Vue.js 2 https://lusaxweb.github.io/vuesax/</sub>
- [ant-design-vue](https://github.com/vueComponent/ant-design-vue): <sub>An enterprise-class UI components based on Ant Design and Vue. 🐜</sub>
- [vue-treeselect](https://github.com/riophae/vue-treeselect): <sub>A multi-select component with nested options support for Vue.js https://vue-treeselect.js.org</sub>

## 搭建 Vue 应用

- [Vue-Cli](https://github.com/vuejs/vue-cli): <sub>🛠️ Standard Tooling for Vue.js Development</sub>
- [poi](https://github.com/egoist/poi): <sub>⚡️ A zero-config bundler for JavaScript applications. https://poi.js.org</sub>
- [vuetifyjs](https://vuetifyjs.com/): <sub>Material Design Component Framework</sub>
- [awesome-vue-cli3-example](https://github.com/nicejade/awesome-vue-cli3-example): <sub>🍑Awesome example for rapid Vue.js development using vue-cli3 .</sub>
- [vue-boilerplate-template](https://github.com/nicejade/vue-boilerplate-template): <sub>🍎 Efficient development of web SPA using Vue.js(2.\*) + Webpack + Element-ui + Pwa + Vuex + Vuex-router + Vue-i18n + Dayjs + Lodash.</sub>
- [pikapkg/snowpack](https://github.com/pikapkg/snowpack): <sub>The fastest dev environment for modern web apps. https://snowpack.dev</sub>
- [vuestic-admin](https://github.com/epicmaxco/vuestic-admin): <sub>Free and Beautiful Vue.js Admin Template</sub>
- [vuepress-web-app](https://github.com/nicejade/vuepress-web-app): <sub>📝 Web applications built with Vuepress https://nice.lovejade.cn/</sub>
- [create-nuxt-app](https://github.com/nuxt-community/create-nuxt-app): <sub>Create Nuxt.js App in seconds.</sub>
- [create-vue-app](https://github.com/vue-land/create-vue-app): <sub>Create Vue apps with no build configuration.</sub>
- [Meituan-Dianping/mpvue](https://github.com/Meituan-Dianping/mpvue): <sub>基于 Vue.js 的小程序开发框架，从底层支持 Vue.js 语法和构建工具体系。 http://mpvue.com</sub>
- [electron-vue](https://github.com/SimulatedGREG/electron-vue): <sub>An Electron & Vue.js quick start boilerplate with vue-cli scaffolding, common Vue plugins, electron-packager/electron-builder, unit/e2e testing, vue-devtools, and webpack. </sub>
- [vuido](https://github.com/mimecorg/vuido): <sub>Native desktop applications using Vue.js.</sub>
- [neutrinojs/neutrino](https://github.com/neutrinojs/neutrino): <sub>Create and build modern JavaScript projects with zero initial configuration. https://neutrinojs.org</sub>

## 周边篇

- [vue-cli](https://github.com/vuejs/vue-cli): <sub>🛠️ CLI for rapid Vue.js development</sub>
- [Vue Router](https://router.vuejs.org/): <sub>🚦 The official router for Vue.js. http://router.vuejs.org/</sub>
- [Vuex](https://vuex.vuejs.org/): <sub>🗃️ Centralized State Management for Vue.js. https://vuex.vuejs.org</sub>
- [Vue SSR](https://ssr.vuejs.org/): <sub>Vue.js Server-Side Rendering Guide</sub>
- [yyx990803/vue-lit](https://github.com/yyx990803/vue-lit): <sub>Proof of concept custom elements "framework"</sub>
- [jaredpalmer/razzle](https://github.com/jaredpalmer/razzle): <sub>✨ Create server-rendered universal JavaScript applications with no configuration</sub>
- [alpinejs/alpine](https://github.com/alpinejs/alpine): <sub>A rugged, minimal framework for composing JavaScript behavior in your markup.</sub>
- [vue-test-utils ](https://github.com/vuejs/vue-test-utils): <sub>🔬 Utilities for testing Vue components https://vue-test-utils.vuejs.org</sub>
- [vuepress](https://github.com/vuejs/vuepress): <sub>Minimalistic Vue-powered static site generator https://vuepress.vuejs.org/</sub>
- [vue-syntax-highlight ](https://github.com/vuejs/vue-syntax-highlight): <sub>💡 Sublime Text syntax highlighting for single-file Vue components</sub>
- [Vue 论坛](http://forum.vuejs.org)
- [Vue 聊天室](https://gitter.im/vuejs/vue)

### 工具类插件

- [handsontable](https://github.com/handsontable/handsontable): <sub>Handsontable Community Edition - JavaScript/HTML5 Data Grid Component with Spreadsheet Look & Feel. Available for React, Vue and Angular.</sub>
- [vue-meta](https://github.com/declandewet/vue-meta): <sub>Manage page meta info in Vue 2.0 components. SSR + Streaming supported.</sub>
- [vue-storefront](https://github.com/DivanteLtd/vue-storefront): <sub>Vue Storefront - PWA for eCommerce. 100% offline, platform agnostic, headless, Magento 2 supported. Always Open Source, MIT license. Join us as contributor (contributors@vuestorefront.io). http://vuestorefront.io</sub>
- [vue-cli-plugin-apollo](https://github.com/Akryum/vue-cli-plugin-apollo): <sub>🚀 vue-cli 3.x plugin for Apollo and GraphQL</sub>
- [vue-lazyload](https://github.com/hilongjw/vue-lazyload): <sub>A Vue.js plugin for lazyload your Image or Component in your application. http://hilongjw.github.io/vue-lazyload/</sub>
- [vue-infinite-loading](https://github.com/PeachScript/vue-infinite-loading): <sub>An infinite scroll plugin for Vue.js. </sub>
- [tiptap](https://github.com/scrumpy/tiptap): <sub>A rich-text editor for Vue.js https://tiptap.scrumpy.io/</sub>
- [vue-virtual-scroller](https://github.com/Akryum/vue-virtual-scroller): <sub>⚡️ Blazing fast scrolling for any amount of data</sub>
- [vue-faq-accordion](https://github.com/gerasimvol/vue-faq-accordion): <sub>❓ Simple and smooth Vue.js accordion component. Perfect for your FAQ section</sub>

### Vite

- [pikax/zipe](https://github.com/pikax/zipe): <sub>flutter docker image with full android sdk.</sub>
- [antfu/vite-plugin-pwa](https://github.com/antfu/vite-plugin-pwa): <sub>Zero-config PWA for Vite</sub>
