**导语**：**Serverless 面向未来的运维方式**；网络应用正在慢慢改变世界，但是大多数互联网企业仍然无法顺畅交付工程，更不用说敏捷开发和快速迭代了。**所以我们必须从根本上简化应用工程的交付和操作**。这就是**无服务器架构**所提供的 ServerLess 建立在下一代公共云服务之上，该服务仅在使用时自动扩容和收费。当规模， 所用容量和成本管理实现自动化时，可节省 99% 的成本管理。

无服务器架构是全新的，因此我们需要改变先前对老架构和工作流的看法。serverless 的目标是**以一种简单，强大而优雅的使用体验为开发者，团队提供开发和运行 serverless 应用程序所需的所有工具**。

以上是 ServerLess 官方给出的释义；初次知道它，缘于参加 2017 年 [JSCONF](https://halfrost.com/jsconf_china_2017/)（上海） ，对其有大致了解，知其很棒，却也一直未曾实践；转眼 2019 年，参加 [GTMC](https://ppt.infoq.cn/list/gmtcsz2019?scene=126&clicktime=1577068802)（深圳）分享会，感受到在这两年间，国内发展早已是欣欣向荣；并且，就前端而言，也能促进开发模式演进，进一步提升生产力；鉴于此，ServerLess 则很有学习的必要，这也是将作为此教程一部分的原因 （于 2020 年 01 月 07 日）。

## 基础篇

- [ServerLess 官方网站](https://serverless.com/)
- [Serverless Framework - GitHub](https://github.com/serverless/serverless)
- [ServerLess 官方文档](https://serverless.com/cn/framework/docs/)
- [Serverless 架构应用开发指南](https://github.com/phodal/serverless)
- [Serverless 官方示例](https://github.com/serverless/examples)

### 教程文章

- [深入浅出 Serverless：优势、意义与应用](https://serverlesscloud.cn/blog/2019-12-09-serverless-means-applications/)
- [探索 Serverless 中的前端开发模式](https://github.com/nodejh/nodejh.github.io/issues/49)
- [浅析基于 Serverless 的前后端一体化框架](https://yq.aliyun.com/articles/706958)
- [如何开发自己的第一个 Serverless Component](https://serverlesscloud.cn/best-practice/2019-12-12-how-write-first-serverless-component/)

### 实践示例

- [Serverless Official Site](https://github.com/serverless/site): <sub>🌎 Serverless.com – 100% serverless website built w/ React, Gatsby, AWS Lambda & the Serverless Framework https://serverless.com</sub>
- [用 Serverless 搭建个人静态相册网站](https://serverlesscloud.cn/best-practice/2019-12-13-Build-personal-album-website-with-serverless/)
- [Docsify + Serverless Framework 快速创建个人博客系统](https://serverlesscloud.cn/best-practice/2019-12-14-docsify-with-serverless/)

## 资源生态

- [anaibol/awesome-serverless](https://github.com/anaibol/awesome-serverless): <sub>☁️ A curated list of awesome services, solutions and resources for serverless / nobackend applications.</sub>
- [pmuens/awesome-serverless](https://github.com/pmuens/awesome-serverless): <sub>DEPRECATED: Curated list of resources related to serverless computing and serverless architectures.</sub>

### 官方

- [ServerLess 中文技术社区](https://serverlesscloud.cn/)
- [ServerLess 命令行工具](https://serverless.com/cli/): <sub>使用 YAML + CLI 开发应用并将其快速部署到云端。</sub>
- [ServerLess 插件](https://serverless.com/plugins/): <sub>提供 1000+ Framework CLI 插件，帮助开发者快速定义自己的工作流。</sub>
- [ServerLess 组件](https://serverless.com/components/): <sub>通过更加简单的担建，快速部署常见的 Serverless 应用。</sub>

### 其他

- [Amazon - Serverless Computing](https://aws.amazon.com/cn/serverless/)
- [阿里云 - 无服务器计算和应用场景](https://serverless.aliyun.com/)
- [腾讯云 - Serverless 微服务平台](https://cloud.tencent.com/product/tsf-serverless)
- [腾讯云 serverless 的专栏](https://cloud.tencent.com/developer/column/1196)
- [InfoQ Serverless Topic](https://www.infoq.cn/topic/Serverless)

### 周边篇

- [Miserlou/Zappa](https://github.com/Miserlou/Zappa): <sub>Serverless Python https://blog.zappa.io</sub>
- [openfaas/faas](https://github.com/openfaas/faas): <sub>OpenFaaS - Serverless Functions Made Simple https://openfaas.com</sub>
- [aws/chalice](https://github.com/aws/chalice): <sub>Python Serverless Microframework for AWS</sub>
- [awslabs/serverless-application-model](https://github.com/awslabs/serverless-application-model): <sub>AWS Serverless Application Model (SAM) is an open-source framework for building serverless applications</sub>
- [dherault/serverless-offline](https://github.com/dherault/serverless-offline): <sub>Emulate AWS λ and API Gateway locally when developing your Serverless project</sub>
- [kubeless/kubeless](https://github.com/kubeless/kubeless): <sub>Kubernetes Native Serverless Framework https://kubeless.io</sub>
- [serverless/serverless-graphql](https://github.com/serverless/serverless-graphql): <sub>Serverless GraphQL Examples for AWS AppSync and Apollo</sub>
- [adieuadieu/serverless-chrome](https://github.com/adieuadieu/serverless-chrome): <sub>🌐 Run headless Chrome/Chromium on AWS Lambda</sub>
- [CSS-Tricks/serverless](https://github.com/CSS-Tricks/serverless): <sub>The Power of Serverless for Front-End Developers https://serverless.css-tricks.com</sub>
- [serverless-heaven/serverless-webpack](https://github.com/serverless-heaven/serverless-webpack): <sub>Serverless plugin to bundle your lambdas with Webpack</sub>
