## 基础篇

- [React 官方网址](https://reactjs.org/)
- [React 官方文档](https://reactjs.org/docs/hello-world.html)
- [React 官方教程](https://reactjs.org/tutorial/tutorial.html)
- [react-developer-roadmap](https://github.com/adam-golab/react-developer-roadmap): <sub>Roadmap to becoming a React developer in 2018</sub>
- [React 官方博客](https://reactjs.org/blog/)
- [React Tutorials(javascriptstuff)](https://www.javascriptstuff.com/react-tutorials/)
- [React 入门实例教程 - 阮一峰](http://www.ruanyifeng.com/blog/2015/03/react.html)
- [React Native 中文版](http://wiki.jikexueyuan.com/project/react-native)
- [Webpack 和 React 小书 - gitbook](https://fakefish.github.io/react-webpack-cookbook)
- [基于 webpack 搭建前端工程解决方案探索](http://segmentfault.com/a/1190000003499526)
- [React.js 小书](https://github.com/huzidaha/react-naive-book): <sub>开源、免费、专业、简单的 React.js 在线教程 http://huziketang.com/books/react</sub>

## 进阶篇

- [How “Controllable” React components maximize reusability](https://medium.com/myheritage-engineering/how-controllable-react-components-maximize-reusability-86e3d233fa8e)
- [REACT, REDUX AND JAVASCRIPT ARCHITECTURE](https://jrsinclair.com/articles/2018/react-redux-javascript-architecture/)
- [Infinite scroll techniques in React](https://blog.logrocket.com/infinite-scroll-techniques-in-react-adcfd7ff32bd)

## 资源篇

- [Awesome React](https://github.com/enaqx/awesome-react)
- [awesome-react-components](https://github.com/brillout/awesome-react-components): <sub>Curated List of React Components & Libraries.</sub>
- [11 React Component Libraries You Should Know In 2018](https://blog.bitsrc.io/11-react-component-libraries-you-should-know-178eb1dd6aa4)

### UI 组件框架

- [Ant Design](https://ant.design/)
- [ant-design-pro](https://github.com/ant-design/ant-design-pro): <sub>👨🏻‍💻👩🏻‍💻 Use Ant Design like a Pro!</sub>
- [React material UI](http://material-ui.com/#)
- [React amazeui UI](http://amazeui.org/react)
- [chakra-ui](https://github.com/chakra-ui/chakra-ui): <sub>⚡️Simple, Modular & Accessible UI Components for your React Applications https://chakra-ui.com</sub>
- [PrimeReact UI](https://www.primefaces.org/primereact/#/): <sub>Your Favorite UI Framework for REACT</sub>
- [RSUITE](https://rsuitejs.com/): <sub>一套 React 的 UI 组件库</sub>
- [react-native-elements](https://github.com/react-native-training/react-native-elements): <sub>Cross Platform React Native UI Toolkit</sub>
- [evergreen](https://github.com/segmentio/evergreen): <sub>🌲 Evergreen React UI Framework by Segment https://evergreen.surge.sh/</sub>
- [grommet/grommet](https://github.com/grommet/grommet): <sub>a react-based framework that provides accessibility, modularity, responsiveness, and theming in a tidy package https://grommet.io</sub>
- [nitin42/terminal-in-react](https://github.com/nitin42/terminal-in-react): <sub>👨‍💻 A component that renders a terminal</sub>
- [coreui/coreui-free-react-admin-template](https://github.com/coreui/coreui-free-react-admin-template): <sub>CoreUI React is free React admin template based on Bootstrap 4 https://coreui.io/react</sub>
- [bumbag/bumbag-ui](https://github.com/bumbag/bumbag-ui): <sub>Build accessible & themeable React applications with your Bumbag 👝 https://bumbag.style</sub>
- [fakiolinho/react-loading](https://github.com/fakiolinho/react-loading): <sub>React component for loading animations</sub>

### 工具类插件

- [react-beautiful-dnd](https://github.com/atlassian/react-beautiful-dnd): <sub>Beautiful, accessible drag and drop for lists with React.js</sub>
- [Redux Form](https://redux-form.com/): <sub>The best way to manage your form state in Redux.</sub>
- [React Navigation](https://reactnavigation.org/): <sub>Navigation for React Native</sub>
- [react-spring](https://github.com/drcmda/react-spring): <sub>🙌 Helping react-motion and animated to become best friends http://react-spring.surge.sh/</sub>
- [Reach Router](https://github.com/reach/router): <sub>Next Generation Routing for React</sub>
- [jamiebuilds/react-loadable](https://github.com/jamiebuilds/react-loadable): <sub>⏳ A higher order component for loading components with promises.</sub>
- [react-admin](https://github.com/marmelab/react-admin): <sub>A frontend framework for building admin SPAs on top of REST services, using React and Material Design http://marmelab.com/react-admin</sub>
- [react-virtualized](https://github.com/bvaughn/react-virtualized): <sub>React components for efficiently rendering large lists and tabular data http://www.reactvirtualized.com</sub>
- [react-intl](https://github.com/yahoo/react-intl): <sub>Internationalize React apps. This library provides React components and an API to format dates, numbers, and strings, including pluralization and handling translations.</sub>
- [deepsweet/hocs](https://github.com/deepsweet/hocs): <sub>🍱 A collection of Higher-Order Components for React and React Native</sub>
- [jaredpalmer/after.js](https://github.com/jaredpalmer/after.js): <sub>Next.js-like framework for server-rendered React apps built with React Router 4</sub>
- [react-flame-graph](https://github.com/bvaughn/react-flame-graph): <sub>React component for visualizing profiling data</sub>
- [joshwcomeau/guppy](https://github.com/joshwcomeau/guppy): <sub>🐠A friendly application manager and task runner for React.js</sub>
- [alidcastano/rogue.js](https://github.com/alidcastano/rogue.js): <sub>Rogue.js - a nearly invisible framework for creating server-rendered React applications</sub>
- [react-color](https://github.com/casesandberg/react-color): <sub>🎨 Color Pickers from Sketch, Photoshop, Chrome, Github, Twitter & more</sub>
- [grid-styled](https://github.com/jxnblk/grid-styled): <sub>Responsive React grid system built with styled-system https://jxnblk.com/grid-styled/ </sub>
- [react-google-charts](https://github.com/rakannimer/react-google-charts): <sub>A thin, typed, React wrapper over Google Charts Visualization and Charts API. https://react-google-charts.com/</sub>
- [react-move](https://github.com/react-tools/react-move): <sub>React Move 🌀 Beautiful, data-driven animations for React https://react-move.js.org</sub>
- [react-motion](https://github.com/chenglou/react-motion): <sub>A spring that solves your animation problems.</sub>
- [react-pdf](https://github.com/diegomura/react-pdf): <sub>📄 Create PDF files using React</sub>
- [swr](https://github.com/zeit/swr): <sub>React Hooks library for remote data fetching https://swr.now.sh</sub>
- [prevwong/craft.js](https://github.com/prevwong/craft.js): <sub>🚀 A React Framework for building extensible drag and drop page editors</sub>
- [react-three-fiber](https://github.com/pmndrs/react-three-fiber): <sub>🇨🇭 A React renderer for Three.js (web and react-native)</sub>

## 周边篇

- [crana](https://github.com/scriptify/crana): <sub>✨ CReate A Node Application: A CLI tool to create React + Node apps with just one command</sub>
- [create-react-app](https://github.com/facebook/create-react-app): <sub>Create React apps with no build configuration.</sub>
- [create-react-app-typescript](https://github.com/wmonk/create-react-app-typescript): <sub>Create React apps using typescript with no build configuration. </sub>
- [roadhog](https://github.com/sorrycc/roadhog): <sub>🐷 Cli tool for creating react apps, configurable version of create-react-app.</sub>
- [react-static](https://github.com/nozzle/react-static): <sub>⚛️ 🚀 A progressive static site generator for React.</sub>
- [create-react-app-buildpack](https://github.com/mars/create-react-app-buildpack): <sub>⚛️ Heroku Buildpack for create-react-app: static hosting for React.js web apps</sub>
- [umijs/umi](https://github.com/umijs/umi): <sub>🌋 Pluggable enterprise-level react application framework. https://umijs.org/ </sub>
- [jaredpalmer/razzle](https://github.com/jaredpalmer/razzle): <sub>✨ Create server-rendered universal JavaScript applications with no configuration</sub>
- [gsoft-inc/craco](https://github.com/gsoft-inc/craco): <sub>Create React App Configuration Override, an easy and comprehensible configuration layer for create-react-app</sub>
