**导语**：[Python](https://www.python.org/) 是一种易于学习又功能强大的编程语言。它提供了高效的高级数据结构，还能简单有效地面向对象编程。它优雅的语法和动态类型，以及解释型语言的本质，使它成为多数平台上写脚本，以及快速开发应用的理想语言。

[Python](https://www.python.org/) 在诞生之初，因为其功能不好，运转功率低，不支持多核，根本没有并发性可言，在计算功能不那么好的年代，一直没有火爆起来，甚至很多人根本不知道有这门语言。随着时代的发展，物理硬件功能不断提高，而软件的复杂性也不断增大，开发效率越来越被企业重视，因此，Python 逐渐得到越来越多开发者的亲睐；在 12~14 年，云计算升温，大量创业公司和互联网巨头挤进云计算领域，[Python](https://www.python.org/) 就此异军突起；随后几年，备受关注的**人工智能**、**机器学习**、**数据科学**、**机器人**，其首选开发语言也是 Python。至此，Python 炙手可热，成为最受欢迎编程语言之一。

[Python](https://www.python.org/) 不仅入门容易、功能强大；而且适用领域极为广泛；对于前端工程师而言，使用它能够很容易构建 Web 应用，依托于它强大的功能库，也能快速打造些趁手工具；随着大前端的日益演进，在完成模块化、工程化之后，走向自动化、智能化也是必然趋势；鉴于这一点，则更有必要对 [Python](https://www.python.org/)、算法、数学等加以学习（于 2019 年 12 月 22 日）。

## 基础篇

- [Python 官方网站](https://www.python.org/)
- [Python 官方中文教程](https://docs.python.org/zh-cn/3/tutorial/index.html)
- [Python 基础教程 | 菜鸟](https://www.runoob.com/python/python-tutorial.html)
- [Asabeneh/30-Days-Of-Python](https://github.com/Asabeneh/30-Days-Of-Python): <sub>30 days of Python programming challenge is a step by step guide to learn Python programming language in 30 days.</sub>
- [The Hitchhiker’s Guide to Python!](https://docs.python-guide.org/)
- [Python - 100 天从新手到大师](https://github.com/jackfrued/Python-100-Days)
- [中文 Python 笔记](https://github.com/lijin-THU/notes-python)
- [Python 教程 | Github](https://github.com/geekcomputers/Python)
- [良心的 Python 教程 | Github](https://github.com/TwoWater/Python)
- [Comprehensive Python Cheatsheet](https://github.com/gto76/python-cheatsheet)

### 工具篇

- Python 环境管理工具
  - [pypa/pipenv](https://github.com/pypa/pipenv): <sub>Python Development Workflow for Humans.</sub>
  - [pyenv/pyenv](https://github.com/pyenv/pyenv): <sub>Simple Python version management</sub>
  - [pypa/pip](https://github.com/pypa/pip): <sub>The Python package installer https://pip.pypa.io</sub>
  - [utahta/pythonbrew](https://github.com/utahta/pythonbrew): <sub>Python Environment manager</sub>
- 生产力工具
  - [psf/black](https://github.com/psf/black): <sub>The uncompromising Python code formatter.</sub>
  - [google/yapf](https://github.com/google/yapf): <sub>A formatter for Python files</sub>
  - [cookiecutter/cookiecutter](https://github.com/cookiecutter/cookiecutter): <sub>A command-line utility that creates projects from cookiecutters (project templates), e.g. Python package projects, jQuery plugin projects.</sub>
  - [nvbn/thefuck](https://github.com/nvbn/thefuck): <sub>Magnificent app which corrects your previous console command.</sub>
  - [sloria/doitlive](https://github.com/sloria/doitlive): <sub>doitlive is a tool for live presentations in the terminal. It reads a file of shell commands and replays the commands in a fake terminal session as you type random characters.</sub>
  - [facebook/PathPicker](https://github.com/facebook/PathPicker): <sub>PathPicker accepts a wide range of input -- output from git commands, grep results, searches -- pretty much anything.After parsing the input, PathPicker presents you with a nice UI to select which files you're interested in.</sub>
  - [mooz/percol](https://github.com/mooz/percol): <sub>adds flavor of interactive filtering to the traditional pipe concept of UNIX shell</sub>
- 有用工具库
  - [timothycrosley/isort](https://github.com/timothycrosley/isort): <sub>A Python utility / library to sort imports.</sub>
  - [pyecharts/pyecharts](https://github.com/pyecharts/pyecharts): <sub>🎨 Python Echarts Plotting Library</sub>
  - [lincolnloop/python-qrcode](https://github.com/lincolnloop/python-qrcode): <sub>Python QR Code image generator</sub>
  - [python-prompt-toolkit](https://github.com/prompt-toolkit/python-prompt-toolkit): <sub>Library for building powerful interactive command line applications in Python</sub>
  - [xlwings/xlwings](https://github.com/xlwings/xlwings): <sub>xlwings is a BSD-licensed Python library that makes it easy to call Python from Excel and vice versa. It works with Microsoft Excel on Windows and Mac.</sub>
  - [psf/requests](https://github.com/psf/requests): <sub>A simple, yet elegant HTTP library.</sub>
  - [gnebbia/kb](https://github.com/gnebbia/kb): <sub>A minimalist command line knowledge base manager</sub>
  - [willmcgugan/rich](https://github.com/willmcgugan/rich): <sub>Rich is a Python library for rich text and beautiful formatting in the terminal.</sub>
  - [amueller/word_cloud](https://github.com/amueller/word_cloud): <sub>A little word cloud generator in Python</sub>

### 示例篇

- [30-seconds-of-python](https://github.com/30-seconds/30-seconds-of-python): <sub>Short Python code snippets for all your development needs</sub>
- [geekcomputers/Python](https://github.com/geekcomputers/Python): <sub>My Python Examples</sub>
- [nicejade/play-with-python](https://github.com/nicejade/play-with-python): <sub>学习 Python & 实战练习，以便能更好的玩 Python 相关技能、工具。</sub>
- [eat_tensorflow2_in_30_days](https://github.com/lyhue1991/eat_tensorflow2_in_30_days): <sub>Tensorflow2.0 🍎🍊 is delicious, just eat it! 😋😋</sub>
- [examples-of-web-crawlers](https://github.com/shengqiangzhang/examples-of-web-crawlers): <sub>一些非常有趣的 python 爬虫例子,对新手比较友好,主要爬取淘宝、天猫、微信、豆瓣、QQ 等网站。(Some interesting examples of python crawlers that are friendly to beginners. </sub>
- [interesting-python](https://github.com/Alfred1984/interesting-python): <sub>有趣的 Python 爬虫和 Python 数据分析小项目</sub>
- [realpython/python-guide](https://github.com/realpython/python-guide): <sub>Python best practices guidebook, written for humans. 中文版：[Python 最佳实践指南](https://github.com/Prodesire/Python-Guide-CN)</sub>
- [trekhleb/learn-python](https://github.com/trekhleb/learn-python): <sub>📚 Playground and cheatsheet for learning Python. Collection of Python scripts that are split by topics and contain code examples with explanations.</sub>
- [jackzhenguo/python-small-examples](https://github.com/jackzhenguo/python-small-examples): <sub>Python 有趣的小例子一网打尽。Python 基础、Python 坑点、Python 字符串和正则、Python 绘图、Python 日期和文件、Web 开发、数据科学、机器学习、深度学习、TensorFlow、Pytorch，一切都是简单易懂的小例子。</sub>
- [zhaipro/easy12306](https://github.com/zhaipro/easy12306): <sub>使用机器学习算法完成对 12306 验证码的自动识别</sub>
- [tangyudi/Ai-learn](https://github.com/tangyudi/Ai-learn): <sub>人工智能学习路线图，整理近 200 个实战案例与项目，免费提供配套教材，零基础入门，就业实战！包括：Python，数学，机器学习，数据分析，深度学习，计算机视觉，自然语言处理等热门领域</sub>

### 资源篇

- [vinta/awesome-python](https://github.com/vinta/awesome-python): <sub>A curated list of awesome Python frameworks, libraries, software and resources https://awesome-python.com</sub>
- [jobbole/awesome-python-cn](https://github.com/jobbole/awesome-python-cn): <sub>Python 资源大全中文版，包括：Web 框架、网络爬虫、模板引擎、数据库、数据可视化、图片处理等，由伯乐在线持续更新。</sub>
- [100-Days-Of-ML-Code](https://github.com/MLEveryday/100-Days-Of-ML-Code): <sub>100-Days-Of-ML-Code 中文版</sub>
- [burness/tensorflow-101](https://github.com/burness/tensorflow-101): <sub>learn code with tensorflow.</sub>
- [gto76/python-cheatsheet](https://github.com/gto76/python-cheatsheet): <sub>Comprehensive Python Cheatsheet</sub>
- [mahmoud/awesome-python-applications](https://github.com/mahmoud/awesome-python-applications): <sub>💿 Free software that works great, and also happens to be open-source Python. </sub>
- [dloss/python-pentest-tools](https://github.com/dloss/python-pentest-tools): <sub>Python tools for penetration testers</sub>

## 进阶篇

- [interactive-coding-challenges](https://github.com/donnemartin/interactive-coding-challenges): <sub>120+ interactive Python coding interview challenges (algorithms and data structures). Includes Anki flashcards.</sub>
- [TheAlgorithms/Python](https://github.com/TheAlgorithms/Python): <sub>All algorithms implemented in Python (for education)</sub>
- [faif/python-patterns](https://github.com/faif/python-patterns): <sub>A collection of design patterns/idioms in Python</sub>
- [bregman-arie/devops-exercises](https://github.com/bregman-arie/devops-exercises): <sub>Linux, Jenkins, AWS, SRE, Prometheus, Docker, Python, Ansible, Git, Kubernetes, Terraform, OpenStack, SQL, NoSQL, Azure, GCP, DNS, Elastic, Network, Virtualization</sub>
- [TheAlgorithms/Python](https://github.com/TheAlgorithms/Python): <sub>All Algorithms implemented in Python https://travis-ci.com/TheAlgorithms/Python</sub>
- [leisurelicht/wtfpython-cn](https://github.com/leisurelicht/wtfpython-cn): <sub>一些有趣且鲜为人知的 Python 特性.</sub>

## 深度学习

- [tensorflow/tensorflow](https://github.com/tensorflow/tensorflow): <sub>An Open Source Machine Learning Framework for Everyone https://tensorflow.org</sub>
- [tensorflow/models](https://github.com/tensorflow/models): <sub>Models and examples built with TensorFlow</sub>
- [tensorflow/graphics](https://github.com/tensorflow/graphics): <sub>TensorFlow Graphics: Differentiable Graphics Layers for TensorFlow</sub>
- [google/trax](https://github.com/google/trax): <sub>Trax — your path to advanced deep learning</sub>
- [lutzroeder/netron](https://github.com/lutzroeder/netron): <sub>Visualizer for neural network, deep learning, and machine learning models https://www.lutzroeder.com/netron</sub>
- [fastai/fastai](https://github.com/fastai/fastai): <sub>The fastai deep learning library, plus lessons and tutorials http://docs.fast.ai</sub>
- [keras-team/keras](https://github.com/keras-team/keras): <sub>Deep Learning for humans http://keras.io</sub>
- [BVLC/caffe](https://github.com/BVLC/caffe): <sub>Caffe: a fast open framework for deep learning.</sub>
- [pytorch/pytorch](https://github.com/pytorch/pytorch): <sub>Tensors and Dynamic neural networks in Python with strong GPU acceleration https://pytorch.org</sub>
- [apache/incubator-mxnet](https://github.com/apache/incubator-mxnet): <sub>Apache MXNet (incubating) for Deep Learning</sub>
- [tensorlayer/tensorlayer](https://github.com/tensorlayer/tensorlayer): <sub>Deep Learning and Reinforcement Learning Library for Scientists 🔥</sub>
- [google/trax](https://github.com/google/trax): <sub>Trax — your path to advanced deep learning</sub>
- [openai/spinningup](https://github.com/openai/spinningup): <sub>An educational resource to help anyone learn deep reinforcement learning.</sub>
- [microsoft/DeepSpeed](https://github.com/microsoft/DeepSpeed): <sub>DeepSpeed is a deep learning optimization library that makes distributed training easy, efficient, and effective.</sub>

## 机器学习

- [fchollet/deep-learning-with-python-notebooks](https://github.com/fchollet/deep-learning-with-python-notebooks): <sub>Jupyter notebooks for the code samples of the book "Deep Learning with Python"</sub>
- [rasbt/python-machine-learning-book](https://github.com/rasbt/python-machine-learning-book): <sub>Python Machine Learning book code repository</sub>
- [scikit-learn/scikit-learn](https://github.com/scikit-learn/scikit-learn): <sub>scikit-learn: machine learning in Python https://scikit-learn.org</sub>
- [dmlc/xgboost](https://github.com/dmlc/xgboost): <sub>Scalable, Portable and Distributed Gradient Boosting (GBDT, GBRT or GBM) Library, for Python, R, Java, Scala, C++ and more. Runs on single machine, Hadoop, Spark, Flink and DataFlow https://xgboost.ai</sub>
- [tensorlayer/tensorlayer](https://github.com/tensorlayer/tensorlayer): <sub>Deep Learning and Reinforcement Learning Library for Scientists 🔥</sub>
- [mlflow/mlflow](https://github.com/mlflow/mlflow): <sub>Open source platform for the machine learning lifecycle https://mlflow.org</sub>
- [OpenMined/PySyft](https://github.com/OpenMined/PySyft): <sub>A library for encrypted, privacy preserving machine learning</sub>
- [Unity-Technologies/ml-agents](https://github.com/Unity-Technologies/ml-agents): <sub>Unity Machine Learning Agents Toolkit https://unity3d.ai</sub>

## 机器人

- [python-telegram-bot](https://github.com/python-telegram-bot/python-telegram-bot): <sub>We have made you a wrapper you can't refuse https://python-telegram-bot.org</sub>
- [gunthercox/ChatterBot](https://github.com/gunthercox/ChatterBot): <sub>ChatterBot is a machine learning, conversational dialog engine for creating chat bots.</sub>
- [sfyc23/EverydayWechat](https://github.com/sfyc23/EverydayWechat): <sub>微信助手：1.每日定时给好友（女友）发送定制消息。2.机器人自动回复好友。3.群助手功能（例如：查询垃圾分类、天气、日历、电影实时票房、快递物流、PM2.5 等）</sub>

## 自动化

- [microsoft/playwright-python](https://github.com/microsoft/playwright-python): <sub>Python version of the Playwright testing and automation library. https://playwright.dev/</sub>

## 数据科学

- [pandas-dev/pandas](https://github.com/pandas-dev/pandas): <sub>powerful Python data analysis toolkit.</sub>
- [biolab/orange3](https://github.com/biolab/orange3): <sub>🍊 📊 💡 Orange: Interactive data analysis https://orange.biolab.si</sub>
- [jakevdp/PythonDataScienceHandbook](https://github.com/jakevdp/PythonDataScienceHandbook): <sub>Python Data Science Handbook: full text in Jupyter Notebooks</sub>

## 周边篇

- [docker-library/python](https://github.com/docker-library/python): <sub>Docker Official Image packaging for Python</sub>
- [google/python-fire](https://github.com/google/python-fire): <sub>Python Fire is a library for automatically generating command line interfaces (CLIs) from absolutely any Python object.</sub>
- [Miserlou/Zappa](https://github.com/Miserlou/Zappa): <sub>Serverless Python https://blog.zappa.io</sub>
- [google-api-python-client](https://github.com/googleapis/google-api-python-client): <sub>🐍 The official Python client library for Google's discovery based APIs. </sub>
- [donnemartin/system-design-primer](https://github.com/donnemartin/system-design-primer): <sub>Learn how to design large-scale systems. Prep for the system design interview. Includes Anki flashcards.</sub>

## 相关工具库

- [mherrmann/helium](https://github.com/mherrmann/helium): <sub>Selenium-python, 50% easier. Helium is the best Python library for web automation.</sub>
- [locustio/locust](https://github.com/locustio/locust): <sub>Scalable user load testing tool written in Python</sub>
- [joeyespo/grip](https://github.com/joeyespo/grip): <sub>Preview GitHub Markdown files like Readme locally before committing them.</sub>
- [lancopku/pkuseg-python](https://github.com/lancopku/pkuseg-python): <sub>pkuseg 多领域中文分词工具; The pkuseg toolkit for multi-domain Chinese word segmentation</sub>
- [home-assistant/home-assistant](https://github.com/home-assistant/home-assistant): <sub>🏡 Open source home automation that puts local control and privacy first</sub>
- [jakubroztocil/httpie](https://github.com/jakubroztocil/httpie): <sub>As easy as HTTPie /aitch-tee-tee-pie/ 🥧 Modern command line HTTP client – user-friendly curl alternative with intuitive UI, JSON support, syntax highlighting, wget-like downloads, extensions, etc.</sub>
- [django/django](https://github.com/django/django): <sub>The Web framework for perfectionists with deadlines. https://djangoproject.com</sub>
- [3b1b/manim](https://github.com/3b1b/manim): <sub>Animation engine for explanatory math videos</sub>
- [gwen001/pentest-tools](https://github.com/gwen001/pentest-tools): <sub>Custom pentesting tools</sub>
