## 基础篇

- [nodejs/nodejs.dev](https://github.com/nodejs/nodejs.dev): <sub>A new Node.js resource built using Gatsby.js with React.js, TypeScript, Emotion, and Remark.</sub>
- [Node.js API 文档](http://nodejs.cn/api/)
- [Node 初学者入门](http://www.nodebeginner.org/index-zh-cn.html)
- [Node.js 包教不包会](https://github.com/alsotang/node-lessons)
- [七天学会 NodeJS](https://github.com/nqdeng/7-days-nodejs)
- [从零开始 NodeJS 系列文章](http://blog.fens.me/series-nodejs)
- [Node.js Tutorials for Beginners](https://blog.risingstack.com/tag/node-js-tutorials-for-beginners/)
- [Nodejs 学习笔记以及经验总结](https://github.com/chyingp/nodejs-learning-guide)
- [[ 全文 ] 如何正确的学习 Node.js](https://github.com/i5ting/How-to-learn-node-correctly)

## 进阶篇

- [yjhjstz/deep-into-node](https://github.com/yjhjstz/deep-into-node): <sub>深入理解 Node.js：核心思想与源码分析</sub>
- [Node.js Tutorials and Resources](https://blog.risingstack.com/)
- [NodeJS 的代码调试和性能调优](http://www.barretlee.com/blog/2015/10/07/debug-nodejs-in-command-line)
- [理解 NodeJS](http://debuggable.com/posts/understanding-node-js:4bd98440-45e4-4a9a-8ef7-0f7ecbdd56cb)
- [NodeJS 事件轮询](http://blog.mixu.net/2011/02/01/understanding-the-node-js-event-loop)
- [Advanced Node.js Tutorials](https://blog.risingstack.com/tag/advanced-node-js-tutorials/)
- [Node.js with Microservices](https://blog.risingstack.com/tag/node-js-with-microservices/)
- [Node.js Async Function Best Practices](https://nemethgergely.com/async-function-best-practices/)
- [Implementing JavaScript Functors and Monads](https://medium.com/front-end-hacking/implementing-javascript-functors-and-monads-a87b6a4b4d9a)
- [Node 定时器详解](http://www.ruanyifeng.com/blog/2018/02/node-event-loop.html)
- [Node.js 专栏](https://yuque.com/egg/nodejs): <sub>来自 egg.js 团队的 Node.js 经验分享</sub>
- [stream-handbook](https://github.com/substack/stream-handbook): <sub>how to write node programs with streams</sub>
- [Authenticate a Node ES6 API with JSON Web Tokens](https://scotch.io/tutorials/authenticate-a-node-es6-api-with-json-web-tokens)

## 安全篇

- [Node Hero - Node.js Security Tutorial](https://blog.risingstack.com/node-hero-node-js-security-tutorial/)
- **[Node.js Security Checklist](https://blog.risingstack.com/node-js-security-checklist/)**

## Node.js Awesome List

- [Awesome Awesome Node.js](https://github.com/bnb/awesome-awesome-nodejs): <sub>🐢🚀 An Awesome list of Awesome lists related to Node.js.</sub>
- [awesome-nodejs](https://github.com/sindresorhus/awesome-nodejs): <sub>⚡️ Delightful Node.js packages and resources https://node.cool</sub>
- [nodebestpractices](https://github.com/goldbergyoni/nodebestpractices): <sub>✅ The largest Node.js best practices list (December 2019)</sub>

## 框架篇

### EggJs

- [eggjs](https://github.com/eggjs/egg): <sub>🥚 Born to build better enterprise frameworks and apps with Node.js & Koa https://eggjs.org</sub>
  - [ykfe/egg-react-ssr](https://github.com/ykfe/egg-react-ssr): <sub>最小而美的 Egg + React + SSR 服务端渲染应用骨架，同时支持 JS 和 TS https://ykfe.surge.sh</sub>

### fastify

- [fastify](https://github.com/fastify/fastify): <sub>Fast and low overhead web framework, for Node.js https://www.fastify.io</sub>

### nest

- [nestjs/nest](https://github.com/nestjs/nest): <sub>A progressive Node.js framework for building efficient, scalable, and enterprise-grade server-side applications on top of TypeScript & JavaScript (ES6, ES7, ES8) 🚀 https://nestjs.com</sub>

### Hapi

- [Hapi.js](https://github.com/hapijs/hapi): <sub>Server Framework for Node.js https://hapijs.com</sub>

### KoaJs

- [Koajs](http://koajs.com/): next generation web framework for node.js
- [koa2-note](https://github.com/chenshenhai/koa2-note): <sub>《Koa2 进阶学习笔记》</sub>
- [Koa 框架教程](http://www.ruanyifeng.com/blog/2017/08/koa.html)

### MeteorJs

- [Meteorjs](https://www.meteor.com/): THE FASTEST WAY TO BUILD JAVASCRIPT APPS

### ExpressJs

- [Expressjs](https://expressjs.com/): Fast, unopinionated, minimalist web framework for Node.js

### SailsJs

- [Sailsjs](https://sailsjs.com): Realtime MVC Framework for Node.js

### NestJs

- [Nestjs](https://nestjs.com/): A progressive Node.js framework for building efficient and scalable server-side applications on top of TypeScript & JavaScript (ES6 / ES7 / ES8) heavily inspired by Angular 🚀 ⚡️

### Backpack

- [jaredpalmer/backpack](https://github.com/jaredpalmer/backpack): <sub>🎒 Backpack is a minimalistic build system for Node.js projects.</sub>

## 资讯篇

- [williamkapke/node-compat-table](https://github.com/williamkapke/node-compat-table): <sub>node.green - Node.js ECMAScript compatibility tables</sub>
- [NodeJS 10: The New, The Changed, and the Deprecated](https://auth0.com/blog/nodejs-10-new-changes-deprecations/)
- [Node.js Best Practices - How to become a better Node.js developer in 2018](https://nemethgergely.com/nodejs-best-practices-how-to-become-a-better-developer-in-2018/)
- [Node.js as Backend: Best Use Cases, Tools & Limitations](https://medium.com/dailyjs/node-js-as-backend-best-use-cases-tools-limitations-9c65165a5bac)
- [12 common JavaScript questions answered](http://www.creativebloq.com/features/12-common-javascript-questions-answered)

## 调试

- [node-inspector/node-inspector](https://github.com/node-inspector/node-inspector): <sub>Node.js debugger based on Blink Developer Tools</sub>

## 版本管理工具

- [nvm-sh/nvm](https://github.com/nvm-sh/nvm): <sub>Node Version Manager - POSIX-compliant bash script to manage multiple active node.js versions</sub>
- [tj/n](https://github.com/tj/n): <sub>Node version management</sub>
- [Schniz/fnm](https://github.com/Schniz/fnm): <sub>🚀 Fast and simple Node.js version manager, built in Rust</sub>

## 有用的库

### 终端

- [nicejade/arya-jarvis](https://github.com/nicejade/arya-jarvis): <sub>🛠 Designed to save developers more time and energy. https://arya.lovejade.cn/</sub>
- [oclif/oclif](https://github.com/oclif/oclif): <sub>Node.js Open CLI Framework. Built with 💜 by Heroku.</sub>
- [carloscuesta/gitmoji-cli](https://github.com/carloscuesta/gitmoji-cli): <sub>A gitmoji interactive command line tool for using emojis on commits. 💻</sub>
- [nexe/nexe](https://github.com/nexe/nexe): <sub>🎉 create a single executable out of your node.js apps</sub>
- [updtr](https://github.com/peerigon/updtr): <sub>Update outdated npm modules with zero pain™</sub>
- [typescript-starter](https://github.com/bitjson/typescript-starter): <sub>Quickly create and configure a new library or Node.js project</sub>
- [screenshoteer](https://github.com/vladocar/screenshoteer): <sub>Makes web screenshots and mobile emulations from the command line.</sub>
- [antonmedv/fx](https://github.com/antonmedv/fx): <sub>Command-line JSON processing tool 🔥</sub>
- [nodejs-dashboard ](https://github.com/FormidableLabs/nodejs-dashboard): <sub>Telemetry dashboard for node.js apps from the terminal!</sub>
- [local-web-server](https://github.com/lwsjs/local-web-server): <sub>The modular HTTP2 web server for productive full-stack development</sub>
- [how2](https://github.com/santinic/how2): <sub>stackoverflow from the terminal</sub>
- [is-up-cli](https://github.com/sindresorhus/is-up-cli): <sub>Check whether a website is up or down</sub>
- [fast-cli](https://github.com/sindresorhus/fast-cli): <sub>Test your download and upload speed using fast.com</sub>
- [favicon-emoji](https://github.com/albinekb/favicon-emoji): <sub>🖼 Generate an emoji-favicon in your terminal</sub>
- [nagibabel.js](https://github.com/fual/nagibabel.js): <sub>nagibabel.js is a blazing fast, zero configuration tool to remove bad code from your project.</sub>
- [npm-check](https://github.com/dylang/npm-check): <sub>Check for outdated, incorrect, and unused dependencies. </sub>
- [nativefier](https://github.com/jiahaog/nativefier): <sub>Make any web page a desktop application.</sub>
- [Inquirer](https://github.com/SBoudrias/Inquirer.js): <sub>A collection of common interactive command line user interfaces.</sub>
- [sindresorhus/ora](https://github.com/sindresorhus/ora): <sub>Elegant terminal spinner</sub>
- [release-it](https://github.com/release-it/release-it): <sub>🚀 Automate versioning and package publishing</sub>
- [ReLaXed](https://github.com/RelaxedJS/ReLaXed): <sub>Create PDF documents using web technologies</sub>
- [documentation](https://github.com/documentationjs/documentation): <sub>📖 documentation for modern JavaScript http://documentation.js.org</sub>
- [voidcosmos/npkill](https://github.com/voidcosmos/npkill): <sub>List any node_modules directories in your system, as well as the space they take up. You can then select which ones you want to erase to free up space.</sub>
- [sindresorhus/terminal-image](https://github.com/sindresorhus/terminal-image): <sub>Display images in the terminal</sub>

#### For CLI Library

- [commander.js](https://github.com/tj/commander.js/): <sub>node.js command-line interfaces made easy</sub>
- [js-fire](https://github.com/hobochild/js-fire): <sub>A javascript clone of google/python-fire 🔥</sub>
- [sindresorhus/ora](https://github.com/sindresorhus/ora): <sub>Elegant terminal spinner</sub>
- [chalk](https://github.com/chalk/chalk): <sub>🖍 Terminal string styling done right.</sub>
- [sindresorhus/log-update](https://github.com/sindresorhus/log-update): <sub>Log by overwriting the previous output in the terminal. Useful for rendering progress bars, animations, etc.</sub>

### 非终端

- [carlo](https://github.com/GoogleChromeLabs/carlo): <sub>Web rendering surface for Node applications</sub>
- [pill](https://github.com/rumkin/pill): <sub>Add dynamic content loading to static sites with only 1 KiB of JS</sub>
- [microjob](https://github.com/wilk/microjob): <sub>A tiny wrapper for turning Node.js worker threads into easy-to-use routines for heavy CPU loads. https://wilk.github.io/microjob/</sub>
- [yargs](https://github.com/yargs/yargs): <sub>yargs the modern, pirate-themed successor to optimist. http://yargs.js.org/</sub>
- [shelljs](https://github.com/shelljs/shelljs): <sub>🐚 Portable Unix shell commands for Node.js http://shelljs.org</sub>
- [server.js](https://github.com/franciscop/server): <sub>🖥 Simple and powerful server for Node.js https://serverjs.io/</sub>
- [node-qrcode](https://github.com/soldair/node-qrcode): <sub>qr code generator</sub>
- [jsdom](https://github.com/jsdom/jsdom): <sub>A JavaScript implementation of the WHATWG DOM and HTML standards, for use with node.js</sub>
- [taiko](https://github.com/getgauge/taiko): <sub>A node.js library to automate chrome/chromium browser https://taiko.gauge.org/</sub>
- [randexp.js](https://github.com/fent/randexp.js): <sub>Create random strings that match a given regular expression. </sub>
- [pino](https://github.com/pinojs/pino): <sub>🌲 super fast, all natural json logger 🌲 http://getpino.io</sub>
- [nodegit](https://github.com/nodegit/nodegit): <sub>Native Node bindings to Git. https://nodegit.org</sub>
- [gpu.js](https://github.com/gpujs/gpu.js): <sub>GPU Accelerated JavaScript https://gpu.rocks</sub>
- [agenda](https://github.com/agenda/agenda): <sub>Lightweight job scheduling for Node.js http://agendajs.com | [Agenda Dashboard](https://github.com/agenda/agendash)</sub>
- [google-auth-library-nodejs](https://github.com/googleapis/google-auth-library-nodejs): <sub>🔑 Google Auth Library for Node.js</sub>
- [tinify/tinify-nodejs](https://github.com/tinify/tinify-nodejs): <sub>Node.js client for the Tinify API.</sub>
- [web-push-libs/web-push](https://github.com/web-push-libs/web-push): <sub>Web Push library for Node.js</sub>

- [capture-website](https://github.com/sindresorhus/capture-website): <sub>Capture screenshots of websites</sub>

- [pikapkg/web](https://github.com/pikapkg/web): <sub>📦 ✨ Run npm dependencies directly in the browser. No Browserify, Webpack or import maps required.</sub>
- [depcheck](https://github.com/depcheck/depcheck): <sub>Check your npm module for unused dependencies</sub>
