**导语 :** [Markdown](https://zh.wikipedia.org/wiki/Markdown) 是一种轻量级的「标记语言」，旨在简洁、高效；它的优点很多，目前也被越来越多的写作爱好者、撰稿者广泛使用。看到这里，请不要被「标记」、「语言」所迷惑，Markdown 的语法十分简单。常用的标记符号也不超过十个，这种相对于更为复杂的 HTML 标记语言来说，Markdown 可谓是十分轻量的，学习成本极低，且一旦熟悉这种语法规则，会有一劳永逸的效果。有百千种资源平台以供使用的同时，也衍生出越来越多开源库，可供我们在代码中调用。

#### 入门技巧

- [认识与入门 Markdown](https://sspai.com/post/25137)
- [**Cmd Markdown 简明语法手册**](https://www.zybuluo.com/mdeditor?url=https://www.zybuluo.com/static/editor/md-help.markdown#cmd-markdown-简明语法手册)
- [**Cmd Markdown 高阶语法手册**](https://www.zybuluo.com/mdeditor?url=https://www.zybuluo.com/static/editor/md-help.markdown#cmd-markdown-高阶语法手册)
- [Markdown 入门参考](https://github.com/LearnShare/Learning-Markdown/blob/master/README.md)
- [Cmd Markdown 公式指导手册](https://www.zybuluo.com/codeep/note/163962)
- [关于 Markdown 的一些奇技淫巧](https://github.com/mzlogin/mzlogin.github.io/blob/master/_posts/2017-09-01-markdown-odd-skills.md)

#### 资源平台

- [markdown-online-editor](https://github.com/nicejade/markdown-online-editor): <sub>📝 基于 Vue、Vditor，所构建的在线 Markdown 编辑器，支持流程图、甘特图、时序图、任务列表、HTML 自动转换为 Markdown 等功能。</sub>
- [MarkEditor](https://nicelinks.site/post/5b055142e93ed2618cfac124): <sub>好的写作体验，更好的效率利器</sub>
- [作业部落 - 功能强大，速度流畅，全平台同步](https://nicelinks.site/post/5a5114df0b0ec0396863d7c1): <sub>Cmd Markdown 编辑阅读器，支持实时同步预览，区分写作和阅读模式，支持在线存储，分享文稿网址。</sub>
- [Stackedit- 国外的在线 markdown 编辑器，功能强大，同步云盘](https://stackedit.io)
- [Gitbook- 国外的在线 markdown 可编辑成书](https://www.gitbook.com)
- [微信公众号排版编辑器](https://github.com/lyricat/wechat-format): <sub>转化 Markdown 到给微信特制的 HTML</sub>
- [Typora](https://nicelinks.site/post/5cbc58707855f80ea42ea6a7): <sub>Typora is a cross-platform minimal markdown editor, providing seamless experience for both markdown readers and writers.</sub>
- [notable](https://github.com/notable/notable): <sub>The markdown-based note-taking app that doesn't suck.</sub>
- [vnote](https://github.com/tamlok/vnote): <sub>A Vim-inspired note-taking application that knows programmers and Markdown better. https://tamlok.github.io/vnote</sub>
- [lepture-editor](https://github.com/lepture/editor)
- [Markdown-editor](https://github.com/jbt/markdown-editor)
- [notable](https://github.com/fabiospampinato/notable): <sub>The markdown-based note-taking app that doesn't suck.</sub>
- [简书 - 创作社区](https://www.jianshu.com/)
- [**marktext**](https://github.com/marktext/marktext): <sub>📝Next generation markdown editor, running on platforms of MacOS Windows and Linux. https://marktext.github.io/website/</sub>
- [FarBox](https://www.farbox.com/): <sub>The Best Blog Platform for Humans.FarBox, Dropbox Blog, Blog on Cloud </sub>
- [Atom](https://atom.io/): <sub>A hackable text editor for the 21st Century. 具体可参见 : [新编码神器 Atom 使用纪要](https://jeffjade.com/2016/03/03/2016-03-02-how-to-use-atom/)</sub>
- [Sublime Text](https://www.sublimetext.com/): <sub>A sophisticated text editor for code, markup and prose. 具体可参见 [SublimeText 下写作利器之 MarkdownEditing](https://jeffjade.com/2015/08/28/2015-08-28-Write-Morkdown/)</sub>
- [Dillinger](https://dillinger.io/): <sub>Dillinger is an online cloud based HTML5 filled Markdown Editor. Sync with Dropbox, Github, Google Drive or OneDrive. Convert HTML to Markdown. 100% Open Source!</sub>
- [小书匠编辑器](http://soft.xiaoshujiang.com/)
- [rstudio/bookdown](https://github.com/rstudio/bookdown): <sub>Authoring Books and Technical Documents with R Markdown</sub>
- [siyuan-note/siyuan](https://github.com/siyuan-note/siyuan): <sub>📕 思源笔记是一款 Markdown 块级引用和双向链接的网状笔记应用，支持 Windows、Mac 和 Linux，可在浏览器上直接使用，支持移动端适配。</sub>

### 相关库

#### Markdown parser & compiler

- [**markedjs/marked**](https://github.com/markedjs/marked): <sub>A markdown parser and compiler. Built for speed. https://marked.js.org/</sub>
- [remarkjs/remark](https://github.com/remarkjs/remark): <sub>Markdown processor powered by plugins part of the @unifiedjs collective https://remark.js.org/</sub>
- [turndown](https://github.com/domchristie/turndown): <sub>🛏 An HTML to Markdown converter written in JavaScript http://domchristie.github.io/turndown </sub>
- [rsms/markdown-wasm](https://github.com/rsms/markdown-wasm): <sub>Markdown parser and HTML generator implemented in WebAssembly, based on md4c</sub>

#### Markdown component

- [vditor](https://github.com/Vanessa219/vditor): <sub>♏ 一款浏览器端的 Markdown 编辑器。</sub>
- [b3log/lute](https://github.com/b3log/lute): <sub>🎼 一款结构化的 Markdown 引擎，支持 Go 和 JavaScript。</sub>
- [quill](https://github.com/quilljs/quill): <sub>Quill is a modern WYSIWYG editor built for compatibility and extensibility. https://quilljs.com</sub>
- [react-markdown](https://github.com/rexxars/react-markdown): <sub>Render Markdown as React components </sub>
- [vue-simplemde](https://github.com/F-loat/vue-simplemde): <sub>📝Vue-SimpleMDE - use simplemde with vue.js </sub>
- [mavonEditor](https://github.com/hinesboy/mavonEditor): <sub>mavonEditor - A markdown editor based on Vue that supports a variety of personalized features</sub>

#### Mdx

- [mdx-deck](https://github.com/jxnblk/mdx-deck): <sub>♠️ MDX-based presentation decks https://jxnblk.com/mdx-deck</sub>
- [**mdx-js/mdx**](https://github.com/mdx-js/mdx): <sub>MDX is a JSX in Markdown loader, parser, and renderer for ambitious projects. It combines the readability of Markdown with the expressivity of JSX. The best of both worlds. 🌐</sub>
- [ok-mdx](https://github.com/jxnblk/ok-mdx): <sub>Browser-based MDX editor https://jxnblk.com/ok-mdx/</sub>
- [hashicorp/next-mdx-remote](https://github.com/hashicorp/next-mdx-remote): <sub>Load mdx content from anywhere through getStaticProps in next.js</sub>

#### **Awesome markdown tools**

- [markmap](https://github.com/dundalek/markmap): <sub>Visualize markdown documents as mindmaps</sub>
- [markvis](https://github.com/geekplux/markvis): <sub>make visualization in markdown. 📊📈 https://markvis.js.org</sub>
- [markdownlint](https://github.com/DavidAnson/markdownlint): <sub>A Node.js style checker and lint tool for Markdown/CommonMark files.</sub>
- [**clean-mark**](https://github.com/croqaz/clean-mark): <sub>Convert an article into a clean text</sub>
- [egoist/maid](https://github.com/egoist/maid): <sub>Markdown driven task runner.</sub>
- [joeyespo/grip](https://github.com/joeyespo/grip): <sub>Preview GitHub Markdown files like Readme locally before committing them.</sub>
- [mdast](https://github.com/syntax-tree/mdast): <sub>Markdown Abstract Syntax Tree format. https://unified.js.org</sub>
- [markeye](https://github.com/vesparny/markeye): <sub>A previewer for Markdown files</sub>
- [remark](https://github.com/gnab/remark): <sub>A simple, in-browser, markdown-driven slideshow tool. https://remarkjs.com</sub>
- [88250/lute-docx](https://github.com/88250/lute-docx): <sub>📝 一款将 Markdown 文本转换为 Word 文档 (.docx) 的小工具。</sub>
- [mdnice/sitdown](https://github.com/mdnice/sitdown): <sub>turn html to nice markdown</sub>
