**导语：**[Kubernetes](https://kubernetes.io/)是 Google 团队发起的开源项目，用于跨多个主机管理集装箱化应用程序 ; 为应用程序的部署，维护和扩展提供基本的机制，主要实现语言为`Go`语言；它能够运行在任何地方，并且还有以下优势：**易学**：轻量级，简单，容易理解；**便携**：支持公有云，私有云，混合云，以及多种云平台；**可拓展**：模块化，可插拔，支持钩子，可任意组合；**自修复**：自动重调度，自动重启，自动复制。在分布式系统中，部署，调度，伸缩一直是最为重要的也最为基础的功能。`Kubernets`就是希望解决这一序列问题的，该项目目前在[GitHub](https://github.com/kubernetes/kubernetes)进行维护 ── 来自 [Production-Grade Container Orchestration - Kubernetes | 倾城之链](https://nicelinks.site/post/5b2cad0a34c03342fda0f37e)。

## 基础篇

- [Kubernetes 官网](https://kubernetes.io/)
- [Kubernetes Github](https://github.com/kubernetes/kubernetes)
- [Kubernetes 中文社区](https://www.kubernetes.org.cn/)
- [Kubernetes 教程简介（英）](http://okigiveup.net/a-tutorial-introduction-to-kubernetes/)
- [kubernetes-basicLearning](https://github.com/knrt10/kubernetes-basicLearning): <sub>Understand kubernetes step by step. A simple repo for beginners 🔥</sub>
- [为什么 Kubernetes 是新的应用服务器（英）](https://developers.redhat.com/blog/2018/06/28/why-kubernetes-is-the-new-application-server/)

## 资源篇

- [helm](https://github.com/helm/helm): <sub>The Kubernetes Package Manager https://helm.sh/</sub>
- [minikube](https://github.com/kubernetes/minikube): <sub>Run Kubernetes locally</sub>
- [charts](https://github.com/helm/charts): <sub>Curated applications for Kubernetes</sub>
- [ingress-nginx](https://github.com/kubernetes/ingress-nginx): <sub>NGINX Ingress Controller for Kubernetes</sub>
- [kubeflow](https://github.com/kubeflow/kubeflow): <sub>Machine Learning Toolkit for Kubernetes</sub>
- [Tilt](https://github.com/windmilleng/tilt): <sub>Local Kubernetes development with no stress https://tilt.build/</sub>
- [fluentd-kubernetes-daemonset](https://github.com/fluent/fluentd-kubernetes-daemonset): <sub>Fluentd daemonset for Kubernetes and it Docker image</sub>
- [kubernetes-up-and-running/kuard](https://github.com/kubernetes-up-and-running/kuard): <sub>Demo app for Kubernetes Up and Running book</sub>
- [openshift/origin](https://github.com/openshift/origin): <sub>The self-managing, auto-upgrading, Kubernetes distribution for everyone http://www.openshift.org</sub>
- [tektoncd/pipeline](https://github.com/tektoncd/pipeline): <sub>A K8s-native Pipeline resource. https://tekton.dev</sub>
- [fission/fission](https://github.com/fission/fission): <sub>Fast and Simple Serverless Functions for Kubernetes</sub>
- [cloudnativelabs/kube-shell](https://github.com/cloudnativelabs/kube-shell): <sub>Kubernetes shell: An integrated shell for working with the Kubernetes</sub>
- [pingcap/chaos-mesh](https://github.com/pingcap/chaos-mesh): <sub>A Chaos Engineering Platform for Kubernetes</sub>

### Node.js

- [kubesail/deploy-node-app](https://github.com/kubesail/deploy-node-app): <sub>Deploy your node.js app to Kubernetes with a single command. No config required.</sub>
