**导语**：无论您的应用程序有多大或多小，您都必须在某个时间处理从远程服务器获取数据。在前端，这通常涉及到一个 REST 端点，转换响应，缓存它，并更新您的用户界面。多年来，REST 一直是 API 的现状，但自 2017 年伊始，由于出色的开发人员经验和对数据获取的声明式方法，一种名为 GraphQL 的新 API 技术已经大行其道。

GraphQL 既是一种用于 API 的查询语言也是一个满足你数据查询的运行时。 GraphQL 对你的 API 中的数据提供了一套易于理解的完整描述，使得客户端能够准确地获得它需要的数据，而且没有任何冗余，也让 API 更容易地随着时间推移而演进，还能用于构建强大的开发者工具。

---

## 基础篇

- [GraphQL: 一种用于 API 的查询语言](https://graphql.cn/)
- [Github facebook/GraphQL](https://github.com/facebook/graphql)
- [Introducing the GraphQL Guide](https://blog.graphql.guide/introducing-the-graphql-guide-11a5ae48628a): <sub>jQuery 的作者 John Resig 出新书《GraphQL 指南》</sub>
- [A Front End Developer’s Guide to GraphQL](https://css-tricks.com/front-end-developers-guide-graphql/)
- [The future of state management](https://dev-blog.apollodata.com/the-future-of-state-management-dd410864cae2)

## 资源篇

- [awesome-graphql](https://github.com/chentsulin/awesome-graphql): <sub>Awesome list of GraphQL & Relay</sub>
- [ardatan/graphql-tools](https://github.com/ardatan/graphql-tools): <sub>🔧 Build, mock, and stitch a GraphQL schema using the schema language</sub>
- [imolorhe/altair](https://github.com/imolorhe/altair): <sub>✨⚡️ A beautiful feature-rich GraphQL Client for all platforms. https://altair.sirmuel.design</sub>
- [graphql-engine](https://github.com/hasura/graphql-engine): <sub>Blazing fast, instant realtime GraphQL APIs on Postgres with fine grained access control https://hasura.io</sub>
- [graphpack](https://github.com/glennreyes/graphpack): <sub>☄️ A minimalistic zero-config GraphQL server. </sub>
- [quicktype](https://github.com/quicktype/quicktype): <sub>Generate types and converters from JSON, Schema, and GraphQL https://app.quicktype.io/</sub>
- [graphql-engine](https://github.com/hasura/graphql-engine): <sub>Blazing fast, instant realtime GraphQL APIs on Postgres with fine grained access control, also trigger webhooks on database events. https://hasura.io</sub>
- [maticzav/graphql-shield](https://github.com/maticzav/graphql-shield): <sub>🛡 A GraphQL tool to ease the creation of permission layer.</sub>
- [graphql-editor/graphql-zeus](https://github.com/graphql-editor/graphql-zeus): <sub>GraphQL client and GraphQL code generator with GraphQL autocomplete library generation ⚡⚡⚡ for browser,nodejs and react native</sub>
- [kamilkisiela/graphql-config](https://github.com/kamilkisiela/graphql-config): <sub>One configuration for all your GraphQL tools (supported by most tools, editors & IDEs) https://graphql-config.com</sub>
- [quicktype/quicktype](https://github.com/quicktype/quicktype): <sub>Generate types and converters from JSON, Schema, and GraphQL</sub>
- [samdenty/gqless](https://github.com/samdenty/gqless): <sub>A GraphQL client without queries ✨</sub>
- [mswjs/msw](https://github.com/mswjs/msw): <sub>Seamless REST/GraphQL API mocking library for browser and Node.</sub>
- [prisma-labs/graphql-request](https://github.com/prisma-labs/graphql-request): <sub>Minimal GraphQL client supporting Node and browsers for scripts or simple apps</sub>

## 插件篇

- [graphql-code-generator](https://github.com/dotansimha/graphql-code-generator): <sub>GraphQL code generator with flexible support for custom plugins and templates https://graphql-code-generator.com</sub>
- [graphql-js](https://github.com/graphql/graphql-js): <sub>A reference implementation of GraphQL for JavaScript http://graphql.org/graphql-js/</sub>
- [banterfm/graphql-crunch](https://github.com/banterfm/graphql-crunch): <sub>Reduces the size of GraphQL responses by consolidating duplicate values</sub>
- [graphql/graphql-js](https://github.com/graphql/graphql-js): <sub>A reference implementation of GraphQL for JavaScript http://graphql.org/graphql-js/</sub>
- [Canner/canner](https://github.com/Canner/canner): <sub>📡 Universal CMS framework using React & Apollo GraphQL for Firebase, Prisma, GraphQL, Restful API https://www.canner.io</sub>
- [nearform/graphql-hooks](https://github.com/nearform/graphql-hooks): <sub>🎣 Minimal hooks-first GraphQL client</sub>
- [gqless/gqless](https://github.com/gqless/gqless): <sub>A GraphQL client without queries ✨</sub>

### 示例篇

- [VulcanJS/Vulcan](https://github.com/VulcanJS/Vulcan): <sub>🌋 A toolkit to quickly build apps with React, GraphQL & Meteor</sub>
