**导语：**

## Git 基础篇

- [Git - 简明指南](http://rogerdudler.github.io/git-guide/index.zh.html)
- [Git 常规命令练习](http://pcottle.github.io/learnGitBranching)
- [Git 的资料整理](https://github.com/xirong/my-git)
- [沉浸式学 Git](http://igit.linuxtoy.org/contents.html)
- [企业开发 git 工作流模式探索部分休整](https://github.com/xirong/my-git/blob/master/git-workflow-tutorial.md)
- [动画方式练习 Git](https://learngitbranching.js.org/)
- [一篇文章，教你学会 Git](http://www.jianshu.com/p/072587b47515)
- [常用 Git 命令清单](http://www.ruanyifeng.com/blog/2015/12/git-cheat-sheet.html): <sub>来自阮一峰的网络日志，列出了 Git 最常用的命令</sub>
- [Git 常用命令备忘](https://jeffjade.com/2014/12/22/2014-12-22-gitmemo/)
- [我所记录的 git 命令（非常实用）](http://www.cnblogs.com/fanfan259/p/4810517.html)
- [AntBranch/awesome-github ](https://github.com/AntBranch/awesome-github): <sub>A curated list of awesome GitHub guides, articles, sites, tools, projects and resources( 收集这个列表，只是为了更好地使用亲爱的 GitHub).</sub>
- [Github 替代品列表](https://tutswiki.com/github-alternatives/)

## Git 进阶篇

- [Git 的奇技淫巧 🙈](https://github.com/521xueweihan/git-tips)
- [高质量的 Git 中文教程](https://github.com/geeeeeeeeek/git-recipes/wiki)

## Github 技巧篇

- [GitHub 漫游指南](https://github.com/phodal/github-roam)
- [GitHub 秘籍](https://github.com/tiimgreen/github-cheat-sheet/blob/master/README.zh-cn.md)
- [How-to-collaborate-on-github](https://github.com/eonist/How-to-collaborate-on-github): <sub>A mini book about collaborating on GitHub</sub>
- [学习 Git 玩转 GitHub](http://www.extlight.com/2017/09/18/%E5%AD%A6%E4%B9%A0Git%E7%8E%A9%E8%BD%ACGitHub/)
- [使用 git 和 github 进行协同开发流程](http://livoras.com/post/28)
- [Github 全程指南 - 如何高效使用？](https://github.com/xirong/my-git/blob/master/how-to-use-github.md)
- [怎样使用 GitHub？](https://www.zhihu.com/question/20070065/answer/79557687)
- [GotGitHub](http://www.worldhello.net/gotgithub/index.html): <sub>全面介绍 GitHub 网站的书</sub>
- [如何编辑 Wiki](https://github.com/g0v/dev/wiki/%E5%A6%82%E4%BD%95%E7%B7%A8%E8%BC%AF-Wiki): <sub>非常好的 GitHub Wiki 使用教程</sub>
- [从 0 开始学习 GitHub 系列](http://stormzhang.com/github/2016/05/25/learn-github-from-zero1/): <sub>stormzhang 写的 GitHub 教程</sub>
- [强力推荐！那些你不能错过的 GitHub 插件和工具](https://juejin.im/post/59ade28051882538fd72fa2c)

## Github 常用地址

- [GitHub Trending](https://github.com/trending) - GitHub 官方的仓库和开发者流行榜
- [Code Review](http://reviewcode.cn/) - 利用 GitHub 进行 codereview 的网站
- [GitHub Resume](http://resume.github.io/) - 根据 GitHub 的信息生成简历
- [GitBook](https://www.gitbook.com/) - Github 上写书，发布到 GitBook
- [choose a license](http://choosealicense.com/) - GitHub 发布了 choosealicense.com 网站，在呼吁开源项目开发者选择一个许可证的同时，还提供了许可证的一些简要说明。
- [vmap.phodal.com](https://vmap.phodal.com/) - 基于 GitHub 的 O2O 应用，寻找身边的 GitHub 大牛，根据你填写的公司位置查找
- [jekyllthemes](https://github.com/mattvh/jekyllthemes) - 一些好看的 jekyll 主题
- [gitential.com](https://gitential.com/) - Analytics for Git
- [github/gitignore](https://github.com/github/gitignore) - A collection of useful .gitignore templates

## Github Workflow

### 工具

- [nektos/act](https://github.com/nektos/act): <sub>Run your GitHub Actions locally 🚀</sub>
- [probot/probot](https://github.com/probot/probot): <sub>🤖 A framework for building GitHub Apps to automate and improve your workflow</sub>

## GitHub Rank

- [GitHub Rank (China)](http://githubrank.com/) - GitHub 上中国程序员的排名网站，根据 follower
- [GitHub Ranking | GitHub Awards](http://github-awards.com/) - GitHub 上程序员的排名网站，根据 star
- [GitHub Ranking](https://github-ranking.com/) - GitHub 用户和仓库排名，根据 star，不区分语言
- [diycode - GitHub Ranking](http://www.diycode.cc/trends) - GitHub 全球 Developers, Organizations and Repositories 排行榜

## Git 相关 UI 库

- [nicoespeon/gitgraph.js](https://github.com/nicoespeon/gitgraph.js): <sub>👋 [Looking for maintainers] - A JavaScript library to draw pretty git graphs in the browser</sub>
- [tomgi/git_stats](https://github.com/tomgi/git_stats): <sub>GitStats is a git repository statistics generator.</sub>

## 桌面工具

- [GitUp](https://github.com/git-up/GitUp): <sub>The Git interface you've been missing all your life has finally arrived. http://gitup.co</sub>
- [desktop](https://github.com/desktop/desktop): <sub>Simple collaboration from your desktop https://desktop.github.com</sub>
- [ohmystar](http://www.ohmystarapp.com/) - Mac 上管理你 GitHub star 的工具
- [GithubPulse](https://github.com/tadeuzagallo/GithubPulse) - OS X 状态栏的 APP，帮你记住你在 GitHub 每天的贡献
- [githubtrending](http://www.githubtrending.com/) - OS X 状态栏的 APP，显示 GitHub Trending，也有 iOS 端
- [ghstatus](https://itunes.apple.com/cn/app/ghstatus/id883585153?mt=12) - OS X 状态栏的 APP，显示 GitHub Status
- [pophub](http://questbe.at/pophub/) - OS X 状态栏的 APP，显示 GitHub 的 activities
- [git-dude](https://github.com/sickill/git-dude) - git commit 通知
- [gitee](https://github.com/Nightonke/Gitee) - Gitee, OS X status bar application for Github 漂亮的 GitHub 数据统计工具，还有 notifications 功能
- [GitHubFolderDownloader](https://github.com/VahidN/GitHubFolderDownloader) - 可以下载一个仓库的单个文件夹的桌面工具
- [go-gitea/gitea](https://github.com/go-gitea/gitea): <sub>Git with a cup of tea, painless self-hosted git service</sub>
- [jlord/git-it-electron](https://github.com/jlord/git-it-electron): <sub>💻 🎓 Git-it is a (Mac, Win, Linux) Desktop App for Learning Git and GitHub</sub>

## Git 库

- [husky](https://github.com/typicode/husky): 🐶 Git hooks made easy.

## Git 终端插件

- [gitmoji](https://github.com/carloscuesta/gitmoji): <sub>An emoji guide for your commit messages. 😜 https://gitmoji.carloscuesta.me</sub>
- [commitizen/cz-cli](https://github.com/commitizen/cz-cli): <sub>The commitizen command line utility. https://commitizen.github.io/cz-cli</sub>
- [git-secret](https://github.com/sobolevn/git-secret): <sub>👥 A bash-tool to store your private data inside a git repository. http://git-secret.io</sub>
- [grip](https://github.com/joeyespo/grip): <sub>Preview GitHub Markdown files like Readme locally before committing them.</sub>
- [**lazygit**](https://github.com/jesseduffield/lazygit): <sub>simple terminal UI for git commands</sub>
- [tig](https://github.com/jonas/tig): <sub>Text-mode interface for git https://jonas.github.io/tig/</sub>
- [cli/cli](https://github.com/cli/cli): <sub>The GitHub CLI https://cli.github.com</sub>

## Github 装饰工具

- [anuraghazra/github-readme-stats](https://github.com/anuraghazra/github-readme-stats): <sub>Dynamically generated stats for your github readmes</sub>

## Github 浏览器插件

- [octotree](https://github.com/buunguyen/octotree) - 浏览器扩展，树状格式显示 GitHub 的代码
- [octo-linker](https://github.com/octo-linker/chrome-extension) - 这款谷歌 Chrome 扩展允许您轻松地浏览 GitHub.com 上的文件和包。
- [github-hovercard](https://github.com/Justineo/github-hovercard) - GitHub Hovercard 是一个浏览器扩展，实现了展示用户在 Github 上信息的信息卡功能，支持 Firefox 和 Chrome 浏览器。
- [notifier-for-github-chrome](https://github.com/sindresorhus/notifier-for-github-chrome) - 一个浏览器扩展，它能显示 Github 通知的未读数量
- [github-menu-back](https://github.com/summerblue/github-menu-back) - 一款修改 GitHub 导航栏为之前状态的 Chrome 插件
- [gitsense-extensions](https://github.com/gitsense/gitsense-extensions) - GitSense 是一个 Chrome 插件，可以让你在浏览 Github 的时候体验更好。
- [git-draw](https://github.com/ben174/git-draw) - 谷歌 Chrome 扩展，给 GitHub 提交历史画个画
- [ShowInGitHub](https://github.com/larsxschneider/ShowInGitHub) - Xcode 插件，打开选中行的 GitHub 提交页面
- [Reveal-In-GitHub](https://github.com/lzwjava/Reveal-In-GitHub) - 有关 GitHub 的 Xcode 插件
- [Visual Studio](https://github.com/github/VisualStudio) - 有关 GitHub 的 Visual Studio 插件
- [github-sublime-theme](https://github.com/AlexanderEkdahl/github-sublime-theme) - GitHub Sublime 主题
- [GitHubinator](https://github.com/ehamiter/GitHubinator) - sublime 插件，显示选中文本上的远程 GitHub 仓库
- [alfred-github-workflow](https://github.com/gharlan/alfred-github-workflow) - Alfred 2 上使用 GitHub 命令
- [ZenHub](https://github.com/ZenHubIO/support) -ZenHub 能优化你的 GitHub 工作流，是轻量级的 Chrome 浏览器插件。
- [github-gmail](https://github.com/muan/github-gmail) - 在 Gmail 内快速打开 GitHub 的通知
- [chrome-github-avatars](https://github.com/anasnakawa/chrome-github-avatars) - 谷歌 Chrome 扩展，可以让你的 GitHub 主页显示用户的头像。
- [tab-size-on-github](https://github.com/sindresorhus/tab-size-on-github) - 谷歌 Chrome 和 Opera 扩展，让代码缩进为 4 个空格而不是 8 个
- [hide-files-on-github](https://github.com/sindresorhus/hide-files-on-github) - 谷歌 Chrome 和 Opera 扩展，隐藏点文件
- [github-highlight-selected](https://github.com/Nuclides/github-highlight-selected) - 谷歌 Chrome 和 Safari 扩展，代码高亮，看起来像 sublime
- [github-awesome-autocomplete](https://github.com/algolia/github-awesome-autocomplete) - 谷歌 Chrome 和 Safari 以及 Firefox 扩展，在 GitHub 的搜索栏加入自动补全功能
- [chrome-github-mate](https://github.com/rubyerme/chrome-github-mate) - 谷歌 Chrome 扩展，下载单个文件
- [Pages2Repo](https://github.com/Frozenfire92/Pages2Repo) - 谷歌 Chrome 扩展，通过 GitHub Pages 网站就能访问仓库。
- [lovely-forks](https://github.com/musically-ut/lovely-forks) - 谷歌 Chrome 扩展，显示 fork 你仓库中 star 最多的
- [github-pr-filter](https://github.com/danielhusar/github-pr-filter) - 谷歌 Chrome 扩展，在 pr 中过滤文件
- [github-ast-viewer](https://github.com/lukehorvat/github-ast-viewer) - 谷歌 Chrome 扩展，增加代码的抽象语法树
- [github-canned-responses](https://github.com/notwaldorf/github-canned-responses) - 谷歌 Chrome 扩展，评论 pr 或者 issue 的时候有一些可选项
- [categoric](https://github.com/ozlerhakan/categoric) - 谷歌 Chrome 扩展，为你的通知分类
- [octo-preview](https://github.com/DrewML/octo-preview) - 谷歌 Chrome 扩展，预览你评论的 markdown 内容
- [GifHub](https://github.com/DrewML/GifHub) - 谷歌 Chrome 扩展，GifHub 一个往 GitHub 评论里边插入 Gif 动画的 Chrome 插件
- [star-history-plugin](https://github.com/timqian/star-history-plugin) - 查看仓库 star 历史的插件
- [open-on-github](https://github.com/atom/open-on-github) - atom 插件，打开文件在 github.com
- [refined-github](https://github.com/sindresorhus/refined-github) - chrome 插件，简化你的 github，增加了一些可用的功能
- [gitpress](https://github.com/enricob/gitpress) - github 的 wordpress 插件，用于列出用户的仓库
- [jquery-github](https://github.com/zenorocha/jquery-github) -jquery 的插件显示 github 仓库
- [sublime-text-git](https://github.com/kemayo/sublime-text-git) - sublime 的 git 插件
- [git-plugin](https://github.com/jenkinsci/git-plugin) - jenkins 的 git 插件
- [github-oauth-plugin](https://github.com/jenkinsci/github-oauth-plugin) - jenkins 的 github oauth 登录插件
- [twitter-for-github](https://github.com/bevacqua/twitter-for-github) - 在 github 上显示用户 twitter 的 chrome 插件
- [Hudson-GIT-plugin](https://github.com/magnayn/Hudson-GIT-plugin) - Hudson 上的 GIT 插件
- [git-time-machine](https://github.com/littlebee/git-time-machine) - atom 插件查看提交历史
- [GitDiff](https://github.com/johnno1962/GitDiff) - Xcode 插件
- [vim-gitgutter](https://github.com/airblade/vim-gitgutter) - git 的 vim 插件
- [github-integration-plugin](https://github.com/KostyaSha/github-integration-plugin) - Jenkins 的 GitHub 集成插件
- [github-contributions-chart](https://github.com/sallar/github-contributions-chart): <sub>:octocat: Generate an image of all your Github contributions https://github-contributions.now.sh</sub>
- [GitHub-Dark](https://github.com/StylishThemes/GitHub-Dark): <sub>:octocat: Dark GitHub style http://userstyles.org/styles/37035</sub>
