## 基础篇

- [JavaScript 基础教程 | MDN](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript)
- [JavaScript 指南 | MDN](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Guide)
- [microsoft/Web-Dev-For-Beginners](https://github.com/microsoft/Web-Dev-For-Beginners): <sub>24 Lessons, 12 Weeks, Get Started as a Web Developer</sub>
- [JavaScript 教程 | W3school](https://www.w3school.com.cn/js/index.asp)
- [阮一峰 JavaScript](http://javascript.ruanyifeng.com)
- [阮一峰 ES66](http://es6.ruanyifeng.com)
- [ECMAScript 6 Learning](https://github.com/ericdouglas/ES6-Learning)
- [JavaScript Promise 迷你书](https://github.com/liubin/promises-book/)
- [awesome-javascript](https://github.com/sorrycc/awesome-javascript): <sub>🐢 A collection of awesome browser-side JavaScript libraries, resources and shiny things.</sub>
- [javascript-tutorial-en](https://github.com/javascript-tutorial/en.javascript.info): <sub>Modern JavaScript Tutorial https://javascript.info</sub>
- [anbang/javascript-notes](https://github.com/anbang/javascript-notes): <sub>安邦的 JavaScript 学习笔记</sub>

## 进阶篇

- [33-js-concepts](https://github.com/leonardomso/33-js-concepts): <sub>📜 33 concepts every JavaScript developer should know. [📜 每个 JavaScript 工程师都应懂的 33 个概念](https://github.com/stephentian/33-js-concepts). </sub>
- [Front-End-Checklist Javascript](https://github.com/thedaviddias/Front-End-Checklist#javascript)
- [Web | Google Developers](https://developers.google.com/web/)
- [How JavaScript works: inside the V8 engine + 5 tips on how to write optimized code](https://blog.sessionstack.com/how-javascript-works-inside-the-v8-engine-5-tips-on-how-to-write-optimized-code-ac089e62b12e)
- [八段代码彻底掌握 Promise](https://juejin.im/post/597724c26fb9a06bb75260e8)
- [Understanding ECMAScript 6 - Nicholas C. Zakas](https://leanpub.com/understandinges6/read)
- [Await s return VS return await](https://jakearchibald.com/2017/await-vs-return-vs-return-await/)
- [How JavaScript works: memory management + how to handle 4 common memory leaks](https://blog.sessionstack.com/how-javascript-works-memory-management-how-to-handle-4-common-memory-leaks-3f28b94cfbec)
- [5 Tips and Thoughts on Async / Await Functions](https://start.jcolemorrison.com/5-tips-and-thoughts-on-async-await-functions/)
- [Parallel programming in JavaScript](https://itnext.io/achieving-parallelism-in-javascript-using-web-workers-8f921f2d26db)
- [The Comprehensive Guide to JavaScript Design Patterns](https://www.toptal.com/javascript/comprehensive-guide-javascript-design-patterns)
- [javascript-design-patterns-for-humans](https://github.com/sohamkamani/javascript-design-patterns-for-humans): <sub>An ultra-simplified explanation of design patterns implemented in javascript</sub>
- [jonasschmedtmann/complete-javascript-course](https://github.com/jonasschmedtmann/complete-javascript-course): <sub>Starter files, final projects and FAQ for my Complete JavaScript course</sub>

## 相关篇

- [A list of funny and tricky JavaScript examples](https://github.com/denysdovhan/wtfjs#readme)
- [30 seconds of code](https://github.com/Chalarangelo/30-seconds-of-code): <sub>Curated collection of useful Javascript snippets that you can understand in 30 seconds or less. https://30secondsofcode.org/</sub>
- [azl397985856/leetcode](https://github.com/azl397985856/leetcode): <sub>LeetCode Solutions: A Record of My Problem Solving Journey.( leetcode 题解，记录自己的 leetcode 解题之路。)</sub>
- [javascript-questions](https://github.com/lydiahallie/javascript-questions): <sub>A long list of (advanced) JavaScript questions, and their explanations ✨ Updated weekly!</sub>
- [JavaScript Factory Functions with ES6+](https://medium.com/javascript-scene/javascript-factory-functions-with-es6-4d224591a8b1)
- [Dynamic import()](https://developers.google.com/web/updates/2017/11/dynamic-import)
- [Why we have banned default exports in Javascript and you should do the same](https://blog.neufund.org/why-we-have-banned-default-exports-and-you-should-do-the-same-d51fdc2cf2ad)
- [A Brief History of Modularity](https://ponyfoo.com/articles/brief-history-of-modularity)
- [Familiarity Bias is Holding You Back: It’s Time to Embrace Arrow Functions](https://medium.com/javascript-scene/familiarity-bias-is-holding-you-back-its-time-to-embrace-arrow-functions-3d37e1a9bb75)
- [Can (a ==1 && a== 2 && a==3) ever evaluate to true?](https://stackoverflow.com/questions/48270127/can-a-1-a-2-a-3-ever-evaluate-to-true)
- [ES2018(ES9) Puzzlers](http://es2018puzzlers.justjavac.com/)
- [Here are examples of everything new in ECMAScript 2016, 2017, and 2018](https://medium.freecodecamp.org/here-are-examples-of-everything-new-in-ecmascript-2016-2017-and-2018-d52fa3b5a70e)

## 优化篇

- [Front-End-Performance-Checklist](https://github.com/thedaviddias/Front-End-Performance-Checklist): <sub>🎮The only Front-End Performance Checklist that runs faster than the others https://frontendchecklist.io(soon on)</sub>
- [You Don't Need jQuery](https://github.com/nefe/You-Dont-Need-jQuery): <sub>Examples of how to do query, style, dom, ajax, event etc like jQuery with plain javascript.</sub>
- [You don't (may not) need Lodash/Underscore](https://github.com/you-dont-need/You-Dont-Need-Lodash-Underscore): <sub>List of JavaScript methods which you can use natively + ESLint Plugin</sub>
- [getify/You-Dont-Know-JS](https://github.com/getify/You-Dont-Know-JS): <sub>A book series on JavaScript. @YDKJS on twitter.</sub>
- [😇 你可能不知道的前端知识点](https://github.com/justjavac/the-front-end-knowledge-you-may-not-know)
- [5 Tips to Write Better Conditionals in JavaScript](https://scotch.io/bar-talk/5-tips-to-write-better-conditionals-in-javascript)

### 规范篇

- [idiomatic.js](https://github.com/rwaldron/idiomatic.js): <sub>Principles of Writing Consistent, Idiomatic JavaScript</sub>
- [js-the-right-way](https://github.com/braziljs/js-the-right-way): <sub>An easy-to-read, quick reference for JS best practices, accepted coding standards, and links around the Web http://jstherightway.org</sub>
- [clean-code-javascript](https://github.com/ryanmcdermott/clean-code-javascript): <sub>🛁 Clean Code concepts adapted for JavaScript </sub>

## Pack JavaScript

- [snowpackjs/snowpack](https://github.com/snowpackjs/snowpack): <sub>WASM-powered frontend build tool. Fast, lightweight, unbundled ESM. ✌️</sub>
- [parcel](https://github.com/parcel-bundler/parcel): <sub>📦🚀 Blazing fast, zero configuration web application bundler https://parceljs.org</sub>
- [rollup](https://github.com/rollup/rollup): <sub>Next-generation ES module bundler https://rollupjs.org</sub>
- [fastpack](https://github.com/fastpack/fastpack): <sub>Pack JS code fast & easy http://fastpack.io</sub>

## Compiler

- [the-super-tiny-compiler](https://github.com/jamiebuilds/the-super-tiny-compiler): <sub>⛄ Possibly the smallest compiler ever</sub>

---

## [TypeScript](https://github.com/Microsoft/TypeScript)

- [TypeScript - JavaScript that scales.](http://www.typescriptlang.org/): <sub>TypeScript is a superset of JavaScript that compiles to clean JavaScript output. </sub>
- [typescript-tutorial](https://github.com/xcatliu/typescript-tutorial): <sub>TypeScript 入门教程</sub>
- [TypeScript 中文网](https://www.tslang.cn/index.html): <sub>TypeScript 是 JavaScript 的超集，它编译为纯 JavaScript</sub>
- [TypeScript 入门教程](https://ts.xcatliu.com/)：<sub>从 JavaScript 程序员的角度总结思考，循序渐进的理解 TypeScript。</sub>
- [typescript-book](https://github.com/basarat/typescript-book): <sub>📚 The definitive guide to TypeScript and possibly the best TypeScript book 📖. Free and Open Source 🌹</sub>
- [airbnb/ts-migrate](https://github.com/airbnb/ts-migrate): <sub>A tool to help migrate JavaScript code quickly and conveniently to TypeScript</sub>
