**导语：** [Docker](https://www.docker.com/ 'Docker') 是一种开源软件，可以将任何应用程序打包，运送和运行的轻量级容器；她适用于所有应用的现代平台，她使得你可以按照自己的方式，随处构建，管理和保护您的应用程序，且无需考虑更多。如今已成为开发与运维绝佳的集装箱平台；她的存在，使得公司能够更轻松地实现应用程序环境的现代化；她彻底释放了计算虚拟化的威力，极大提高了应用的维护效率，降低了云计算应用开发的成本！使用 `Docker`，可以让应用的部署、测试和分发都变得前所未有的高效和轻松！[Docker](https://www.docker.com/ 'Docker') ，**堪称划时代的开源项目** ── 来自 [Docker - Build, Ship, and Run Any App, Anywhere | 倾城之链](https://nicelinks.site/post/5b7036890f8719053c094d68)。

## 基础篇

- [Docker 官方网站](https://www.docker.com/)
- [Docker Hub](https://hub.docker.com/): <sub>Dev-test pipeline automation, 100,000+ free apps, public and private registries</sub>
- [Docker for beginners](https://docker-curriculum.com/)
- [Docker 入门教程 (By 阮一峰 )](http://www.ruanyifeng.com/blog/2018/02/docker-tutorial.html)
- [Docker 菜鸟教程](http://www.runoob.com/docker/docker-tutorial.html)
- [Getting Started with Docker](https://scotch.io/tutorials/getting-started-with-docker)
- [Docker — 从入门到实践](https://yeasy.gitbooks.io/docker_practice/content/): <sub>[Docker — 从入门到实践 .pdf](https://legacy.gitbook.com/download/pdf/book/yeasy/docker_practice)</sub>

## 进阶篇

- [Docker Development WorkFlow — a guide with Flask and Postgres](https://medium.freecodecamp.org/docker-development-workflow-a-guide-with-flask-and-postgres-db1a1843044a)
- [Docker 微服务教程 (By 阮一峰 )](http://www.ruanyifeng.com/blog/2018/02/docker-wordpress-tutorial.html)
- [The Advantages of Using Docker for Web Development](https://codeburst.io/the-advantages-of-using-docker-for-web-development-23096c457fad)

## 应用篇

- [Load Testing with Locust.io & Docker Swarm](https://wheniwork.engineering/load-testing-with-locust-io-docker-swarm-d78a2602997a)
- [使用 Docker 和 Elasticsearch 构建全文搜索应用程序](https://blog.patricktriest.com/text-search-docker-elasticsearch/): <sub>Open-source web app using Elasticsearch and Docker to search through the contents of 100 classic novels. https://search.patricktriest.com/</sub>
- [Docker Vue Node Nginx Mongodb Redis](https://github.com/nicejade/docker-vue-node-nginx-mongodb-redis): <sub>🐉An awesome boilerplate, Integration Docker, Vue2.\*, Node, Nginx, Mongodb and Redis in one, Designed to build & develop your web applications more efficient.</sub>

## 资源篇

- [awesome-compose](https://github.com/docker/awesome-compose): <sub>Awesome Docker Compose samples</sub>
- [sickcodes/Docker-OSX](https://github.com/sickcodes/Docker-OSX): <sub>Mac in Docker! Run near native OSX-KVM in Docker! X11 Forwarding!</sub>

## 相关篇

- [lazydocker](https://github.com/jesseduffield/lazydocker): <sub>The lazier way to manage everything docker</sub>
- [docker/compose](https://github.com/docker/compose): <sub>Define and run multi-container applications with Docker https://docs.docker.com/compose/</sub>
- [docker/toolbox ](https://github.com/docker/toolbox): <sub>The Docker Toolbox https://docker.com/toolbox</sub>

## 工具篇

- [Whaler](https://github.com/P3GLEG/Whaler): <sub>Program to reverse Docker images into Dockerfiles</sub>

## Docker Image

- [nodejs/docker-node](https://github.com/nodejs/docker-node)
- [docker-puppeteer](https://github.com/buildkite/docker-puppeteer): <sub>A minimal Docker image for Puppeteer. https://hub.docker.com/r/buildkite/puppeteer/</sub>
- [matsp/docker-flutter](https://github.com/matsp/docker-flutter): <sub>flutter docker image with full android sdk</sub>
- [docker-mailserver](https://github.com/tomav/docker-mailserver): <sub>A fullstack but simple mailserver (smtp, imap, antispam, antivirus, ssl...) using Docker.</sub>
- [NVAITC/ai-lab](https://github.com/NVAITC/ai-lab): <sub>All-in-one AI container for rapid prototyping </sub>
