## 基础篇

- [CSS 入门教程 | MDN](https://developer.mozilla.org/zh-CN/docs/Web/Guide/CSS/Getting_started)
- [CSS 基础教程 | MDN](https://developer.mozilla.org/zh-CN/docs/Learn/Getting_started_with_the_web/CSS_basics)
- [CSS 基础教程 | W3School](https://www.w3school.com.cn/css/index.asp)

## 进阶篇

- [Front-End-Checklist | CSS](https://github.com/thedaviddias/Front-End-Checklist#css)
- [【CSS 】 常见 CSS 布局](http://cherryblog.site/common-CSS-layout.html#more)
- [CSS 实现水平 | 垂直居中漫谈](https://jeffjade.com/2015/11/14/2015-11-14-css-achieve-horizontal_vertical_center/)
- [一劳永逸的搞定 flex 布局](https://juejin.im/post/58e3a5a0a0bb9f0069fc16bb)
- [CSS 征途之 Background 点滴](https://jeffjade.com/2015/06/29/2015-06-29-css-background/)
- [使用纯 CSS 实现 Google Photos 照片列表布局](https://github.com/xieranmaya/blog/issues/4)
- [How I started drawing CSS Images](https://blog.prototypr.io/how-i-started-drawing-css-images-3fd878675c89)
- [The Shapes of CSS | CSS-TRICKS](https://css-tricks.com/examples/ShapesOfCSS/)
- [半深入理解 CSS3 object-position/object-fit 属性](https://www.zhangxinxu.com/wordpress/2015/03/css3-object-position-object-fit/)

## 动画篇

- [css-animation-101](https://github.com/cssanimation/css-animation-101): <sub>Learn how to bring animation to your web projet. https://cssanimation.rocks/</sub>
- [Using CSS animations](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Animations/Using_CSS_animations)
- [CSS 动画简介](http://www.ruanyifeng.com/blog/2014/02/css_transition_and_animation.html)
- [CSS3 动画实践](https://aotu.io/notes/2016/01/04/css3-animation/index.html)
- [Using CSS Transitions on Auto Dimensions](https://css-tricks.com/using-css-transitions-auto-dimensions/)

### CSS 动画库

- [animate-css/animate.css](https://github.com/animate-css/animate.css): <sub>🍿 A cross-browser library of CSS animations. As easy to use as an easy thing.</sub>
- [**animate.css**](https://daneden.github.io/animate.css): <sub>Just-add-water CSS animations</sub>
- [typed.js](https://github.com/mattboldt/typed.js): <sub>A JavaScript Typing Animation Library</sub>
- [hint.css](https://github.com/chinchang/hint.css): <sub>A CSS only tooltip library for your lovely websites. https://kushagragour.in/lab/hint</sub>
- [balloon.css](https://github.com/kazzkiq/balloon.css): <sub>Simple tooltips made of pure CSS. https://kazzkiq.github.io/balloon.css</sub>
- [loaders.css](https://github.com/ConnorAtherton/loaders.css): <sub>Delightful, performance-focused pure css loading animations.</sub>
- [Hover](https://github.com/IanLunn/Hover): <sub>A collection of CSS3 powered hover effects to be applied to links, buttons, logos, SVG, featured images and so on. Easily apply to your own elements, modify or just use for inspiration. Available in CSS, Sass, and LESS. http://ianlunn.github.io/Hover/</sub>

### JS 动画库

- [**anime.js**](https://github.com/juliangarnier/anime): <sub>JavaScript Animation Engine http://animejs.com</sub>
- [animateplus](https://github.com/bendc/animateplus): <sub>A+ animation module for the modern web</sub>
- [vivus](https://github.com/maxwellito/vivus): <sub>JavaScript library to make drawing animation on SVG</sub>
- [scenejs](https://github.com/daybrush/scenejs): <sub>🎬 Scene.js is JavaScript & CSS timeline-based animation library http://daybrush.com/scenejs</sub>
- [ola](https://github.com/franciscop/ola): <sub>🌊 Smooth animation library for interpolating numbers</sub>
- [airbnb/lottie](https://github.com/airbnb/lottie/): <sub>Lottie for Android, iOS, React Native, and Web</sub>
- [laxxx](https://github.com/alexfoxy/laxxx): <sub>Simple & light weight (2kb minified & zipped) vanilla javascript plugin to create smooth & beautiful animations when you scrolllll! Harness the power of the most intuitive interaction and make your websites come alive!</sub>
- [popmotion](https://github.com/Popmotion/popmotion): <sub>Monorepo for Popmotion and Pose animation packages https://popmotion.io</sub>
- [VelocityJS](https://github.com/julianshapiro/velocity): <sub>Accelerated JavaScript animation. http://VelocityJS.org</sub>
- [tween.js](https://github.com/tweenjs/tween.js): <sub>JavaScript tweening engine for easy animations, incorporating optimised Robert Penner's equations.</sub>
- [WOW](https://github.com/matthieua/WOW): <sub>Reveal CSS animation as you scroll down a page http://mynameismatthieu.com/WOW/</sub>
- [hsnaydd/moveTo](https://github.com/hsnaydd/moveTo): <sub>A lightweight scroll animation javascript library without any dependency</sub>

## 规范篇

- [编写灵活、稳定、高质量的 HTML 和 CSS 代码的规范。](http://codeguide.bootcss.com/)
- [**如何编写可维护的 CSS**](https://github.com/chadluo/CSS-Guidelines/blob/master/README.md)
- [CSS、JS 、 HTML 编码规范](https://guide.aotu.io/docs/css/code.html)

## 周边篇

- [jareware/css-architecture](https://github.com/jareware/css-architecture): <sub>8 simple rules for a robust, scalable CSS architecture</sub>
- [css-doodle](https://github.com/css-doodle/css-doodle): <sub>🎨 A web component for drawing patterns with CSS. </sub>
- [CSS-Inspiration](https://github.com/chokcoco/CSS-Inspiration): <sub>CSS Inspiration，在这里找到写 CSS 的灵感!</sub>
- [JNKKKK/MoreToggles.css](https://github.com/JNKKKK/MoreToggles.css): <sub>A pure CSS library that provides you with a variety of nice-looking toggles</sub>
- [css-blocks](https://github.com/linkedin/css-blocks): <sub>High performance, maintainable stylesheets. http://css-blocks.com/</sub>
- [smooth-code/xstyled](https://github.com/smooth-code/xstyled): <sub>Consistent theme based CSS for styled-components & emotion 💅👩‍🎤</sub>
- [astrit/css.gg](https://github.com/astrit/css.gg): <sub>500+ CSS Icons. Customizable, Retina Ready with API & NPM https://css.gg</sub>
- [pattle/simpsons-in-css](https://github.com/pattle/simpsons-in-css): <sub>Simpsons characters in CSS</sub>
- [bouncejs 触摸库](http://bouncejs.com)
- [browserhacks](http://browserhacks.com)
- [腾讯 css3 动画制作工具](http://isux.tencent.com/css3/tools.html)
- [志爷 css 小工具集合](https://linxz.github.io/tianyizone)

### CSS 样式库

- [sanitize.css](https://github.com/csstools/sanitize.css): <sub>A best-practices CSS foundation https://csstools.github.io/sanitize.css</sub>
- [sindresorhus/github-markdown-css](https://github.com/sindresorhus/github-markdown-css): <sub>The minimal amount of CSS to replicate the GitHub Markdown style</sub>
- [primer/css](https://github.com/primer/css): <sub>The CSS design system that powers GitHub https://primer.style/css</sub>
- [water.css](https://github.com/kognise/water.css): <sub>A just-add-css collection of styles to make simple websites just a little nicer </sub>
- [uncss](https://github.com/uncss/uncss): <sub>Remove unused styles from CSS</sub>
- [popmotion](https://popmotion.io/): <sub>A functional, flexible JavaScript motion library</sub>

### CSS 特效样式

- [cssfx](https://github.com/jolaleye/cssfx): <sub>✨ Beautifully simple click-to-copy CSS effects https://cssfx.lovejade.cn/</sub>
- [instagram.css](https://github.com/picturepan2/instagram.css): <sub>Instagram.css - Complete set of Instagram filters in pure CSS</sub>
- [QiShaoXuan/css_tricks](https://github.com/QiShaoXuan/css_tricks): <sub>Some CSS tricks,一些 CSS 常用样式</sub>

### Css Framework

- [tailwindcss](https://github.com/tailwindcss/tailwindcss): <sub>A utility-first CSS framework for rapid UI development. https://tailwindcss.com/</sub>
- [bulma](https://github.com/jgthms/bulma): <sub>Modern CSS framework based on Flexbox https://bulma.io</sub>
- [ajusa/lit](https://github.com/ajusa/lit): <sub>World's smallest responsive 🔥 css framework (395 bytes)</sub>

### CSS in JS

- [goober](https://github.com/cristianbote/goober): <sub>🥜 goober, a less than 1KB 🎉css-in-js alternative with a familiar API</sub>
- [nyancss/nyancss](https://github.com/nyancss/nyancss): <sub>🌈 Write plain CSS while reaping benefits of CSS-in-JS https://nyancss.com</sub>
- [ben-rogerson/twin.macro](https://github.com/ben-rogerson/twin.macro): <sub>🦹‍♂️ Twin blends the magic of Tailwind with the flexibility of css-in-js (emotion, styled-components and goober) at build time.</sub>

## 相关篇

- [sass/dart-sass](https://github.com/sass/dart-sass): <sub>The reference implementation of Sass, written in Dart.</sub>
- [Postcss](https://github.com/postcss/postcss): <sub>Transforming styles with JS plugins http://postcss.org/</sub>
- [jss](https://github.com/cssinjs/jss): <sub>JSS is an authoring tool for CSS which uses JavaScript as a host language. https://cssinjs.org</sub>
- [css-modules](https://github.com/css-modules/css-modules): <sub>Documentation about css-modules </sub>
- [postcss-cssnext](https://github.com/MoOx/postcss-cssnext): <sub>🌀 PostCSS plugin to use tomorrow's CSS syntax, today. http://cssnext.io/</sub>
- [normalize.css](https://github.com/necolas/normalize.css/): <sub>A modern alternative to CSS resets http://necolas.github.io/normalize.css/ </sub>
- [30 Seconds of CSS](https://github.com/atomiks/30-seconds-of-css): <sub>A curated collection of useful CSS snippets.</sub>
- [**You-need-to-know-css**](https://github.com/l-hammer/You-need-to-know-css): <sub>🖖CSS tricks web developers need to know~ https://lhammer.cn/You-need-to-know-css/</sub>
- [linkedin/css-blocks](https://github.com/linkedin/css-blocks): <sub>High performance, maintainable stylesheets. http://css-blocks.com/</sub>
- [AllThingsSmitty/css-protips](https://github.com/AllThingsSmitty/css-protips): <sub>A collection of tips to help take your CSS skills pro</sub>
- [谈谈一些有趣的 CSS 话题](https://github.com/chokcoco/iCSS): <sub>https://github.com/chokcoco/iCSS</sub>
- [Houdini：CSS 领域最令人振奋的革新](https://zhuanlan.zhihu.com/p/20939640)
- [linaria](https://github.com/callstack/linaria): <sub>Zero-runtime CSS in JS library https://linaria.now.sh</sub>
- [csstree](https://github.com/csstree/csstree): <sub>A tool set for working with CSS including fast detailed parser, walker, generator and lexer based on W3C specs and browser implementations </sub>
