<?php

/**
 * Project codeigniter-basic-helper
 * Created by PhpStorm
 * User: 713uk13m <dev@nguyenanhung.com>
 * Copyright: 713uk13m <dev@nguyenanhung.com>
 * Date: 09/11/2021
 * Time: 08:52
 */
if (!function_exists('generateAlphaId')) {
    /**
     * Translates a number to a short alphanumeric version
     *
     * Translated any number up to 9007199254740992
     * to a shorter version in letters e.g.:
     * 9007199254740989 --> PpQXn7COf
     *
     * specifying the second argument true, it will
     * translate back e.g.:
     * PpQXn7COf --> 9007199254740989
     *
     * this function is based on any2dec && dec2any by
     * fragmer[at]mail[dot]ru
     * see: http://nl3.php.net/manual/en/function.base-convert.php#52450
     *
     * If you want the alphaID to be at least 3 letter long, use the
     * $pad_up = 3 argument
     *
     * In most cases this is better than totally random ID generators
     * because this can easily avoid duplicate ID's.
     * For example if you correlate the alpha ID to an auto incrementing ID
     * in your database, you're done.
     *
     * The reverse is done because it makes it slightly more cryptic,
     * but it also makes it easier to spread lots of IDs in different
     * directories on your filesystem. Example:
     * $part1 = substr($alpha_id,0,1);
     * $part2 = substr($alpha_id,1,1);
     * $part3 = substr($alpha_id,2,strlen($alpha_id));
     * $destindir = "/".$part1."/".$part2."/".$part3;
     * // by reversing, directories are more evenly spread out. The
     * // first 26 directories already occupy 26 main levels
     *
     * more info on limitation:
     * - http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-talk/165372
     *
     * if you really need this for bigger numbers you probably have to look
     * at things like: http://theserverpages.com/php/manual/en/ref.bc.php
     * or: http://theserverpages.com/php/manual/en/ref.gmp.php
     * but I haven't really dugg into this. If you have more info on those
     * matters feel free to leave a comment.
     *
     * @param mixed $in String or long input to translate
     * @param bool $to_num Reverses translation when true
     * @param mixed $pad_up Number or boolean padds the result up to a specified length
     * @param mixed $passKey Supplying a password makes it harder to calculate the original ID
     *
     * @return string string or long
     * @author    Kevin van Zonneveld <kevin@vanzonneveld.net>
     * @author    Simon Franz
     * @author    Deadfish
     * @copyright 2008 Kevin van Zonneveld (http://kevin.vanzonneveld.net)
     * @license   http://www.opensource.org/licenses/bsd-license.php New BSD Licence
     * @version   SVN: Release: $Id: alphaID.inc.php 344 2009-06-10 17:43:59Z kevin $
     * @link      http://kevin.vanzonneveld.net/
     *
     */
    function generateAlphaId($in, $to_num = false, $pad_up = false, $passKey = null)
    {
        $index = "abcdefghijkmnpqrstuvwxyz123456789";
        if ($passKey !== null) {
            // Although this function's purpose is to just make the
            // ID short - and not so much secure,
            // with this patch by Simon Franz (http://blog.snaky.org/)
            // you can optionally supply a password to make it harder
            // to calculate the corresponding numeric ID
            $indexLen = mb_strlen($index);
            for ($n = 0; $n < $indexLen; $n++) {
                $i[] = $index[$n];
            }
            $passHash = hash('sha256', $passKey);
            $passHash = (mb_strlen($passHash) < mb_strlen($index)) ? hash('sha512', $passKey) : $passHash;

            for ($n = 0; $n < $indexLen; $n++) {
                $p[] = $passHash[$n];
            }
            array_multisort($p, SORT_DESC, $i);
            $index = implode($i);
        }
        $base = mb_strlen($index);
        if ($to_num) {
            // Digital number  <<--  alphabet letter code
            $in = strrev($in);
            $out = 0;
            $len = mb_strlen($in) - 1;
            for ($t = 0; $t <= $len; $t++) {
                $pow = $base ** ($len - $t);
                $out = $out + mb_strpos($index, $in[$t]) * $pow;
            }
            if (is_numeric($pad_up)) {
                $pad_up--;
                if ($pad_up > 0) {
                    $out -= $base ** $pad_up;
                }
            }
            $out = sprintf('%F', $out);
            $out = mb_substr($out, 0, mb_strpos($out, '.'));
        } else {
            // Digital number  -->>  alphabet letter code
            if (is_numeric($pad_up)) {
                $pad_up--;
                if ($pad_up > 0) {
                    $in += $base ** $pad_up;
                }
            }
            $out = "";
            for ($t = floor(log($in, $base)); $t >= 0; $t--) {
                $bcp = $base ** $t;
                $a = floor($in / $bcp) % $base;
                $out .= $index[$a];
                $in -= ($a * $bcp);
            }
            $out = strrev($out); // reverse
        }

        return $out;
    }
}
