# pytrail 🎥

The pytrail module is a powerful Python tool designed to simplify the process of retrieving movie trailers. With just a few lines of code, you can access the trailers for a wide range of movies. This module leverages popular movie databases and APIs to fetch accurate and up-to-date trailer information, making it a valuable asset for developers creating movie-related applications, websites, or services. Say goodbye to manual searching and enjoy seamless integration of movie trailers into your projects with the pytrail module.

## Installation 📥

Install pytrail using pip
```bash
pip install pytrail
```

## Documentation 📄

#### Example movie url

```python
from pytrail.models import Client

client = Client('red notice')
print(client.trailer) # Output: https://www.youtube.com/watch/?v=T6l3mM7AWew
```

## Authors ✍️

- [@new92](https://www.github.com/new92)

## Contributing 🤝

Contributions are always welcome!

See <a href="https://github.com/new92/pytrail/blob/main/CONTRIBUTING.md">contributing.md</a> for ways to get started.

Please adhere to this project's `code of conduct``. For more info please check the <a href="https://github.com/new92/pytrail/blob/main/CODE_OF_CONDUCT.md">CODE_OF_CONDUCT.md</a> file

## Feedback 💭

If you have any feedback, please reach out to us at <a href="mailto:new92github@gmail.com">this email address</a>.

**Feel free to contact us anytime ! You'll get a reply within a day. Please avoid using abusive or offensive language.
If you are reporting a bug or making a suggestion please make sure your report/suggestion is as much detailed as possible.**

## License 📜

[![License](https://img.shields.io/github/license/new92/pytrail?style=for-the-badge)](https://github.com/new92/pytrail/blob/main/LICENSE.md)