[Nette Framework](https://nette.org)
===================================

[Nette Framework](https://nette.org) is a popular tool for PHP web development. It is designed to be
as usable and as friendly as possible. It focuses on security and
performance and is definitely one of the safest PHP frameworks.

Nette Framework speaks your language and helps you to easily build better websites.

The [Quick Start tutorial](https://doc.nette.org/quickstart) gives you a first
introduction to the framework by creating a simple database driven application.


Over 10 Yrs of Development
--------------------------

We have been developing Nette for over 10 years- and counting! Libraries we provide are therefore highly mature, stable and widely used. They are trusted by a number of global corporations and many significant websites rely on us.


Catching Bronze
---------------

We aim to create Nette as a fun and easy to use framework, that programmers can fall in love with. And we seem to be doing it well! We were rated as the 3rd most popular framework in a survey [Best PHP Framework for 2015](https://www.sitepoint.com/best-php-framework-2015-sitepoint-survey-results/) by a well-know magazine SitePoint.


Security Is a Priority
----------------------

There is nothing we care about more than security. That is why we had built Nette as the safest PHP framework. It had passed many audits with flying colours, it eliminates safety traps like XSS, CSRF and brings out ground-breaking methods.


Libraries & Framework
---------------------

Nette consists of a number of handy standalone libraries, which can be used in any codebase, for example combined with WordPress or another framework. Careful, some of them are highly addictive! These are the components that Nette Framework is built on:

- [Application](https://github.com/nette/application) – The kernel of web application
- [Bootstrap](https://github.com/nette/bootstrap) – Bootstrap of your application
- [Caching](https://github.com/nette/caching) – Cache layer with set of storages
- [Component Model](https://github.com/nette/component-model) – Foundation for component systems
- [DI](https://github.com/nette/di) – Dependency Injection Container
- [Finder](https://github.com/nette/finder) – Find files and directories with an intuitive API
- [Database](https://github.com/nette/database) – Database layer
- [Forms](https://github.com/nette/forms) – Greatly facilitates secure web forms
- [Http](https://github.com/nette/http) – Layer for the HTTP request & response
- [Latte](https://github.com/nette/latte) – Amazing template engine
- [Mail](https://github.com/nette/mail) – Sending E-mails
- [Neon](https://github.com/nette/neon) – Loads and dumps NEON format
- [Php Generator](https://github.com/nette/php-generator) – PHP code generator
- [Robot Loader](https://github.com/nette/robot-loader) – The most comfortable autoloading
- [Routing](https://github.com/nette/routing) – Routing
- [Safe Stream](https://github.com/nette/safe-stream) – Safe atomic operations with files
- [Security](https://github.com/nette/security) – Provides access control system
- [Schema](https://github.com/nette/schema) – User data validation
- [Tester](https://github.com/nette/tester) – Enjoyable unit testing in PHP
- [Tracy](https://github.com/nette/tracy) – Debugging tool you will love ♥
- [Tokenizer](https://github.com/nette/tokenizer) – Source code tokenizer
- [Utils](https://github.com/nette/utils) – Utilities and Core Classes
