# Contributing to Lunix

Hey, thanks for considering to contribute to Lunix! I'm glad you're here! :smile:

## :deciduous_tree: Resources
- [Documentation](/documentation)
- [Bugs](https://github.com/noahdossan/Lunix/issues)
- [Discussions](https://github.com/noahdossan/Lunix/discussions)

[Build Instructions](https://github.com/noahdossan/Lunix?tab=readme-ov-file#build-instructions)

## :book: Code of Conduct

Please read the [Code of Conduct](/CODE_OF_CONDUCT.md).

## :bulb: Asking Questions

If you're having trouble with something (e.g. building Lunix), please use Discussions. For bugs, go to Issues.

## :warning: Opening an Issue

Before creating an issue, please check if you're running the latest version of Lunix. Update using `git pull` and rebuild Lunix, then try to replicate the issue.

## :bug: Bug Reports and Other Issues

Providing a well-detailed issue is a great way to contribute to Lunix. It helps improve Lunix for everyone.

## :mailbox: Feature Requests

Feature requests are welcome. I'm always looking for new ideas to add to Lunix.

## :construction: Submitting Pull Requests

Pull requests are very welcome! For most contributions, after your pull request is accepted and merged, you'll be invited to be a contributor of the repository.

- **Smaller is better.** Submit one pull request per bug fix or feature. A pull request should contain isolated changes pertaining to a single bug fix or feature implementation. Do not refactor or reformat unrelated code. It's better to submit many small pull requests rather than a single large one.
- **Add documentation.** Document your changes with code doc comments or in existing guides.
- **Update the CHANGELOG** for all enhancements and bug fixes. Include the corresponding issue number if one exists, and your GitHub username.
- **Use the repo's default branch.** Branch from and submit your pull request to the repo's default branch. Usually, this is main, but it could be dev, develop, or master.
- **Resolve any merge conflicts** that occur.
- **Promptly address any CI failures.** If your pull request fails to build or pass tests, please push another commit to fix it.

## :memo: Writing Commit Messages

Please [write a great commit message](https://chris.beams.io/posts/git-commit/).

1. Separate subject from body with a blank line.
2. Limit the subject line to 50 characters.
3. Do not end the subject line with a period.
4. Use the imperative mood in the subject line (example: "Fix networking issue").
5. Wrap the body at about 72 characters.
6. Use the body to explain **why**, *not what and how* (the code shows that!).
7. If applicable, prefix the title with the relevant component name (examples: "docs: Fix typo", "Fix missing avatar").

## :white_check_mark: Code Review

- **Review the code, not the author.** Look for and suggest improvements without disparaging or insulting the author. Provide actionable feedback and explain your reasoning.
- **You are not your code.** When your code is critiqued, questioned, or constructively criticized, remember that you are not your code. Do not take code review personally.
- **Always do your best.** No one writes bugs on purpose. Do your best and learn from your mistakes.
- Kindly note any violations to the guidelines specified in this document.

## Credits

Thanks to @jessesquires for providing this [CONTRIBUTING.md](https://github.com/jessesquires/.github/blob/main/CONTRIBUTING.md) template. :smile:

