import type { Config } from "tailwindcss";
import animatePlugin from "tailwindcss-animate";
import reactAriaComponentsPlugin from "tailwindcss-react-aria-components";

export default {
	content: ["./app/**/{**,.client,.server}/**/*.{js,jsx,ts,tsx}"],
	darkMode: "media",
	theme: {
		extend: {
			colors: {
				primary: {
					app: "var(--indigo-1)",
					"app-subtle": "var(--indigo-2)",
					element: "var(--indigo-3)",
					"element-hover": "var(--indigo-4)",
					"element-active": "var(--indigo-5)",
					DEFAULT: "var(--indigo-6)",
					hover: "var(--indigo-7)",
					active: "var(--indigo-8)",
					solid: "var(--indigo-9)",
					"solid-hover": "var(--indigo-10)",
					base: "var(--indigo-11)",
					"high-contrast": "var(--indigo-12)",
				},
				muted: {
					app: "var(--gray-1)",
					"app-subtle": "var(--gray-2)",
					element: "var(--gray-3)",
					"element-hover": "var(--gray-4)",
					"element-active": "var(--gray-5)",
					DEFAULT: "var(--gray-6)",
					hover: "var(--gray-7)",
					active: "var(--gray-8)",
					solid: "var(--gray-9)",
					"solid-hover": "var(--gray-10)",
					base: "var(--gray-11)",
					"high-contrast": "var(--gray-12)",
				},
				warning: {
					app: "var(--amber-1)",
					"app-subtle": "var(--amber-2)",
					element: "var(--amber-3)",
					"element-hover": "var(--amber-4)",
					"element-active": "var(--amber-5)",
					DEFAULT: "var(--amber-6)",
					hover: "var(--amber-7)",
					active: "var(--amber-8)",
					solid: "var(--amber-9)",
					"solid-hover": "var(--amber-10)",
					base: "var(--amber-11)",
					"high-contrast": "var(--amber-12)",
				},
				success: {
					app: "var(--green-1)",
					"app-subtle": "var(--green-2)",
					element: "var(--green-3)",
					"element-hover": "var(--green-4)",
					"element-active": "var(--green-5)",
					DEFAULT: "var(--green-6)",
					hover: "var(--green-7)",
					active: "var(--green-8)",
					solid: "var(--green-9)",
					"solid-hover": "var(--green-10)",
					base: "var(--green-11)",
					"high-contrast": "var(--green-12)",
				},
				danger: {
					app: "var(--red-1)",
					"app-subtle": "var(--red-2)",
					element: "var(--red-3)",
					"element-hover": "var(--red-4)",
					"element-active": "var(--red-5)",
					DEFAULT: "var(--red-6)",
					hover: "var(--red-7)",
					active: "var(--red-8)",
					solid: "var(--red-9)",
					"solid-hover": "var(--red-10)",
					base: "var(--red-11)",
					"high-contrast": "var(--red-12)",
				},
			},
		},
	},
	plugins: [animatePlugin, reactAriaComponentsPlugin],
} satisfies Config;
