/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
	"/api_keys": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get a list of API keys
		 * @description Retrieves the API keys for your Neon account.
		 *     The response does not include API key tokens. A token is only provided when creating an API key.
		 *     API keys can also be managed in the Neon Console.
		 *     For more information, see [Manage API keys](https://neon.tech/docs/manage/api-keys/).
		 *
		 */
		get: operations["listApiKeys"];
		put?: never;
		/**
		 * Create an API key
		 * @description Creates an API key.
		 *     The `key_name` is a user-specified name for the key.
		 *     This method returns an `id` and `key`. The `key` is a randomly generated, 64-bit token required to access the Neon API.
		 *     API keys can also be managed in the Neon Console.
		 *     See [Manage API keys](https://neon.tech/docs/manage/api-keys/).
		 *
		 */
		post: operations["createApiKey"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/api_keys/{key_id}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		get?: never;
		put?: never;
		post?: never;
		/**
		 * Revoke an API key
		 * @description Revokes the specified API key.
		 *     An API key that is no longer needed can be revoked.
		 *     This action cannot be reversed.
		 *     You can obtain `key_id` values by listing the API keys for your Neon account.
		 *     API keys can also be managed in the Neon Console.
		 *     See [Manage API keys](https://neon.tech/docs/manage/api-keys/).
		 *
		 */
		delete: operations["revokeApiKey"];
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/operations/{operation_id}": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The operation ID */
				operation_id: string;
			};
			cookie?: never;
		};
		/**
		 * Get operation details
		 * @description Retrieves details for the specified operation.
		 *     An operation is an action performed on a Neon project resource.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain a `operation_id` by listing operations for the project.
		 *
		 */
		get: operations["getProjectOperation"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get a list of projects
		 * @description Retrieves a list of projects for the Neon account.
		 *     A project is the top-level object in the Neon object hierarchy.
		 *     For more information, see [Manage projects](https://neon.tech/docs/manage/projects/).
		 *
		 */
		get: operations["listProjects"];
		put?: never;
		/**
		 * Create a project
		 * @description Creates a Neon project.
		 *     A project is the top-level object in the Neon object hierarchy.
		 *     Plan limits define how many projects you can create.
		 *     Neon's Free plan permits one project per Neon account.
		 *     For more information, see [Manage projects](https://neon.tech/docs/manage/projects/).
		 *
		 *     You can specify a region and Postgres version in the request body.
		 *     Neon currently supports PostgreSQL 14, 15, and 16.
		 *     For supported regions and `region_id` values, see [Regions](https://neon.tech/docs/introduction/regions/).
		 *
		 */
		post: operations["createProject"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/shared": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get a list of shared projects
		 * @description Retrieves a list of shared projects for the Neon account.
		 *     A project is the top-level object in the Neon object hierarchy.
		 *     For more information, see [Manage projects](https://neon.tech/docs/manage/projects/).
		 *
		 */
		get: operations["listSharedProjects"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		/**
		 * Get project details
		 * @description Retrieves information about the specified project.
		 *     A project is the top-level object in the Neon object hierarchy.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *
		 */
		get: operations["getProject"];
		put?: never;
		post?: never;
		/**
		 * Delete a project
		 * @description Deletes the specified project.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     Deleting a project is a permanent action.
		 *     Deleting a project also deletes endpoints, branches, databases, and users that belong to the project.
		 *
		 */
		delete: operations["deleteProject"];
		options?: never;
		head?: never;
		/**
		 * Update a project
		 * @description Updates the specified project.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     Neon permits updating the project name only.
		 *
		 */
		patch: operations["updateProject"];
		trace?: never;
	};
	"/projects/{project_id}/operations": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get a list of operations
		 * @description Retrieves a list of operations for the specified Neon project.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     The number of operations returned can be large.
		 *     To paginate the response, issue an initial request with a `limit` value.
		 *     Then, add the `cursor` value that was returned in the response to the next request.
		 *
		 */
		get: operations["listProjectOperations"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/permissions": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				project_id: string;
			};
			cookie?: never;
		};
		/**
		 * List project access
		 * @description Retrieves details about users who have access to the project, including the permission `id`, the granted-to email address, and the date project access was granted.
		 */
		get: operations["listProjectPermissions"];
		put?: never;
		/**
		 * Grant project access
		 * @description Grants project access to the account associated with the specified email address
		 */
		post: operations["grantPermissionToProject"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/permissions/{permission_id}": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				project_id: string;
				permission_id: string;
			};
			cookie?: never;
		};
		get?: never;
		put?: never;
		post?: never;
		/**
		 * Revoke project access
		 * @description Revokes project access from the user associted with the specified permisison `id`. You can retrieve a user's permission `id` by listing project access.
		 */
		delete: operations["revokePermissionFromProject"];
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/jwks": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		/**
		 * Returns all JWKS definitions for a project
		 * @description Returns all JWKS definitions for a project
		 *
		 */
		get: operations["getProjectJWKS"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/connection_uri": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get a connection URI
		 * @description Retrieves a connection URI for the specified database.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `database_name` by listing the databases for a branch.
		 *     You can obtain a `role_name` by listing the roles for a branch.
		 *
		 */
		get: operations["getConnectionURI"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		/**
		 * Get a list of branches
		 * @description Retrieves a list of branches for the specified project.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *
		 *     Each Neon project has a root branch named `main`.
		 *     A `branch_id` value has a `br-` prefix.
		 *     A project may contain child branches that were branched from `main` or from another branch.
		 *     A parent branch is identified by the `parent_id` value, which is the `id` of the parent branch.
		 *     For related information, see [Manage branches](https://neon.tech/docs/manage/branches/).
		 *
		 */
		get: operations["listProjectBranches"];
		put?: never;
		/**
		 * Create a branch
		 * @description Creates a branch in the specified project.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *
		 *     This method does not require a request body, but you can specify one to create a compute endpoint for the branch or to select a non-default parent branch.
		 *     The default behavior is to create a branch from the project's default branch with no compute endpoint, and the branch name is auto-generated.
		 *     There is a maximum of one read-write endpoint per branch.
		 *     A branch can have multiple read-only endpoints.
		 *     For related information, see [Manage branches](https://neon.tech/docs/manage/branches/).
		 *
		 */
		post: operations["createProjectBranch"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		/**
		 * Get branch details
		 * @description Retrieves information about the specified branch.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain a `branch_id` by listing the project's branches.
		 *     A `branch_id` value has a `br-` prefix.
		 *
		 *     Each Neon project is initially created with a root and default branch named `main`.
		 *     A project can contain one or more branches.
		 *     A parent branch is identified by a `parent_id` value, which is the `id` of the parent branch.
		 *     For related information, see [Manage branches](https://neon.tech/docs/manage/branches/).
		 *
		 */
		get: operations["getProjectBranch"];
		put?: never;
		post?: never;
		/**
		 * Delete a branch
		 * @description Deletes the specified branch from a project, and places
		 *     all compute endpoints into an idle state, breaking existing client connections.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain a `branch_id` by listing the project's branches.
		 *     For related information, see [Manage branches](https://neon.tech/docs/manage/branches/).
		 *
		 *     When a successful response status is received, the compute endpoints are still active,
		 *     and the branch is not yet deleted from storage.
		 *     The deletion occurs after all operations finish.
		 *     You cannot delete a project's root or default branch, and you cannot delete a branch that has a child branch.
		 *     A project must have at least one branch.
		 *
		 */
		delete: operations["deleteProjectBranch"];
		options?: never;
		head?: never;
		/**
		 * Update a branch
		 * @description Updates the specified branch.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     For more information, see [Manage branches](https://neon.tech/docs/manage/branches/).
		 *
		 */
		patch: operations["updateProjectBranch"];
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/restore": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		get?: never;
		put?: never;
		/**
		 * Restore a branch
		 * @description Restores a branch to an earlier state in its own or another branch's history
		 */
		post: operations["restoreProjectBranch"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/schema": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get the database schema
		 * @description Retrieves the schema from the specified database. The `lsn` and `timestamp` values cannot be specified at the same time. If both are omitted, the database schema is retrieved from database's head .
		 */
		get: operations["getProjectBranchSchema"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/set_as_primary": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		get?: never;
		put?: never;
		/**
		 * Set branch as primary
		 * @deprecated
		 * @description DEPRECATED. Use `/set_as_default` endpoint.
		 *     Sets the specified branch as the project's primary branch.
		 *     The primary designation is automatically removed from the previous primary branch.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     For more information, see [Manage branches](https://neon.tech/docs/manage/branches/).
		 *
		 */
		post: operations["setPrimaryProjectBranch"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/set_as_default": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		get?: never;
		put?: never;
		/**
		 * Set branch as default
		 * @description Sets the specified branch as the project's default branch.
		 *     The default designation is automatically removed from the previous default branch.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     For more information, see [Manage branches](https://neon.tech/docs/manage/branches/).
		 *
		 */
		post: operations["setDefaultProjectBranch"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/endpoints": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		/**
		 * Get a list of branch endpoints
		 * @description Retrieves a list of compute endpoints for the specified branch.
		 *     Neon permits only one read-write compute endpoint per branch.
		 *     A branch can have multiple read-only compute endpoints.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *
		 */
		get: operations["listProjectBranchEndpoints"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/databases": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		/**
		 * Get a list of databases
		 * @description Retrieves a list of databases for the specified branch.
		 *     A branch can have multiple databases.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     For related information, see [Manage databases](https://neon.tech/docs/manage/databases/).
		 *
		 */
		get: operations["listProjectBranchDatabases"];
		put?: never;
		/**
		 * Create a database
		 * @description Creates a database in the specified branch.
		 *     A branch can have multiple databases.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     For related information, see [Manage databases](https://neon.tech/docs/manage/databases/).
		 *
		 */
		post: operations["createProjectBranchDatabase"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/databases/{database_name}": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The database name */
				database_name: string;
			};
			cookie?: never;
		};
		/**
		 * Get database details
		 * @description Retrieves information about the specified database.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` and `database_name` by listing the branch's databases.
		 *     For related information, see [Manage databases](https://neon.tech/docs/manage/databases/).
		 *
		 */
		get: operations["getProjectBranchDatabase"];
		put?: never;
		post?: never;
		/**
		 * Delete a database
		 * @description Deletes the specified database from the branch.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` and `database_name` by listing the branch's databases.
		 *     For related information, see [Manage databases](https://neon.tech/docs/manage/databases/).
		 *
		 */
		delete: operations["deleteProjectBranchDatabase"];
		options?: never;
		head?: never;
		/**
		 * Update a database
		 * @description Updates the specified database in the branch.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` and `database_name` by listing the branch's databases.
		 *     For related information, see [Manage databases](https://neon.tech/docs/manage/databases/).
		 *
		 */
		patch: operations["updateProjectBranchDatabase"];
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/roles": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		/**
		 * Get a list of roles
		 * @description Retrieves a list of Postgres roles from the specified branch.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     For related information, see [Manage roles](https://neon.tech/docs/manage/roles/).
		 *
		 */
		get: operations["listProjectBranchRoles"];
		put?: never;
		/**
		 * Create a role
		 * @description Creates a Postgres role in the specified branch.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     For related information, see [Manage roles](https://neon.tech/docs/manage/roles/).
		 *
		 *     Connections established to the active compute endpoint will be dropped.
		 *     If the compute endpoint is idle, the endpoint becomes active for a short period of time and is suspended afterward.
		 *
		 */
		post: operations["createProjectBranchRole"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/roles/{role_name}": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The role name */
				role_name: string;
			};
			cookie?: never;
		};
		/**
		 * Get role details
		 * @description Retrieves details about the specified role.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     You can obtain the `role_name` by listing the roles for a branch.
		 *     In Neon, the terms "role" and "user" are synonymous.
		 *     For related information, see [Manage roles](https://neon.tech/docs/manage/roles/).
		 *
		 */
		get: operations["getProjectBranchRole"];
		put?: never;
		post?: never;
		/**
		 * Delete a role
		 * @description Deletes the specified Postgres role from the branch.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     You can obtain the `role_name` by listing the roles for a branch.
		 *     For related information, see [Manage roles](https://neon.tech/docs/manage/roles/).
		 *
		 */
		delete: operations["deleteProjectBranchRole"];
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/roles/{role_name}/reveal_password": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The role name */
				role_name: string;
			};
			cookie?: never;
		};
		/**
		 * Get role password
		 * @description Retrieves the password for the specified Postgres role, if possible.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     You can obtain the `role_name` by listing the roles for a branch.
		 *     For related information, see [Manage roles](https://neon.tech/docs/manage/roles/).
		 *
		 */
		get: operations["getProjectBranchRolePassword"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/branches/{branch_id}/roles/{role_name}/reset_password": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The role nam */
				role_name: string;
			};
			cookie?: never;
		};
		get?: never;
		put?: never;
		/**
		 * Reset the role password
		 * @description Resets the password for the specified Postgres role.
		 *     Returns a new password and operations. The new password is ready to use when the last operation finishes.
		 *     The old password remains valid until last operation finishes.
		 *     Connections to the compute endpoint are dropped. If idle,
		 *     the compute endpoint becomes active for a short period of time.
		 *
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain the `branch_id` by listing the project's branches.
		 *     You can obtain the `role_name` by listing the roles for a branch.
		 *     For related information, see [Manage roles](https://neon.tech/docs/manage/roles/).
		 *
		 */
		post: operations["resetProjectBranchRolePassword"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/endpoints": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		/**
		 * Get a list of compute endpoints
		 * @description Retrieves a list of compute endpoints for the specified project.
		 *     A compute endpoint is a Neon compute instance.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     For information about compute endpoints, see [Manage computes](https://neon.tech/docs/manage/endpoints/).
		 *
		 */
		get: operations["listProjectEndpoints"];
		put?: never;
		/**
		 * Create a compute endpoint
		 * @description Creates a compute endpoint for the specified branch.
		 *     An endpoint is a Neon compute instance.
		 *     There is a maximum of one read-write compute endpoint per branch.
		 *     If the specified branch already has a read-write compute endpoint, the operation fails.
		 *     A branch can have multiple read-only compute endpoints.
		 *
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain `branch_id` by listing the project's branches.
		 *     A `branch_id` has a `br-` prefix.
		 *     For supported regions and `region_id` values, see [Regions](https://neon.tech/docs/introduction/regions/).
		 *     For more information about compute endpoints, see [Manage computes](https://neon.tech/docs/manage/endpoints/).
		 *
		 */
		post: operations["createProjectEndpoint"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/endpoints/{endpoint_id}": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The endpoint ID */
				endpoint_id: string;
			};
			cookie?: never;
		};
		/**
		 * Get a compute endpoint
		 * @description Retrieves information about the specified compute endpoint.
		 *     A compute endpoint is a Neon compute instance.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain an `endpoint_id` by listing your project's compute endpoints.
		 *     An `endpoint_id` has an `ep-` prefix.
		 *     For information about compute endpoints, see [Manage computes](https://neon.tech/docs/manage/endpoints/).
		 *
		 */
		get: operations["getProjectEndpoint"];
		put?: never;
		post?: never;
		/**
		 * Delete a compute endpoint
		 * @description Delete the specified compute endpoint.
		 *     A compute endpoint is a Neon compute instance.
		 *     Deleting a compute endpoint drops existing network connections to the compute endpoint.
		 *     The deletion is completed when last operation in the chain finishes successfully.
		 *
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain an `endpoint_id` by listing your project's compute endpoints.
		 *     An `endpoint_id` has an `ep-` prefix.
		 *     For information about compute endpoints, see [Manage computes](https://neon.tech/docs/manage/endpoints/).
		 *
		 */
		delete: operations["deleteProjectEndpoint"];
		options?: never;
		head?: never;
		/**
		 * Update a compute endpoint
		 * @description Updates the specified compute endpoint.
		 *
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain an `endpoint_id` and `branch_id` by listing your project's compute endpoints.
		 *     An `endpoint_id` has an `ep-` prefix. A `branch_id` has a `br-` prefix.
		 *      For more information about compute endpoints, see [Manage computes](https://neon.tech/docs/manage/endpoints/).
		 *
		 *     If the returned list of operations is not empty, the compute endpoint is not ready to use.
		 *     The client must wait for the last operation to finish before using the compute endpoint.
		 *     If the compute endpoint was idle before the update, it becomes active for a short period of time,
		 *     and the control plane suspends it again after the update.
		 *
		 */
		patch: operations["updateProjectEndpoint"];
		trace?: never;
	};
	"/projects/{project_id}/endpoints/{endpoint_id}/jwks": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		get?: never;
		put?: never;
		/**
		 * Adds a JWKS to project's endpoint
		 * @description Add a new JWKS to a specific endpoint of a project
		 */
		post: operations["addEndpointJWKS"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/endpoints/{endpoint_id}/start": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		get?: never;
		put?: never;
		/**
		 * Start a compute endpoint
		 * @description Starts a compute endpoint. The compute endpoint is ready to use
		 *     after the last operation in chain finishes successfully.
		 *
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain an `endpoint_id` by listing your project's compute endpoints.
		 *     An `endpoint_id` has an `ep-` prefix.
		 *     For information about compute endpoints, see [Manage computes](https://neon.tech/docs/manage/endpoints/).
		 *
		 */
		post: operations["startProjectEndpoint"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/endpoints/{endpoint_id}/suspend": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The endpoint ID */
				endpoint_id: string;
			};
			cookie?: never;
		};
		get?: never;
		put?: never;
		/**
		 * Suspend a compute endpoint
		 * @description Suspend the specified compute endpoint
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain an `endpoint_id` by listing your project's compute endpoints.
		 *     An `endpoint_id` has an `ep-` prefix.
		 *     For information about compute endpoints, see [Manage computes](https://neon.tech/docs/manage/endpoints/).
		 *
		 */
		post: operations["suspendProjectEndpoint"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/projects/{project_id}/endpoints/{endpoint_id}/restart": {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The endpoint ID */
				endpoint_id: string;
			};
			cookie?: never;
		};
		get?: never;
		put?: never;
		/**
		 * Restart a compute endpoint
		 * @description Restart the specified compute endpoint: suspend immediately followed by start operations.
		 *     You can obtain a `project_id` by listing the projects for your Neon account.
		 *     You can obtain an `endpoint_id` by listing your project's compute endpoints.
		 *     An `endpoint_id` has an `ep-` prefix.
		 *     For information about compute endpoints, see [Manage computes](https://neon.tech/docs/manage/endpoints/).
		 *
		 */
		post: operations["restartProjectEndpoint"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/consumption_history/account": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get account consumption metrics
		 * @description Retrieves consumption metrics for Scale plan accounts. History begins at the time of upgrade.
		 *     Available for Scale plan users only.
		 *
		 */
		get: operations["getConsumptionHistoryPerAccount"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/consumption_history/projects": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get consumption metrics for each project
		 * @description Retrieves consumption metrics for Scale plan projects. History begins at the time of upgrade.
		 *     Available for Scale plan users only.
		 *
		 */
		get: operations["getConsumptionHistoryPerProject"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/consumption/projects": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get project consumption metrics
		 * @deprecated
		 * @description Retrieves consumption metrics for each project for the current billing period.
		 *     For usage information, see [Retrieving metrics for all projects](https://neon.tech/docs/guides/partner-billing#retrieving-metrics-for-all-projects).
		 *
		 */
		get: operations["listProjectsConsumption"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/users/me": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get current user details
		 * @description Retrieves information about the current Neon user account.
		 *
		 */
		get: operations["getCurrentUserInfo"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/users/me/organizations": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Get current user organizations list
		 * @description Retrieves information about the current Neon user's organizations
		 *
		 */
		get: operations["getCurrentUserOrganizations"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
}
export type webhooks = Record<string, never>;
export interface components {
	schemas: {
		Features: {
			[key: string]: boolean;
		};
		FeatureFlags: {
			[key: string]: boolean | string;
		};
		ComputeUnit: number;
		/**
		 * @description The Neon compute provisioner.
		 *     Specify the `k8s-neonvm` provisioner to create a compute endpoint that supports Autoscaling.
		 *
		 * @enum {string}
		 */
		Provisioner: "k8s-pod" | "k8s-neonvm";
		PaginationResponse: {
			pagination?: components["schemas"]["Pagination"];
		};
		/**
		 * @description Cursor based pagination is used. The user must pass the cursor as is to the backend.
		 *     For more information about cursor based pagination, see
		 *     https://learn.microsoft.com/en-us/ef/core/querying/pagination#keyset-pagination
		 *
		 * @example {
		 *       "cursor": "2022-12-07T00:45:05.262011Z"
		 *     }
		 */
		Pagination: {
			cursor: string;
		};
		/** @description Empty response. */
		EmptyResponse: Record<string, never>;
		/** @description Add a new JWKS to a specific endpoint of a project */
		AddEndpointJWKSRequest: {
			/** @description The URL that lists the JWKS */
			jwks_url: string;
			/** @description The name of the authentication provider (e.g., Clerk, Stytch, Auth0) */
			provider_name: string;
		};
		JWKS: {
			/** @description JWKS ID */
			id: string;
			/** @description Project ID */
			project_id: string;
			/** @description Endpoint ID */
			endpoint_id: string;
			/** @description The URL that lists the JWKS */
			jwks_url: string;
			/** @description The name of the authentication provider (e.g., Clerk, Stytch, Auth0) */
			provider_name: string;
			/**
			 * Format: date-time
			 * @description The date and time when the JWKS was created
			 */
			created_at: string;
			/**
			 * Format: date-time
			 * @description The date and time when the JWKS was last modified
			 */
			updated_at: string;
		};
		/** @description The list of configured JWKS definitions for a project */
		ProjectJWKSResponse: {
			jwks: components["schemas"]["JWKS"][];
		};
		ApiKeyCreateRequest: {
			/** @description A user-specified API key name. This value is required when creating an API key. */
			key_name: string;
		};
		ApiKeyCreateResponse: {
			/**
			 * Format: int64
			 * @description The API key ID
			 */
			id: number;
			/** @description The generated 64-bit token required to access the Neon API */
			key: string;
			/** @description The user-specified API key name */
			name: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the API key was created
			 */
			created_at: string;
		};
		ApiKeyRevokeResponse: {
			/**
			 * Format: int64
			 * @description The API key ID
			 */
			id: number;
			/** @description The user-specified API key name */
			name: string;
			/** @description A `true` or `false` value indicating whether the API key is revoked */
			revoked: boolean;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the API was last used
			 */
			last_used_at?: string | null;
			/** @description The IP address from which the API key was last used */
			last_used_from_addr: string;
		};
		ApiKeysListResponseItem: {
			/**
			 * Format: int64
			 * @description The API key ID
			 */
			id: number;
			/** @description The user-specified API key name */
			name: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the API key was created
			 */
			created_at: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the API was last used
			 */
			last_used_at?: string | null;
			/** @description The IP address from which the API key was last used */
			last_used_from_addr: string;
		};
		/** @example [
		 *       {
		 *         "id": "a07f8772-1877-4da9-a939-3a3ae62d1d8d",
		 *         "project_id": "spring-example-302709",
		 *         "branch_id": "br-wispy-meadow-118737",
		 *         "endpoint_id": "ep-silent-smoke-806639",
		 *         "action": "create_branch",
		 *         "status": "running",
		 *         "failures_count": 0,
		 *         "created_at": "2022-11-08T23:33:16Z",
		 *         "updated_at": "2022-11-08T23:33:20Z",
		 *         "total_duration_ms": 400
		 *       },
		 *       {
		 *         "id": "d8ac46eb-a757-42b1-9907-f78322ee394e",
		 *         "project_id": "spring-example-302709",
		 *         "branch_id": "br-wispy-meadow-118737",
		 *         "endpoint_id": "ep-silent-smoke-806639",
		 *         "action": "start_compute",
		 *         "status": "finished",
		 *         "failures_count": 0,
		 *         "created_at": "2022-11-15T20:02:00Z",
		 *         "updated_at": "2022-11-15T20:02:02Z",
		 *         "total_duration_ms": 200
		 *       }
		 *     ] */
		Operation: {
			/**
			 * Format: uuid
			 * @description The operation ID
			 */
			id: string;
			/** @description The Neon project ID */
			project_id: string;
			/** @description The branch ID */
			branch_id?: string;
			/** @description The endpoint ID */
			endpoint_id?: string;
			action: components["schemas"]["OperationAction"];
			status: components["schemas"]["OperationStatus"];
			/** @description The error that occured */
			error?: string;
			/**
			 * Format: int32
			 * @description The number of times the operation failed
			 */
			failures_count: number;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the operation was last retried
			 */
			retry_at?: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the operation was created
			 */
			created_at: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the operation status was last updated
			 */
			updated_at: string;
			/**
			 * Format: int32
			 * @description The total duration of the operation in milliseconds
			 */
			total_duration_ms: number;
		};
		OperationResponse: {
			operation: components["schemas"]["Operation"];
		};
		OperationsResponse: {
			operations: components["schemas"]["Operation"][];
		};
		/**
		 * @description The action performed by the operation
		 * @enum {string}
		 */
		OperationAction:
			| "create_compute"
			| "create_timeline"
			| "start_compute"
			| "suspend_compute"
			| "apply_config"
			| "check_availability"
			| "delete_timeline"
			| "create_branch"
			| "tenant_ignore"
			| "tenant_attach"
			| "tenant_detach"
			| "tenant_reattach"
			| "replace_safekeeper"
			| "disable_maintenance"
			| "apply_storage_config"
			| "prepare_secondary_pageserver"
			| "switch_pageserver";
		/**
		 * @description The status of the operation
		 * @enum {string}
		 */
		OperationStatus:
			| "scheduling"
			| "running"
			| "finished"
			| "failed"
			| "error"
			| "cancelling"
			| "cancelled"
			| "skipped";
		/**
		 * @description Essential data about the project. Full data is available at the getProject endpoint.
		 *
		 * @example {
		 *       "id": "spring-example-302709",
		 *       "platform_id": "aws",
		 *       "region_id": "aws-us-east-2",
		 *       "name": "spring-example-302709",
		 *       "provisioner": "k8s-pod",
		 *       "pg_version": 15,
		 *       "proxy_host": "us-east-2.aws.neon.tech",
		 *       "store_passwords": true,
		 *       "creation_source": "console",
		 *       "created_at": "2022-12-13T01:30:55Z",
		 *       "updated_at": "2022-12-13T01:30:55Z"
		 *     }
		 */
		ProjectListItem: {
			/** @description The project ID
			 *      */
			id: string;
			/** @description The cloud platform identifier. Currently, only AWS is supported, for which the identifier is `aws`.
			 *      */
			platform_id: string;
			/** @description The region identifier
			 *      */
			region_id: string;
			/** @description The project name
			 *      */
			name: string;
			provisioner: components["schemas"]["Provisioner"];
			default_endpoint_settings?: components["schemas"]["DefaultEndpointSettings"];
			settings?: components["schemas"]["ProjectSettingsData"];
			pg_version: components["schemas"]["PgVersion"];
			/** @description The proxy host for the project. This value combines the `region_id`, the `platform_id`, and the Neon domain (`neon.tech`).
			 *      */
			proxy_host: string;
			/**
			 * Format: int64
			 * @description The logical size limit for a branch. The value is in MiB.
			 *
			 */
			branch_logical_size_limit: number;
			/**
			 * Format: int64
			 * @description The logical size limit for a branch. The value is in B.
			 *
			 */
			branch_logical_size_limit_bytes: number;
			/** @description Whether or not passwords are stored for roles in the Neon project. Storing passwords facilitates access to Neon features that require authorization.
			 *      */
			store_passwords: boolean;
			/**
			 * Format: int64
			 * @description Control plane observed endpoints of this project being active this amount of wall-clock time.
			 *
			 */
			active_time: number;
			/**
			 * Format: int64
			 * @deprecated
			 * @description DEPRECATED. Use data from the getProject endpoint instead.
			 *
			 */
			cpu_used_sec: number;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when project maintenance begins. If set, the project is placed into maintenance mode at this time.
			 *
			 */
			maintenance_starts_at?: string;
			/** @description The project creation source
			 *      */
			creation_source: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the project was created
			 *
			 */
			created_at: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the project was last updated
			 *
			 */
			updated_at: string;
			/**
			 * Format: int64
			 * @description The current space occupied by the project in storage, in bytes. Synthetic storage size combines the logical data size and Write-Ahead Log (WAL) size for all branches in a project.
			 *
			 */
			synthetic_storage_size?: number;
			/**
			 * Format: date-time
			 * @deprecated
			 * @description DEPRECATED. Use `consumption_period_end` from the getProject endpoint instead.
			 *     A timestamp indicating when the project quota resets
			 *
			 */
			quota_reset_at?: string;
			owner_id: string;
			/**
			 * Format: date-time
			 * @description The most recent time when any endpoint of this project was active.
			 *
			 *     Omitted when observed no actitivy for endpoints of this project.
			 *
			 */
			compute_last_active_at?: string;
			/** @description Organization id if a project belongs to organization.
			 *     Permissions for the project will be given to organization members as defined by the organization admins.
			 *     The permissions of the project do not depend on the user that created the project if a project belongs to an organization.
			 *      */
			org_id?: string;
		};
		/** @example {
		 *       "id": "spring-example-302709",
		 *       "platform_id": "aws",
		 *       "region_id": "aws-us-east-2",
		 *       "name": "spring-example-302709",
		 *       "provisioner": "k8s-pod",
		 *       "pg_version": 15,
		 *       "proxy_host": "us-east-2.aws.neon.tech",
		 *       "store_passwords": true,
		 *       "creation_source": "console",
		 *       "history_retention_seconds": 604800,
		 *       "created_at": "2022-12-13T01:30:55Z",
		 *       "updated_at": "2022-12-13T01:30:55Z",
		 *       "owner": {
		 *         "email": "some@email.com",
		 *         "branches_limit": 10,
		 *         "subscription_type": "scale"
		 *       },
		 *       "org_id": "org-morning-bread-81040908"
		 *     } */
		Project: {
			/**
			 * Format: int64
			 * @description Bytes-Hour. Project consumed that much storage hourly during the billing period. The value has some lag.
			 *     The value is reset at the beginning of each billing period.
			 *
			 */
			data_storage_bytes_hour: number;
			/**
			 * Format: int64
			 * @description Bytes. Egress traffic from the Neon cloud to the client for given project over the billing period.
			 *     Includes deleted endpoints. The value has some lag. The value is reset at the beginning of each billing period.
			 *
			 */
			data_transfer_bytes: number;
			/**
			 * Format: int64
			 * @description Bytes. Amount of WAL that travelled through storage for given project across all branches.
			 *     The value has some lag. The value is reset at the beginning of each billing period.
			 *
			 */
			written_data_bytes: number;
			/**
			 * Format: int64
			 * @description Seconds. The number of CPU seconds used by the project's compute endpoints, including compute endpoints that have been deleted.
			 *     The value has some lag. The value is reset at the beginning of each billing period.
			 *     Examples:
			 *     1. An endpoint that uses 1 CPU for 1 second is equal to `compute_time=1`.
			 *     2. An endpoint that uses 2 CPUs simultaneously for 1 second is equal to `compute_time=2`.
			 *
			 */
			compute_time_seconds: number;
			/**
			 * Format: int64
			 * @description Seconds. Control plane observed endpoints of this project being active this amount of wall-clock time.
			 *     The value has some lag.
			 *     The value is reset at the beginning of each billing period.
			 *
			 */
			active_time_seconds: number;
			/**
			 * Format: int64
			 * @deprecated
			 * @description DEPRECATED, use compute_time instead.
			 *
			 */
			cpu_used_sec: number;
			/** @description The project ID
			 *      */
			id: string;
			/** @description The cloud platform identifier. Currently, only AWS is supported, for which the identifier is `aws`.
			 *      */
			platform_id: string;
			/** @description The region identifier
			 *      */
			region_id: string;
			/** @description The project name
			 *      */
			name: string;
			provisioner: components["schemas"]["Provisioner"];
			default_endpoint_settings?: components["schemas"]["DefaultEndpointSettings"];
			settings?: components["schemas"]["ProjectSettingsData"];
			pg_version: components["schemas"]["PgVersion"];
			/** @description The proxy host for the project. This value combines the `region_id`, the `platform_id`, and the Neon domain (`neon.tech`).
			 *      */
			proxy_host: string;
			/**
			 * Format: int64
			 * @description The logical size limit for a branch. The value is in MiB.
			 *
			 */
			branch_logical_size_limit: number;
			/**
			 * Format: int64
			 * @description The logical size limit for a branch. The value is in B.
			 *
			 */
			branch_logical_size_limit_bytes: number;
			/** @description Whether or not passwords are stored for roles in the Neon project. Storing passwords facilitates access to Neon features that require authorization.
			 *      */
			store_passwords: boolean;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when project maintenance begins. If set, the project is placed into maintenance mode at this time.
			 *
			 */
			maintenance_starts_at?: string;
			/** @description The project creation source
			 *      */
			creation_source: string;
			/**
			 * Format: int32
			 * @description The number of seconds to retain point-in-time restore (PITR) backup history for this project.
			 *
			 */
			history_retention_seconds: number;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the project was created
			 *
			 */
			created_at: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the project was last updated
			 *
			 */
			updated_at: string;
			/**
			 * Format: int64
			 * @description The current space occupied by the project in storage, in bytes. Synthetic storage size combines the logical data size and Write-Ahead Log (WAL) size for all branches in a project.
			 *
			 */
			synthetic_storage_size?: number;
			/**
			 * Format: date-time
			 * @description A date-time indicating when Neon Cloud started measuring consumption for current consumption period.
			 *
			 */
			consumption_period_start: string;
			/**
			 * Format: date-time
			 * @description A date-time indicating when Neon Cloud plans to stop measuring consumption for current consumption period.
			 *
			 */
			consumption_period_end: string;
			/**
			 * Format: date-time
			 * @deprecated
			 * @description DEPRECATED. Use `consumption_period_end` from the getProject endpoint instead.
			 *     A timestamp indicating when the project quota resets.
			 *
			 */
			quota_reset_at?: string;
			owner_id: string;
			owner?: components["schemas"]["ProjectOwnerData"];
			/**
			 * Format: date-time
			 * @description The most recent time when any endpoint of this project was active.
			 *
			 *     Omitted when observed no actitivy for endpoints of this project.
			 *
			 */
			compute_last_active_at?: string;
			org_id?: string;
		};
		ProjectCreateRequest: {
			project: {
				settings?: components["schemas"]["ProjectSettingsData"];
				/** @description The project name */
				name?: string;
				branch?: {
					/** @description The branch name. If not specified, the default branch name will be used.
					 *      */
					name?: string;
					/** @description The role name. If not specified, the default role name will be used.
					 *      */
					role_name?: string;
					/** @description The database name. If not specified, the default database name will be used.
					 *      */
					database_name?: string;
				};
				/**
				 * @deprecated
				 * @description DEPRECATED, use default_endpoint_settings.autoscaling_limit_min_cu instead.
				 *
				 *     The minimum number of Compute Units. The minimum value is `0.25`.
				 *     See [Compute size and Autoscaling configuration](https://neon.tech/docs/manage/endpoints#compute-size-and-autoscaling-configuration)
				 *     for more information.
				 *
				 */
				autoscaling_limit_min_cu?: components["schemas"]["ComputeUnit"];
				/**
				 * @deprecated
				 * @description DEPRECATED, use default_endpoint_settings.autoscaling_limit_max_cu instead.
				 *
				 *     The maximum number of Compute Units. See [Compute size and Autoscaling configuration](https://neon.tech/docs/manage/endpoints#compute-size-and-autoscaling-configuration)
				 *     for more information.
				 *
				 */
				autoscaling_limit_max_cu?: components["schemas"]["ComputeUnit"];
				provisioner?: components["schemas"]["Provisioner"];
				/** @description The region identifier. Refer to our [Regions](https://neon.tech/docs/introduction/regions) documentation for supported regions. Values are specified in this format: `aws-us-east-1`
				 *      */
				region_id?: string;
				default_endpoint_settings?: components["schemas"]["DefaultEndpointSettings"];
				pg_version?: components["schemas"]["PgVersion"];
				/** @description Whether or not passwords are stored for roles in the Neon project. Storing passwords facilitates access to Neon features that require authorization.
				 *      */
				store_passwords?: boolean;
				/**
				 * Format: int32
				 * @description The number of seconds to retain the point-in-time restore (PITR) backup history for this project.
				 *     The default is 604800 seconds (7 days).
				 *
				 */
				history_retention_seconds?: number;
				/** @description Organization id in case the project created belongs to an organization.
				 *     If not present, project is owned by a user and not by org.
				 *      */
				org_id?: string;
			};
		};
		ProjectUpdateRequest: {
			project: {
				settings?: components["schemas"]["ProjectSettingsData"];
				/** @description The project name */
				name?: string;
				default_endpoint_settings?: components["schemas"]["DefaultEndpointSettings"];
				/**
				 * Format: int32
				 * @description The number of seconds to retain the point-in-time restore (PITR) backup history for this project.
				 *     The default is 604800 seconds (7 days).
				 *
				 */
				history_retention_seconds?: number;
			};
		};
		ProjectSettingsData: {
			quota?: components["schemas"]["ProjectQuota"];
			allowed_ips?: components["schemas"]["AllowedIps"];
			/** @description Sets wal_level=logical for all compute endpoints in this project.
			 *     All active endpoints will be suspended.
			 *     Once enabled, logical replication cannot be disabled.
			 *      */
			enable_logical_replication?: boolean;
		};
		ProjectResponse: {
			project: components["schemas"]["Project"];
		};
		ProjectsResponse: {
			projects: components["schemas"]["ProjectListItem"][];
		};
		ProjectPermission: {
			id: string;
			granted_to_email: string;
			/** Format: date-time */
			granted_at: string;
			/** Format: date-time */
			revoked_at?: string;
		};
		ProjectPermissions: {
			project_permissions: components["schemas"]["ProjectPermission"][];
		};
		GrantPermissionToProjectRequest: {
			email: string;
		};
		ConsumptionHistoryPerAccountResponse: {
			periods: components["schemas"]["ConsumptionHistoryPerPeriod"][];
		};
		ConsumptionHistoryPerProjectResponse: {
			projects: components["schemas"]["ConsumptionHistoryPerProject"][];
		};
		ConsumptionHistoryPerProject: {
			project_id: string;
			periods: components["schemas"]["ConsumptionHistoryPerPeriod"][];
		};
		/** @example {
		 *       "period_id": "79ec829f-1828-4006-ac82-9f1828a0067d",
		 *       "consumption": [
		 *         {
		 *           "timeframe_start": "2024-03-22T00:00:00Z",
		 *           "timeframe_end": "2024-03-23T00:00:00Z",
		 *           "active_time_seconds": 27853,
		 *           "compute_time_seconds": 18346,
		 *           "written_data_bytes": 1073741824,
		 *           "synthetic_storage_size_bytes": 5368709120
		 *         },
		 *         {
		 *           "timeframe_start": "2024-03-23T00:00:00Z",
		 *           "timeframe_end": "2024-03-24T00:00:00Z",
		 *           "active_time_seconds": 17498,
		 *           "compute_time_seconds": 3378,
		 *           "written_data_bytes": 5741824,
		 *           "synthetic_storage_size_bytes": 2370912
		 *         }
		 *       ]
		 *     } */
		ConsumptionHistoryPerPeriod: {
			/** Format: uuid */
			period_id: string;
			consumption: components["schemas"]["ConsumptionHistoryPerTimeframe"][];
		};
		ConsumptionHistoryPerTimeframe: {
			/** Format: date-time */
			timeframe_start: string;
			/** Format: date-time */
			timeframe_end: string;
			/** Format: uint64 */
			active_time_seconds: number;
			/** Format: uint64 */
			compute_time_seconds: number;
			/** Format: uint64 */
			written_data_bytes: number;
			/** Format: uint64 */
			synthetic_storage_size_bytes: number;
			/** Format: uint64 */
			data_storage_bytes_hour?: number;
		};
		/** @enum {string} */
		ConsumptionHistoryGranularity: "hourly" | "daily" | "monthly";
		ProjectsConsumptionResponse: {
			projects: components["schemas"]["ProjectConsumption"][];
			/** Format: int64 */
			periods_in_response: number;
		};
		ProjectConsumption: {
			/** @description The project ID */
			project_id: string;
			/**
			 * Format: uuid
			 * @description The Id of the consumption period, used to reference the `previous_period_id` field.
			 *
			 */
			period_id: string;
			/**
			 * Format: int64
			 * @description Bytes-Hour. The amount of storage the project consumed during the billing period. Expect some lag in the reported value.
			 *     The value is reset at the beginning of each billing period.
			 *
			 */
			data_storage_bytes_hour: number;
			/**
			 * Format: date-time
			 * @description The timestamp of the last update of the `data_storage_bytes_hour` field.
			 *
			 */
			data_storage_bytes_hour_updated_at?: string;
			/**
			 * Format: int64
			 * @description Bytes. The current space occupied by project in storage. Expect some lag in the reported value.
			 *
			 */
			synthetic_storage_size: number;
			/**
			 * Format: date-time
			 * @description The timestamp of the last update of the `synthetic_storage_size` field.
			 *
			 */
			synthetic_storage_size_updated_at?: string;
			/**
			 * Format: int64
			 * @description Bytes. The egress traffic from the Neon cloud to the client for the project over the billing period.
			 *     Includes egress traffic for deleted endpoints. Expect some lag in the reported value. The value is reset at the beginning of each billing period.
			 *
			 */
			data_transfer_bytes: number;
			/**
			 * Format: date-time
			 * @description Timestamp of the last update of `data_transfer_bytes` field
			 *
			 */
			data_transfer_bytes_updated_at?: string;
			/**
			 * Format: int64
			 * @description Bytes. The Amount of WAL that travelled through storage for given project for all branches.
			 *     Expect some lag in the reported value. The value is reset at the beginning of each billing period.
			 *
			 */
			written_data_bytes: number;
			/**
			 * Format: date-time
			 * @description The timestamp of the last update of `written_data_bytes` field.
			 *
			 */
			written_data_bytes_updated_at?: string;
			/**
			 * Format: int64
			 * @description Seconds. The number of CPU seconds used by the project's compute endpoints, including compute endpoints that have been deleted.
			 *     Expect some lag in the reported value. The value is reset at the beginning of each billing period.
			 *     Examples:
			 *     1. An endpoint that uses 1 CPU for 1 second is equal to `compute_time=1`.
			 *     2. An endpoint that uses 2 CPUs simultaneously for 1 second is equal to `compute_time=2`.
			 *
			 */
			compute_time_seconds: number;
			/**
			 * Format: date-time
			 * @description The timestamp of the last update of `compute_time_seconds` field.
			 *
			 */
			compute_time_seconds_updated_at?: string;
			/**
			 * Format: int64
			 * @description Seconds. The amount of time that compute endpoints in this project have been active.
			 *     Expect some lag in the reported value.
			 *
			 *     The value is reset at the beginning of each billing period.
			 *
			 */
			active_time_seconds: number;
			/**
			 * Format: date-time
			 * @description The timestamp of the last update of the `active_time_seconds` field.
			 *
			 */
			active_time_seconds_updated_at?: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the period was last updated.
			 *
			 */
			updated_at: string;
			/**
			 * Format: date-time
			 * @description The start of the consumption period.
			 *
			 */
			period_start: string;
			/**
			 * Format: date-time
			 * @description The end of the consumption period.
			 *
			 */
			period_end: string | null;
			/**
			 * Format: uuid
			 * @description The `period_id` of the previous consumption period.
			 *
			 */
			previous_period_id: string | null;
		};
		ProjectLimits: {
			limits: {
				/** Format: int64 */
				active_time: number;
				max_projects: number;
				max_branches: number;
				max_protected_branches: number;
				/** Format: float64 */
				max_autoscaling_cu: number;
				/** Format: int64 */
				cpu_seconds: number;
				/** Format: int64 */
				max_compute_time_non_primary: number;
				max_active_endpoints: number;
				max_read_only_endpoints: number;
				max_allowed_ips: number;
				max_monitoring_retention_hours: number;
				/** Format: int32 */
				max_history_retention_seconds: number;
				min_autosuspend_seconds: number;
				/** Format: int64 */
				max_data_transfer: number;
			};
			features: components["schemas"]["Features"];
		};
		/** @example {
		 *       "id": "br-wispy-meadow-118737",
		 *       "project_id": "spring-example-302709",
		 *       "parent_id": "br-aged-salad-637688",
		 *       "parent_lsn": "0/1DE2850",
		 *       "name": "dev2",
		 *       "protected": false,
		 *       "current_state": "ready",
		 *       "creation_source": "console",
		 *       "created_at": "2022-11-30T19:09:48Z",
		 *       "updated_at": "2022-12-01T19:53:05Z",
		 *       "primary": true,
		 *       "default": true
		 *     } */
		Branch: {
			/** @description The branch ID. This value is generated when a branch is created. A `branch_id` value has a `br` prefix. For example: `br-small-term-683261`.
			 *      */
			id: string;
			/** @description The ID of the project to which the branch belongs
			 *      */
			project_id: string;
			/** @description The `branch_id` of the parent branch
			 *      */
			parent_id?: string;
			/** @description The Log Sequence Number (LSN) on the parent branch from which this branch was created
			 *      */
			parent_lsn?: string;
			/**
			 * Format: date-time
			 * @description The point in time on the parent branch from which this branch was created
			 *
			 */
			parent_timestamp?: string;
			/** @description The branch name
			 *      */
			name: string;
			current_state: components["schemas"]["BranchState"];
			pending_state?: components["schemas"]["BranchState"];
			/**
			 * Format: int64
			 * @description The logical size of the branch, in bytes
			 *
			 */
			logical_size?: number;
			/** @description The branch creation source
			 *      */
			creation_source: string;
			/**
			 * @deprecated
			 * @description DEPRECATED. Use `default` field.
			 *     Whether the branch is the project's primary branch
			 *
			 */
			primary: boolean;
			/** @description Whether the branch is the project's default branch
			 *      */
			default: boolean;
			/** @description Whether the branch is protected
			 *      */
			protected: boolean;
			/**
			 * Format: int64
			 * @deprecated
			 * @description CPU seconds used by all of the branch's compute endpoints, including deleted ones.
			 *     This value is reset at the beginning of each billing period.
			 *     Examples:
			 *     1. A branch that uses 1 CPU for 1 second is equal to `cpu_used_sec=1`.
			 *     2. A branch that uses 2 CPUs simultaneously for 1 second is equal to `cpu_used_sec=2`.
			 *
			 */
			cpu_used_sec: number;
			/** Format: int64 */
			compute_time_seconds: number;
			/** Format: int64 */
			active_time_seconds: number;
			/** Format: int64 */
			written_data_bytes: number;
			/** Format: int64 */
			data_transfer_bytes: number;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the branch was created
			 *
			 */
			created_at: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the branch was last updated
			 *
			 */
			updated_at: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the branch was last reset
			 *
			 */
			last_reset_at?: string;
		};
		/**
		 * @description The branch state
		 * @enum {string}
		 */
		BranchState: "init" | "ready";
		BranchCreateRequestEndpointOptions: {
			type: components["schemas"]["EndpointType"];
			/** @description The minimum number of Compute Units. The minimum value is `0.25`.
			 *         See [Compute size and Autoscaling configuration](https://neon.tech/docs/manage/endpoints#compute-size-and-autoscaling-configuration)
			 *         for more information.
			 *      */
			autoscaling_limit_min_cu?: components["schemas"]["ComputeUnit"];
			/** @description The maximum number of Compute Units.
			 *         See [Compute size and Autoscaling configuration](https://neon.tech/docs/manage/endpoints#compute-size-and-autoscaling-configuration)
			 *         for more information.
			 *      */
			autoscaling_limit_max_cu?: components["schemas"]["ComputeUnit"];
			provisioner?: components["schemas"]["Provisioner"];
			suspend_timeout_seconds?: components["schemas"]["SuspendTimeoutSeconds"];
		};
		BranchCreateRequest: {
			endpoints?: components["schemas"]["BranchCreateRequestEndpointOptions"][];
			branch?: {
				/** @description The `branch_id` of the parent branch. If omitted or empty, the branch will be created from the project's default branch.
				 *      */
				parent_id?: string;
				/** @description The branch name
				 *      */
				name?: string;
				/** @description A Log Sequence Number (LSN) on the parent branch. The branch will be created with data from this LSN.
				 *      */
				parent_lsn?: string;
				/**
				 * Format: date-time
				 * @description A timestamp identifying a point in time on the parent branch. The branch will be created with data starting from this point in time.
				 *     The timestamp must be provided in ISO 8601 format; for example: `2024-02-26T12:00:00Z`.
				 *
				 */
				parent_timestamp?: string;
				/** @description Whether the branch is protected
				 *      */
				protected?: boolean;
			};
		};
		BranchUpdateRequest: {
			branch: {
				name?: string;
				protected?: boolean;
			};
		};
		BranchRestoreRequest: {
			/** @description The `branch_id` of the restore source branch.
			 *     If `source_timestamp` and `source_lsn` are omitted, the branch will be restored to head.
			 *     If `source_branch_id` is equal to the branch's id, `source_timestamp` or `source_lsn` is required.
			 *      */
			source_branch_id: string;
			/** @description A Log Sequence Number (LSN) on the source branch. The branch will be restored with data from this LSN.
			 *      */
			source_lsn?: string;
			/**
			 * Format: date-time
			 * @description A timestamp identifying a point in time on the source branch. The branch will be restored with data starting from this point in time.
			 *     The timestamp must be provided in ISO 8601 format; for example: `2024-02-26T12:00:00Z`.
			 *
			 */
			source_timestamp?: string;
			/** @description If not empty, the previous state of the branch will be saved to a branch with this name.
			 *     If the branch has children or the `source_branch_id` is equal to the branch id, this field is required. All existing child branches will be moved to the newly created branch under the name `preserve_under_name`.
			 *      */
			preserve_under_name?: string;
		};
		BranchResponse: {
			branch: components["schemas"]["Branch"];
		};
		BranchSchemaResponse: {
			sql?: string;
		};
		BranchesResponse: {
			branches: components["schemas"]["Branch"][];
		};
		ConnectionParameters: {
			/** @description Database name
			 *      */
			database: string;
			/** @description Password for the role
			 *      */
			password: string;
			/** @description Role name
			 *      */
			role: string;
			/** @description Hostname
			 *      */
			host: string;
			/** @description Pooler hostname
			 *      */
			pooler_host: string;
		};
		ConnectionDetails: {
			/** @description The connection URI is defined as specified here: [Connection URIs](https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNSTRING-URIS)
			 *     The connection URI can be used to connect to a Postgres database with psql or defined in a DATABASE_URL environment variable.
			 *      */
			connection_uri: string;
			connection_parameters: components["schemas"]["ConnectionParameters"];
		};
		ConnectionURIResponse: {
			/** @description The connection URI.
			 *      */
			uri: string;
		};
		/** @example {
		 *       "host": "ep-silent-smoke-806639.us-east-2.aws.neon.tech",
		 *       "id": "ep-silent-smoke-806639",
		 *       "project_id": "spring-example-302709",
		 *       "branch_id": "br-wispy-meadow-118737",
		 *       "autoscaling_limit_min_cu": 1,
		 *       "autoscaling_limit_max_cu": 1,
		 *       "region_id": "aws-us-east-2",
		 *       "type": "read_write",
		 *       "current_state": "init",
		 *       "pending_state": "active",
		 *       "settings": {
		 *         "pg_settings": {}
		 *       },
		 *       "pooler_enabled": false,
		 *       "pooler_mode": "transaction",
		 *       "disabled": false,
		 *       "passwordless_access": true,
		 *       "creation_source": "console",
		 *       "created_at": "2022-12-03T15:37:07Z",
		 *       "updated_at": "2022-12-03T15:37:07Z",
		 *       "proxy_host": "us-east-2.aws.neon.tech",
		 *       "suspend_timeout_seconds": 0
		 *     } */
		Endpoint: {
			/** @description The hostname of the compute endpoint. This is the hostname specified when connecting to a Neon database.
			 *      */
			host: string;
			/** @description The compute endpoint ID. Compute endpoint IDs have an `ep-` prefix. For example: `ep-little-smoke-851426`
			 *      */
			id: string;
			/** @description The ID of the project to which the compute endpoint belongs
			 *      */
			project_id: string;
			/** @description The ID of the branch that the compute endpoint is associated with
			 *      */
			branch_id: string;
			/** @description The minimum number of Compute Units
			 *      */
			autoscaling_limit_min_cu: components["schemas"]["ComputeUnit"];
			/** @description The maximum number of Compute Units
			 *      */
			autoscaling_limit_max_cu: components["schemas"]["ComputeUnit"];
			/** @description The region identifier
			 *      */
			region_id: string;
			type: components["schemas"]["EndpointType"];
			current_state: components["schemas"]["EndpointState"];
			pending_state?: components["schemas"]["EndpointState"];
			settings: components["schemas"]["EndpointSettingsData"];
			/** @description Whether connection pooling is enabled for the compute endpoint
			 *      */
			pooler_enabled: boolean;
			pooler_mode: components["schemas"]["EndpointPoolerMode"];
			/** @description Whether to restrict connections to the compute endpoint.
			 *     Enabling this option schedules a suspend compute operation.
			 *     A disabled compute endpoint cannot be enabled by a connection or
			 *     console action. However, the compute endpoint is periodically
			 *     enabled by check_availability operations.
			 *      */
			disabled: boolean;
			/** @description Whether to permit passwordless access to the compute endpoint
			 *      */
			passwordless_access: boolean;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the compute endpoint was last active
			 *
			 */
			last_active?: string;
			/** @description The compute endpoint creation source
			 *      */
			creation_source: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the compute endpoint was created
			 *
			 */
			created_at: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the compute endpoint was last updated
			 *
			 */
			updated_at: string;
			/** @description DEPRECATED. Use the "host" property instead.
			 *      */
			proxy_host: string;
			suspend_timeout_seconds: components["schemas"]["SuspendTimeoutSeconds"];
			provisioner: components["schemas"]["Provisioner"];
			/** @description Attached compute's release version number.
			 *      */
			compute_release_version?: string;
		};
		/**
		 * @description The state of the compute endpoint
		 *
		 * @enum {string}
		 */
		EndpointState: "init" | "active" | "idle";
		/**
		 * @description The compute endpoint type. Either `read_write` or `read_only`.
		 *
		 * @enum {string}
		 */
		EndpointType: "read_only" | "read_write";
		/**
		 * @description The connection pooler mode. Neon supports PgBouncer in `transaction` mode only.
		 *
		 * @enum {string}
		 */
		EndpointPoolerMode: "transaction";
		/**
		 * Format: int64
		 * @description Duration of inactivity in seconds after which the compute endpoint is
		 *     automatically suspended. The value `0` means use the global default.
		 *     The value `-1` means never suspend. The default value is `300` seconds (5 minutes).
		 *     The minimum value is `60` seconds (1 minute).
		 *     The maximum value is `604800` seconds (1 week). For more information, see
		 *     [Auto-suspend configuration](https://neon.tech/docs/manage/endpoints#auto-suspend-configuration).
		 *
		 */
		SuspendTimeoutSeconds: number;
		/** @description A list of IP addresses that are allowed to connect to the compute endpoint.
		 *     If the list is empty or not set, all IP addresses are allowed.
		 *     If protected_branches_only is true, the list will be applied only to protected branches.
		 *      */
		AllowedIps: {
			/** @description A list of IP addresses that are allowed to connect to the endpoint. */
			ips?: string[];
			/** @description If true, the list will be applied only to protected branches. */
			protected_branches_only?: boolean;
			/**
			 * @deprecated
			 * @description DEPRECATED: Use `protected_branches_only`.
			 *     If true, the list will be applied only to the default branch.
			 *
			 */
			primary_branch_only?: boolean;
		};
		EndpointCreateRequest: {
			endpoint: {
				/** @description The ID of the branch the compute endpoint will be associated with
				 *      */
				branch_id: string;
				/** @description The region where the compute endpoint will be created. Only the project's `region_id` is permitted.
				 *      */
				region_id?: string;
				type: components["schemas"]["EndpointType"];
				settings?: components["schemas"]["EndpointSettingsData"];
				/** @description The minimum number of Compute Units. The minimum value is `0.25`.
				 *     See [Compute size and Autoscaling configuration](https://neon.tech/docs/manage/endpoints#compute-size-and-autoscaling-configuration)
				 *     for more information.
				 *      */
				autoscaling_limit_min_cu?: components["schemas"]["ComputeUnit"];
				/** @description The maximum number of Compute Units.
				 *     See [Compute size and Autoscaling configuration](https://neon.tech/docs/manage/endpoints#compute-size-and-autoscaling-configuration)
				 *     for more information.
				 *      */
				autoscaling_limit_max_cu?: components["schemas"]["ComputeUnit"];
				provisioner?: components["schemas"]["Provisioner"];
				/**
				 * @deprecated
				 * @description Whether to enable connection pooling for the compute endpoint
				 *
				 */
				pooler_enabled?: boolean;
				pooler_mode?: components["schemas"]["EndpointPoolerMode"];
				/** @description Whether to restrict connections to the compute endpoint.
				 *     Enabling this option schedules a suspend compute operation.
				 *     A disabled compute endpoint cannot be enabled by a connection or
				 *     console action. However, the compute endpoint is periodically
				 *     enabled by check_availability operations.
				 *      */
				disabled?: boolean;
				/** @description NOT YET IMPLEMENTED. Whether to permit passwordless access to the compute endpoint.
				 *      */
				passwordless_access?: boolean;
				suspend_timeout_seconds?: components["schemas"]["SuspendTimeoutSeconds"];
			};
		};
		EndpointUpdateRequest: {
			endpoint: {
				/** @description The destination branch ID. The destination branch must not have an exsiting read-write endpoint.
				 *      */
				branch_id?: string;
				/** @description The minimum number of Compute Units. The minimum value is `0.25`.
				 *     See [Compute size and Autoscaling configuration](https://neon.tech/docs/manage/endpoints#compute-size-and-autoscaling-configuration)
				 *     for more information.
				 *      */
				autoscaling_limit_min_cu?: components["schemas"]["ComputeUnit"];
				/** @description The maximum number of Compute Units.
				 *     See [Compute size and Autoscaling configuration](https://neon.tech/docs/manage/endpoints#compute-size-and-autoscaling-configuration)
				 *     for more information.
				 *      */
				autoscaling_limit_max_cu?: components["schemas"]["ComputeUnit"];
				provisioner?: components["schemas"]["Provisioner"];
				settings?: components["schemas"]["EndpointSettingsData"];
				/**
				 * @deprecated
				 * @description Whether to enable connection pooling for the compute endpoint
				 *
				 */
				pooler_enabled?: boolean;
				pooler_mode?: components["schemas"]["EndpointPoolerMode"];
				/** @description Whether to restrict connections to the compute endpoint.
				 *     Enabling this option schedules a suspend compute operation.
				 *     A disabled compute endpoint cannot be enabled by a connection or
				 *     console action. However, the compute endpoint is periodically
				 *     enabled by check_availability operations.
				 *      */
				disabled?: boolean;
				/** @description NOT YET IMPLEMENTED. Whether to permit passwordless access to the compute endpoint.
				 *      */
				passwordless_access?: boolean;
				suspend_timeout_seconds?: components["schemas"]["SuspendTimeoutSeconds"];
			};
		};
		EndpointResponse: {
			endpoint: components["schemas"]["Endpoint"];
		};
		ConnectionURIsResponse: {
			connection_uris: components["schemas"]["ConnectionDetails"][];
		};
		ConnectionURIsOptionalResponse: {
			connection_uris?: components["schemas"]["ConnectionDetails"][];
		};
		EndpointsResponse: {
			endpoints: components["schemas"]["Endpoint"][];
		};
		EndpointPasswordlessSessionAuthRequest: {
			session_id: string;
		};
		/**
		 * Format: int64
		 * @description A Duration represents the elapsed time between two instants
		 *     as an int64 nanosecond count. The representation limits the
		 *     largest representable duration to approximately 290 years.
		 */
		Duration: number;
		StatementResult: {
			data?: components["schemas"]["StatementData"];
			error?: string;
			explain_data?: components["schemas"]["ExplainData"][];
			query: string;
		};
		StatementData: {
			fields?: string[];
			rows?: string[][];
			truncated: boolean;
		};
		ExplainData: {
			"QUERY PLAN": string;
		};
		/**
		 * @description The metric type for a given notification
		 *
		 * @enum {string}
		 */
		NotificationMetricType:
			| "database_size"
			| "connections"
			| "cpu"
			| "ram"
			| "compute_over_limit";
		/**
		 * @description The category type for a given notification
		 *
		 * @enum {string}
		 */
		NotificationCategoryType: "usage" | "performance";
		/**
		 * @description The type of the notification
		 *
		 * @enum {string}
		 */
		NotificationType: "info" | "warning";
		/**
		 * @description The action type for a given notification
		 *
		 * @enum {string}
		 */
		NotificationActionType: "upgrade_plan" | "upgrade_cu";
		/** @example {
		 *       "branch_id": "br-wispy-meadow-118737",
		 *       "name": "casey",
		 *       "protected": false,
		 *       "created_at": "2022-11-23T17:42:25Z",
		 *       "updated_at": "2022-11-23T17:42:25Z"
		 *     } */
		Role: {
			/** @description The ID of the branch to which the role belongs
			 *      */
			branch_id: string;
			/** @description The role name
			 *      */
			name: string;
			/** @description The role password
			 *      */
			password?: string;
			/** @description Whether or not the role is system-protected
			 *      */
			protected?: boolean;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the role was created
			 *
			 */
			created_at: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the role was last updated
			 *
			 */
			updated_at: string;
		};
		RoleCreateRequest: {
			role: {
				/** @description The role name. Cannot exceed 63 bytes in length.
				 *      */
				name: string;
			};
		};
		RoleResponse: {
			role: components["schemas"]["Role"];
		};
		RolesResponse: {
			roles: components["schemas"]["Role"][];
		};
		RolePasswordResponse: {
			/** @description The role password
			 *      */
			password: string;
		};
		PaymentSourceBankCard: {
			/** @description Last 4 digits of the card.
			 *      */
			last4: string;
			/**
			 * @description Brand of credit card.
			 *
			 * @enum {string}
			 */
			brand?:
				| "amex"
				| "diners"
				| "discover"
				| "jcb"
				| "mastercard"
				| "unionpay"
				| "unknown"
				| "visa";
			/**
			 * Format: int64
			 * @description Credit card expiration month
			 *
			 */
			exp_month?: number;
			/**
			 * Format: int64
			 * @description Credit card expiration year
			 *
			 */
			exp_year?: number;
		};
		PaymentSource: {
			/** @description Type of payment source. E.g. "card".
			 *      */
			type: string;
			card?: components["schemas"]["PaymentSourceBankCard"];
		};
		BillingAccount: {
			payment_source: components["schemas"]["PaymentSource"];
			subscription_type: components["schemas"]["BillingSubscriptionType"];
			payment_method: components["schemas"]["BillingPaymentMethod"];
			/**
			 * Format: date-time
			 * @description The last time the quota was reset. Defaults to the date-time the account is created.
			 *
			 */
			quota_reset_at_last: string;
			/** @description The full name of the individual or entity that owns the billing account. This name appears on invoices. */
			name: string;
			/** @description Billing email, to receive emails related to invoices and subscriptions.
			 *      */
			email: string;
			/** @description Billing address city.
			 *      */
			address_city: string;
			/** @description Billing address country code defined by ISO 3166-1 alpha-2.
			 *      */
			address_country: string;
			/** @description Billing address country name.
			 *      */
			address_country_name?: string;
			/** @description Billing address line 1.
			 *      */
			address_line1: string;
			/** @description Billing address line 2.
			 *      */
			address_line2: string;
			/** @description Billing address postal code.
			 *      */
			address_postal_code: string;
			/** @description Billing address state or region.
			 *      */
			address_state: string;
			/** @description Orb user portal url
			 *      */
			orb_portal_url?: string;
			/** @description The tax identification number for the billing account, displayed on invoices.
			 *      */
			tax_id?: string;
			/** @description The type of the tax identification number based on the country.
			 *      */
			tax_id_type?: string;
		};
		/**
		 * @description Type of subscription to Neon Cloud.
		 *     Notice that for users without billing account this will be "UNKNOWN"
		 *
		 * @enum {string}
		 */
		BillingSubscriptionType:
			| "UNKNOWN"
			| "direct_sales"
			| "aws_marketplace"
			| "free_v2"
			| "launch"
			| "scale";
		/**
		 * @description Indicates whether and how an account makes payments.
		 *
		 * @enum {string}
		 */
		BillingPaymentMethod:
			| "UNKNOWN"
			| "none"
			| "stripe"
			| "direct_payment"
			| "aws_mp"
			| "vercel_mp"
			| "staff"
			| "trial"
			| "sponsorship";
		/** @example {
		 *       "id": 834686,
		 *       "branch_id": "br-wispy-meadow-118737",
		 *       "name": "neondb",
		 *       "owner_name": "casey",
		 *       "created_at": "2022-11-30T18:25:15Z",
		 *       "updated_at": "2022-11-30T18:25:15Z"
		 *     } */
		Database: {
			/**
			 * Format: int64
			 * @description The database ID
			 *
			 */
			id: number;
			/** @description The ID of the branch to which the database belongs
			 *      */
			branch_id: string;
			/** @description The database name
			 *      */
			name: string;
			/** @description The name of role that owns the database
			 *      */
			owner_name: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the database was created
			 *
			 */
			created_at: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the database was last updated
			 *
			 */
			updated_at: string;
		};
		DatabaseCreateRequest: {
			database: {
				/** @description The name of the datbase
				 *      */
				name: string;
				/** @description The name of the role that owns the database
				 *      */
				owner_name: string;
			};
		};
		DatabaseUpdateRequest: {
			database: {
				/** @description The name of the database
				 *      */
				name?: string;
				/** @description The name of the role that owns the database
				 *      */
				owner_name?: string;
			};
		};
		DatabaseResponse: {
			database: components["schemas"]["Database"];
		};
		DatabasesResponse: {
			databases: components["schemas"]["Database"][];
		};
		Invitation: {
			/** Format: uuid */
			id: string;
			/**
			 * Format: email
			 * @description Email of the invited user
			 */
			email: string;
			/** @description Organization id as it is stored in Neon */
			org_id: string;
			/**
			 * Format: uuid
			 * @description UUID for the user_id who extended the invitation
			 */
			invited_by: string;
			/**
			 * Format: date-time
			 * @description Timestamp when the invitation was created
			 */
			invited_at: string;
			role: components["schemas"]["MemberRole"];
		};
		/**
		 * @description The role of the organization member
		 * @enum {string}
		 */
		MemberRole: "admin" | "member";
		Member: {
			/** Format: uuid */
			id: string;
			/** Format: uuid */
			user_id: string;
			org_id: string;
			role: components["schemas"]["MemberRole"];
			/** Format: date-time */
			joined_at?: string;
		};
		MemberUserInfo: {
			email: string;
			name: string;
			last_name: string;
		};
		MemberWithUser: {
			member: components["schemas"]["Member"];
			user: components["schemas"]["MemberUserInfo"];
		};
		Organization: {
			id: string;
			name: string;
			handle: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicting when the organization was created
			 *
			 */
			created_at: string;
			/**
			 * Format: date-time
			 * @description A timestamp indicating when the organization was updated
			 *
			 */
			updated_at: string;
		};
		OrganizationsResponse: {
			organizations: components["schemas"]["Organization"][];
		};
		OrganizationsUpdateRequest: {
			name: string;
		};
		OrganizationInvitationsResponse: {
			invitations: components["schemas"]["Invitation"][];
		};
		OrganizationInviteCreateRequest: {
			/** Format: email */
			email: string;
			role: components["schemas"]["MemberRole"];
		};
		OrganizationInvitesCreateRequest: {
			invitations: components["schemas"]["OrganizationInviteCreateRequest"][];
		};
		OrganizationInviteUpdateRequest: {
			/** Format: email */
			email?: string;
			role?: components["schemas"]["MemberRole"];
			resend?: boolean;
		};
		/** @description A list of details for guests of an organisation
		 *      */
		OrganizationGuestsResponse: components["schemas"]["OrganizationGuest"][];
		/** @description Details of an organisation guest, who is not directly a member of
		 *     an organisation but has been shared one of the projects it owns
		 *      */
		OrganizationGuest: {
			permission_id: string;
			user_email: string;
			project_id: string;
			project_name: string;
		};
		OrganizationMemberUpdateRequest: {
			role: components["schemas"]["MemberRole"];
		};
		OrganizationMembersResponse: {
			members: components["schemas"]["MemberWithUser"][];
		};
		InvitationCreateRequest: {
			/** @description Email to invite */
			email: string;
			role: components["schemas"]["MemberRole"];
		};
		OrganizationCreateRequest: {
			organization: {
				/** @description The organization name */
				name?: string;
				/** @description Emails with roles to invite to the organization */
				invitations?: components["schemas"]["InvitationCreateRequest"][];
			};
			subscription_type: components["schemas"]["BillingSubscriptionType"];
		};
		OrganizationLimits: {
			limits: {
				/** Format: int64 */
				active_time: number;
				max_projects: number;
				max_branches: number;
				/** Format: float64 */
				max_autoscaling_cu: number;
				/** Format: int64 */
				cpu_seconds: number;
				max_active_endpoints: number;
				max_read_only_endpoints: number;
				max_allowed_ips: number;
				max_monitoring_retention_hours: number;
				/** Format: int32 */
				max_history_retention_seconds: number;
				/** Format: int64 */
				max_compute_time_non_primary: number;
				min_autosuspend_seconds: number;
			};
			features: components["schemas"]["Features"];
		};
		CurrentUserAuthAccount: {
			email: string;
			image: string;
			login: string;
			name: string;
			provider: components["schemas"]["IdentityProviderId"];
		};
		LinkedAuthAccount: {
			provider: components["schemas"]["IdentityProviderId"];
			provider_display_name: string;
			username: string;
		};
		UpdateUserInfoRequest: {
			email?: string;
			/** Format: uuid */
			id: string;
			image?: string;
			first_name?: string;
			last_name?: string;
			password?: string;
			new_password?: string;
		};
		CurrentUserInfoResponse: {
			/**
			 * Format: int64
			 * @description Control plane observes active endpoints of a user this amount of wall-clock time.
			 *
			 */
			active_seconds_limit: number;
			billing_account: components["schemas"]["BillingAccount"];
			auth_accounts: components["schemas"]["CurrentUserAuthAccount"][];
			email: string;
			id: string;
			image: string;
			login: string;
			name: string;
			last_name: string;
			/** Format: int64 */
			projects_limit: number;
			/** Format: int64 */
			branches_limit: number;
			max_autoscaling_limit: components["schemas"]["ComputeUnit"];
			/** Format: int64 */
			compute_seconds_limit?: number;
			plan: string;
		};
		CurrentUserInfoAuthResponse: {
			password_stored: boolean;
			auth_accounts: components["schemas"]["CurrentUserAuthAccount"][];
			linked_accounts: components["schemas"]["LinkedAuthAccount"][];
		};
		VerifyUserPasswordRequest: {
			password: string;
		};
		/**
		 * @description Identity provider id from keycloak
		 * @enum {string}
		 */
		IdentityProviderId: "github" | "google" | "hasura" | "keycloak";
		/** @description A collection of settings for a compute endpoint */
		EndpointSettingsData: {
			pg_settings?: components["schemas"]["PgSettingsData"];
			pgbouncer_settings?: components["schemas"]["PgbouncerSettingsData"];
		};
		/** @description Per-project consumption quota. If the quota is exceeded, all active computes
		 *     are automatically suspended and it will not be possible to start them with
		 *     an API method call or incoming proxy connections. The only exception is
		 *     `logical_size_bytes`, which is applied on per-branch basis, i.e., only the
		 *     compute on the branch that exceeds the `logical_size` quota will be suspended.
		 *
		 *     Quotas are enforced based on per-project consumption metrics with the same names,
		 *     which are reset at the end of each billing period (the first day of the month).
		 *     Logical size is also an exception in this case, as it represents the total size
		 *     of data stored in a branch, so it is not reset.
		 *
		 *     A zero or empty quota value means 'unlimited'.
		 *      */
		ProjectQuota: {
			/**
			 * Format: int64
			 * @description The total amount of wall-clock time allowed to be spent by the project's compute endpoints.
			 *
			 */
			active_time_seconds?: number;
			/**
			 * Format: int64
			 * @description The total amount of CPU seconds allowed to be spent by the project's compute endpoints.
			 *
			 */
			compute_time_seconds?: number;
			/**
			 * Format: int64
			 * @description Total amount of data written to all of a project's branches.
			 *
			 */
			written_data_bytes?: number;
			/**
			 * Format: int64
			 * @description Total amount of data transferred from all of a project's branches using the proxy.
			 *
			 */
			data_transfer_bytes?: number;
			/**
			 * Format: int64
			 * @description Limit on the logical size of every project's branch.
			 *
			 */
			logical_size_bytes?: number;
		};
		/** @description A collection of settings for a Neon endpoint */
		DefaultEndpointSettings: {
			pg_settings?: components["schemas"]["PgSettingsData"];
			pgbouncer_settings?: components["schemas"]["PgbouncerSettingsData"];
			/** @description The minimum number of Compute Units. The minimum value is `0.25`.
			 *     See [Compute size and Autoscaling configuration](https://neon.tech/docs/manage/endpoints#compute-size-and-autoscaling-configuration)
			 *     for more information.
			 *      */
			autoscaling_limit_min_cu?: components["schemas"]["ComputeUnit"];
			/** @description The maximum number of Compute Units. See [Compute size and Autoscaling configuration](https://neon.tech/docs/manage/endpoints#compute-size-and-autoscaling-configuration)
			 *     for more information.
			 *      */
			autoscaling_limit_max_cu?: components["schemas"]["ComputeUnit"];
			suspend_timeout_seconds?: components["schemas"]["SuspendTimeoutSeconds"];
		} & {
			[key: string]: string;
		};
		/** @description A raw representation of Postgres settings */
		PgSettingsData: {
			[key: string]: string;
		};
		/** @description A raw representation of PgBouncer settings */
		PgbouncerSettingsData: {
			[key: string]: string;
		};
		/**
		 * @description The major Postgres version number. Currently supported versions are `14`, `15`, and `16`.
		 * @default 16
		 */
		PgVersion: number;
		/** @example {
		 *       "status": "ok"
		 *     } */
		HealthCheck: {
			/** @description Service status */
			status: string;
		};
		ProjectOwnerData: {
			email: string;
			branches_limit: number;
			subscription_type: components["schemas"]["BillingSubscriptionType"];
		};
		/** @enum {string} */
		UserDeletionConditionName:
			| "project_count"
			| "org_admin_membership_count"
			| "subscription_type";
		/** @enum {string} */
		OrgDeletionConditionName: "project_count";
		/** @description General Error */
		GeneralError: {
			code: components["schemas"]["ErrorCode"];
			/** @description Error message */
			message: string;
		};
		ErrorCode: string;
		BranchOperations: components["schemas"]["BranchResponse"] &
			components["schemas"]["OperationsResponse"];
		EndpointOperations: components["schemas"]["EndpointResponse"] &
			components["schemas"]["OperationsResponse"];
		DatabaseOperations: components["schemas"]["DatabaseResponse"] &
			components["schemas"]["OperationsResponse"];
		RoleOperations: components["schemas"]["RoleResponse"] &
			components["schemas"]["OperationsResponse"];
		/** @enum {string} */
		SupportTicketSeverity: "low" | "normal" | "high" | "critical";
		AnnotationData: {
			object: components["schemas"]["AnnotationObjectData"];
			value: components["schemas"]["AnnotationValueData"];
			/** Format: date-time */
			created_at?: string;
			/** Format: date-time */
			updated_at?: string;
		};
		/** @description Annotation properties. */
		AnnotationValueData: {
			[key: string]: string;
		};
		AnnotationObjectData: {
			type: string;
			id: string;
		};
		AnnotationCreateValueRequest: {
			annotation_value?: components["schemas"]["AnnotationValueData"];
		};
		AnnotationResponse: {
			annotation: components["schemas"]["AnnotationData"];
		};
		AnnotationsMapResponse: {
			annotations: {
				[key: string]: components["schemas"]["AnnotationData"];
			};
		};
	};
	responses: {
		/** @description Returned a list of operations
		 *      */
		ListOperations: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["OperationsResponse"] &
					components["schemas"]["PaginationResponse"];
			};
		};
		/** @description Created a project.
		 *     The project includes a connection URI with a database, password, and role.
		 *     At least one non-protected role is created with a password.
		 *     Wait until the operations are finished before attempting to connect to a project database.
		 *      */
		CreatedProject: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["ProjectResponse"] &
					components["schemas"]["ConnectionURIsResponse"] &
					components["schemas"]["RolesResponse"] &
					components["schemas"]["DatabasesResponse"] &
					components["schemas"]["OperationsResponse"] &
					components["schemas"]["BranchResponse"] &
					components["schemas"]["EndpointsResponse"];
			};
		};
		/** @description Created a branch. An endpoint is only created if it was specified in the request. */
		CreatedBranch: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["BranchResponse"] &
					components["schemas"]["EndpointsResponse"] &
					components["schemas"]["OperationsResponse"] &
					components["schemas"]["RolesResponse"] &
					components["schemas"]["DatabasesResponse"] &
					components["schemas"]["ConnectionURIsOptionalResponse"];
			};
		};
		/** @description General Error */
		GeneralError: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["GeneralError"];
			};
		};
		/** @description Service is running */
		HealthCheck: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["HealthCheck"];
			};
		};
	};
	parameters: never;
	requestBodies: never;
	headers: never;
	pathItems: never;
}
export type $defs = Record<string, never>;
export interface operations {
	listApiKeys: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned the API keys for the Neon account */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ApiKeysListResponseItem"][];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	createApiKey: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody: {
			content: {
				/** @example {
				 *       "key_name": "mykey"
				 *     } */
				"application/json": components["schemas"]["ApiKeyCreateRequest"];
			};
		};
		responses: {
			/** @description Created an API key */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ApiKeyCreateResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	revokeApiKey: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The API key ID */
				key_id: number;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Revoked the specified API key */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ApiKeyRevokeResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getProjectOperation: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The operation ID */
				operation_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned details for the specified operation */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["OperationResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	listProjects: {
		parameters: {
			query?: {
				/** @description Specify the cursor value from the previous response to retrieve the next batch of projects. */
				cursor?: string;
				/** @description Specify a value from 1 to 400 to limit number of projects in the response. */
				limit?: number;
				/** @description Search by project `name` or `id`. You can specify partial `name` or `id` values to filter results. */
				search?: string;
				/** @description Search for projects by `org_id`. */
				org_id?: string;
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned a list of projects for the Neon account */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ProjectsResponse"] &
						components["schemas"]["PaginationResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	createProject: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody: {
			content: {
				"application/json": components["schemas"]["ProjectCreateRequest"];
			};
		};
		responses: {
			201: components["responses"]["CreatedProject"];
			default: components["responses"]["GeneralError"];
		};
	};
	listSharedProjects: {
		parameters: {
			query?: {
				/** @description Specify the cursor value from the previous response to get the next batch of projects. */
				cursor?: string;
				/** @description Specify a value from 1 to 400 to limit number of projects in the response. */
				limit?: number;
				/** @description Search query by name or id. */
				search?: string;
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned a list of shared projects for the Neon account */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ProjectsResponse"] &
						components["schemas"]["PaginationResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getProject: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned information about the specified project */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ProjectResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	deleteProject: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Deleted the specified project */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ProjectResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	updateProject: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		requestBody: {
			content: {
				/** @example {
				 *       "project": {
				 *         "name": "myproject"
				 *       }
				 *     } */
				"application/json": components["schemas"]["ProjectUpdateRequest"];
			};
		};
		responses: {
			/** @description Updated the specified project */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ProjectResponse"] &
						components["schemas"]["OperationsResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	listProjectOperations: {
		parameters: {
			query?: {
				/** @description Specify the cursor value from the previous response to get the next batch of operations */
				cursor?: string;
				/** @description Specify a value from 1 to 1000 to limit number of operations in the response */
				limit?: number;
			};
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["ListOperations"];
			default: components["responses"]["GeneralError"];
		};
	};
	listProjectPermissions: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				project_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned project access details */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ProjectPermissions"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	grantPermissionToProject: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				project_id: string;
			};
			cookie?: never;
		};
		requestBody: {
			content: {
				"application/json": components["schemas"]["GrantPermissionToProjectRequest"];
			};
		};
		responses: {
			/** @description Granted project access */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ProjectPermission"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	revokePermissionFromProject: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				project_id: string;
				permission_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Revoked project access */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ProjectPermission"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getProjectJWKS: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description The JWKS definitions for the project */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ProjectJWKSResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getConnectionURI: {
		parameters: {
			query: {
				/** @description The branch ID. Defaults to your project's default `branch_id` if not specified. */
				branch_id?: string;
				/** @description The endpoint ID. Defaults to the read-write `endpoint_id` associated with the `branch_id` if not specified. */
				endpoint_id?: string;
				/** @description The database name */
				database_name: string;
				/** @description The role name */
				role_name: string;
				/** @description Adds the `-pooler` option to the connection URI when set to `true`, creating a pooled connection URI. */
				pooled?: boolean;
			};
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned the connection URI */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ConnectionURIResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	listProjectBranches: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned a list of branches for the specified project */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["BranchesResponse"] &
						components["schemas"]["AnnotationsMapResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	createProjectBranch: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		requestBody?: {
			content: {
				"application/json": components["schemas"]["BranchCreateRequest"] &
					components["schemas"]["AnnotationCreateValueRequest"];
			};
		};
		responses: {
			201: components["responses"]["CreatedBranch"];
			default: components["responses"]["GeneralError"];
		};
	};
	getProjectBranch: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned information about the specified branch */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["BranchResponse"] &
						components["schemas"]["AnnotationResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	deleteProjectBranch: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Deleted the specified branch */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["BranchOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	updateProjectBranch: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody: {
			content: {
				/** @example {
				 *       "branch": {
				 *         "name": "mybranch"
				 *       }
				 *     } */
				"application/json": components["schemas"]["BranchUpdateRequest"];
			};
		};
		responses: {
			/** @description Updated the specified branch */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["BranchOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	restoreProjectBranch: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody: {
			content: {
				"application/json": components["schemas"]["BranchRestoreRequest"];
			};
		};
		responses: {
			/** @description Updated the specified branch */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["BranchOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getProjectBranchSchema: {
		parameters: {
			query: {
				/** @description The role on whose behalf the schema is retrieved */
				role: string;
				/** @description Name of the database for which the schema is retrieved */
				db_name: string;
				/** @description The Log Sequence Number (LSN) for which the schema is retrieved
				 *      */
				lsn?: string;
				/** @description The point in time for which the schema is retrieved
				 *      */
				timestamp?: string;
			};
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Schema definition */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["BranchSchemaResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	setPrimaryProjectBranch: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Updated the specified branch */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["BranchOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	setDefaultProjectBranch: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Updated the specified branch */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["BranchOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	listProjectBranchEndpoints: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned a list of endpoints for the specified branch */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["EndpointsResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	listProjectBranchDatabases: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned a list of databases of the specified branch */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["DatabasesResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	createProjectBranchDatabase: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody: {
			content: {
				/** @example {
				 *       "database": {
				 *         "name": "mydb",
				 *         "owner_name": "casey"
				 *       }
				 *     } */
				"application/json": components["schemas"]["DatabaseCreateRequest"];
			};
		};
		responses: {
			/** @description Created a database in the specified branch */
			201: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["DatabaseOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getProjectBranchDatabase: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The database name */
				database_name: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned the database details */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["DatabaseResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	deleteProjectBranchDatabase: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The database name */
				database_name: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Deleted the specified database */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["DatabaseOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	updateProjectBranchDatabase: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The database name */
				database_name: string;
			};
			cookie?: never;
		};
		requestBody: {
			content: {
				/** @example {
				 *       "database": {
				 *         "name": "mydb",
				 *         "owner_name": "sally"
				 *       }
				 *     } */
				"application/json": components["schemas"]["DatabaseUpdateRequest"];
			};
		};
		responses: {
			/** @description Updated the database */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["DatabaseOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	listProjectBranchRoles: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned a list of roles from the specified branch. */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["RolesResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	createProjectBranchRole: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
			};
			cookie?: never;
		};
		requestBody: {
			content: {
				/** @example {
				 *       "role": {
				 *         "name": "sally"
				 *       }
				 *     } */
				"application/json": components["schemas"]["RoleCreateRequest"];
			};
		};
		responses: {
			/** @description Created a role in the specified branch */
			201: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["RoleOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getProjectBranchRole: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The role name */
				role_name: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned details for the specified role */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["RoleResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	deleteProjectBranchRole: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The role name */
				role_name: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Deleted the specified role from the branch */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["RoleOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getProjectBranchRolePassword: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The role name */
				role_name: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned password for the specified role */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["RolePasswordResponse"];
				};
			};
			/** @description Role not found */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			/** @description Storing passwords is disabled */
			412: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	resetProjectBranchRolePassword: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The branch ID */
				branch_id: string;
				/** @description The role nam */
				role_name: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Reset the passsword for the specified role */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["RoleOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	listProjectEndpoints: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned a list of endpoints for the specified project */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["EndpointsResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	createProjectEndpoint: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
			};
			cookie?: never;
		};
		requestBody: {
			content: {
				"application/json": components["schemas"]["EndpointCreateRequest"];
			};
		};
		responses: {
			/** @description Created a compute endpoint */
			201: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["EndpointOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getProjectEndpoint: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The endpoint ID */
				endpoint_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned information about the specified endpoint */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["EndpointResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	deleteProjectEndpoint: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The endpoint ID */
				endpoint_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Deleted the specified compute endpoint */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["EndpointOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	updateProjectEndpoint: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The endpoint ID */
				endpoint_id: string;
			};
			cookie?: never;
		};
		requestBody: {
			content: {
				/** @example {
				 *       "endpoint": {
				 *         "branch_id": "br-tiny-grass-283160"
				 *       }
				 *     } */
				"application/json": components["schemas"]["EndpointUpdateRequest"];
			};
		};
		responses: {
			/** @description Updated the specified compute endpoint */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["EndpointOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	addEndpointJWKS: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The endpoint ID */
				endpoint_id: string;
			};
			cookie?: never;
		};
		requestBody: {
			content: {
				"application/json": components["schemas"]["AddEndpointJWKSRequest"];
			};
		};
		responses: {
			/** @description The JWKS URL was added to the project authentication connections */
			201: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["JWKS"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	startProjectEndpoint: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The endpoint ID */
				endpoint_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Started the specified compute endpoint */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["EndpointOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	suspendProjectEndpoint: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The endpoint ID */
				endpoint_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Suspended the specified endpoint */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["EndpointOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	restartProjectEndpoint: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/** @description The Neon project ID */
				project_id: string;
				/** @description The endpoint ID */
				endpoint_id: string;
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Restarted endpoint */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["EndpointOperations"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getConsumptionHistoryPerAccount: {
		parameters: {
			query: {
				/** @description Specify the start `date-time` for the consumption period.
				 *     The `date-time` value is rounded according to the specified `granularity`.
				 *     For example, `2024-03-15T15:30:00Z` for `daily` granularity will be rounded to `2024-03-15T00:00:00Z`.
				 *     The specified `date-time` value must respect the specified granularity:
				 *     - For `hourly`, consumption metrics are limited to the last 168 hours.
				 *     - For `daily`, consumption metrics are limited to the last 60 days.
				 *     - For `monthly`, consumption metrics are limited to the past year.
				 *
				 *     The consumption history is available starting from `March 1, 2024, at 00:00:00 UTC`.
				 *      */
				from: string;
				/** @description Specify the end `date-time` for the consumption period.
				 *     The `date-time` value is rounded according to the specified granularity.
				 *     For example, `2024-03-15T15:30:00Z` for `daily` granularity will be rounded to `2024-03-15T00:00:00Z`.
				 *     The specified `date-time` value must respect the specified granularity:
				 *     - For `hourly`, consumption metrics are limited to the last 168 hours.
				 *     - For `daily`, consumption metrics are limited to the last 60 days.
				 *     - For `monthly`, consumption metrics are limited to the past year.
				 *      */
				to: string;
				/** @description Specify the granularity of consumption metrics.
				 *     Hourly, daily, and monthly metrics are available for the last 168 hours, 60 days,
				 *     and 1 year, respectively.
				 *      */
				granularity: components["schemas"]["ConsumptionHistoryGranularity"];
				/** @description Specify the organization for which the consumption metrics should be returned.
				 *     If this parameter is not provided, the endpoint will return the metrics for the
				 *     authenticated user's account.
				 *      */
				org_id?: string;
				/** @description Include metrics utilized in previous pricing models.
				 *     - **data_storage_bytes_hour**: The sum of the maximum observed storage values for each hour
				 *       for each project, which never decreases.
				 *      */
				include_v1_metrics?: boolean;
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned consumption metrics for the Neon account */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ConsumptionHistoryPerAccountResponse"];
				};
			};
			/** @description This endpoint is not available. It is only supported with Scale plan accounts. */
			403: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			/** @description Account is not a member of the organization specified by `org_id`. */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			/** @description The specified `date-time` range is outside the boundaries of the specified `granularity`.
			 *     Adjust your `from` and `to` values or select a different `granularity`.
			 *      */
			406: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			/** @description Too many requests */
			429: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getConsumptionHistoryPerProject: {
		parameters: {
			query: {
				/** @description Specify the cursor value from the previous response to get the next batch of projects. */
				cursor?: string;
				/** @description Specify a value from 1 to 100 to limit number of projects in the response. */
				limit?: number;
				/** @description Specify a list of project IDs to filter the response.
				 *     If omitted, the response will contain all projects.
				 *      */
				project_ids?: string[];
				/** @description Specify the start `date-time` for the consumption period.
				 *     The `date-time` value is rounded according to the specified `granularity`.
				 *     For example, `2024-03-15T15:30:00Z` for `daily` granularity will be rounded to `2024-03-15T00:00:00Z`.
				 *     The specified `date-time` value must respect the specified `granularity`:
				 *     - For `hourly`, consumption metrics are limited to the last 168 hours.
				 *     - For `daily`, consumption metrics are limited to the last 60 days.
				 *     - For `monthly`, consumption metrics are limited to the last year.
				 *
				 *     The consumption history is available starting from `March 1, 2024, at 00:00:00 UTC`.
				 *      */
				from: string;
				/** @description Specify the end `date-time` for the consumption period.
				 *     The `date-time` value is rounded according to the specified granularity.
				 *     For example, `2024-03-15T15:30:00Z` for `daily` granularity will be rounded to `2024-03-15T00:00:00Z`.
				 *     The specified `date-time` value must respect the specified `granularity`:
				 *     - For `hourly`, consumption metrics are limited to the last 168 hours.
				 *     - For `daily`, consumption metrics are limited to the last 60 days.
				 *     - For `monthly`, consumption metrics are limited to the last year.
				 *      */
				to: string;
				/** @description Specify the granularity of consumption metrics.
				 *     Hourly, daily, and monthly metrics are available for the last 168 hours, 60 days,
				 *     and 1 year, respectively.
				 *      */
				granularity: components["schemas"]["ConsumptionHistoryGranularity"];
				/** @description Specify the organization for which the project consumption metrics should be returned.
				 *     If this parameter is not provided, the endpoint will return the metrics for the
				 *     authenticated user's projects.
				 *      */
				org_id?: string;
				/** @description Include metrics utilized in previous pricing models.
				 *     - **data_storage_bytes_hour**: The sum of the maximum observed storage values for each hour,
				 *       which never decreases.
				 *      */
				include_v1_metrics?: boolean;
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned project consumption metrics for the Neon account */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ConsumptionHistoryPerProjectResponse"] &
						components["schemas"]["PaginationResponse"];
				};
			};
			/** @description This endpoint is not available. It is only supported with Scale plan accounts. */
			403: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			/** @description Account is not a member of the organization specified by `org_id`. */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			/** @description The specified `date-time` range is outside the boundaries of the specified `granularity`.
			 *     Adjust your `from` and `to` values or select a different `granularity`.
			 *      */
			406: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			/** @description Too many requests */
			429: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	listProjectsConsumption: {
		parameters: {
			query?: {
				/** @description Specify the cursor value from the previous response to get the next batch of projects */
				cursor?: string;
				/** @description Specify a value from 1 to 1000 to limit number of projects in the response */
				limit?: number;
				/** @description Specify the start date-time for the consumption period.
				 *     The time value must be provided in ISO 8601 format.
				 *     If `from` or `to` is not specified, we return only current consumption period.
				 *      */
				from?: string;
				/** @description Specify the end date-time period for the consumption period.
				 *     The time value must be provided in ISO 8601 format.
				 *     If `from` or `to` is not specified, only the current consumption period is returned.
				 *      */
				to?: string;
				/** @description Specify the organization for which the project consumption metrics should be returned.
				 *     If this parameter is not provided, the endpoint will return the metrics for the authenticated
				 *     user's projects.
				 *      */
				org_id?: string;
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned a list of project consumption metrics for the Neon account */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["ProjectsConsumptionResponse"] &
						components["schemas"]["PaginationResponse"];
				};
			};
			/** @description Account is not a member of the organization specified by `org_id`. */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["GeneralError"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getCurrentUserInfo: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned information about the current user
			 *      */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["CurrentUserInfoResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
	getCurrentUserOrganizations: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			/** @description Returned information about the current user organizations
			 *      */
			200: {
				headers: {
					[name: string]: unknown;
				};
				content: {
					"application/json": components["schemas"]["OrganizationsResponse"];
				};
			};
			default: components["responses"]["GeneralError"];
		};
	};
}
