﻿/* AS3
	Copyright 2008 nemoDreaming.com.
*/
package nemo.display {
	
	import flash.display.MovieClip;
	import flash.geom.ColorTransform;
	
	import nemo.core.xMath;
	
	include '../../extends/Array.as'

	/**
	 *	Class description.
	 *
	 *	@langversion ActionScript 3.0
	 *	@playerversion Flash 9.0
	 *	@author Philip Blyth
	 *	@since  16.03.2008
	 */
	public class ExtendedMovieClip extends MovieClip {
		
		//--------------------------------------
		// CLASS CONSTANTS
		//--------------------------------------
		
		//--------------------------------------
		//  CONSTRUCTOR
		//--------------------------------------
		
		/**
		 *	@Constructor
		 */
		public function ExtendedMovieClip( obj:Object = null ){
			super();
			feed(obj);
		}
		
		//--------------------------------------
		//  PRIVATE VARIABLES
		//--------------------------------------
		
		//--------------------------------------
		//  GETTER/SETTERS
		//--------------------------------------
		
		//--------------------------------------
		//  PUBLIC METHODS
		//--------------------------------------
		
		public function feed ( obj_:Object, to_:Object = null ) : Object {
		  var mouth = to_==null ? this : to_
			for ( var variable in obj_ ){
				mouth[variable] = obj_[variable];
			};
      return mouth;
		}
		
		public function gotoAndStop_random () {
			gotoAndStop( xMath.rrange_int(1, totalFrames) );
		};
		
		public function setColor ( _color:int, variation:Number = 0 ) : void {
			var _cT = new ColorTransform();
			_cT.color = _color;
			if (variation){
				var _variation = xMath.rrange(1-variation, 1+variation);
				_cT.redOffset *= _variation
				_cT.greenOffset *= _variation
				_cT.blueOffset *= _variation
			}
			transform.colorTransform = _cT;
		}

		//--------------------------------------
		//  EVENT HANDLERS
		//--------------------------------------
		
		//--------------------------------------
		//  PRIVATE & PROTECTED INSTANCE METHODS
		//--------------------------------------
		
	}
	
}
