﻿/* AS3
  Copyright 2008 nemoDreaming.com.
  */
package nemo.controls {

  import flash.display.MovieClip;
  import flash.display.Sprite;
  import flash.display.SimpleButton;
  
  import nemo.controls.SliderControl;
  
  import flash.events.ProgressEvent;

  /**
    *	@langversion ActionScript 3.0
    *	@playerversion Flash 9.0
    *	@author Philip Blyth
    *	@since  26.09.2008
    */
  public class PositionControl extends SliderControl {

    //--------------------------------------
    // CLASS CONSTANTS
    //--------------------------------------

    public static const MOVING : String = 'PositionControlMoving';
    public static const MOVED : String = 'PositionControlMoved';
    public static const DRAGGED : String = 'PositionControlDragged';
    
    public static const PROGRESS : String = 'PositionControlProgress';
    public static const COMPLETE : String = 'PositionControlComplete';
    
    //--------------------------------------
    // PUBLIC VARIABLES
    //--------------------------------------

    //--------------------------------------
    // PROTECTED VARIABLES
    //--------------------------------------
    
    protected var _progressbar_mc;

    //--------------------------------------
    //  CONSTRUCTOR
    //--------------------------------------

    /**
      *	@Constructor
      */
    public function PositionControl(){
      
      // defaults
      super(100, 0, "Position");
      
      // build
      _progressbar_mc = getChildByName("progressbar_mc");
      _progressbar_mc.width = 0;
    }
    
    //--------------------------------------
    // GETTER / SETTERS
    //--------------------------------------
    
    public function get allow() : Number { 
      return _allow; 
    }

    public function set allow( value:Number ) : void {
      if (value !== _allow){
        _allow = value;
      }
    }
    
    public function progress( percent:Number ) : void {
      // set allow
      allow = percent;
      // anim
      stage.invalidate();
      _progressbar_mc.visible = true;
      _progressbar_mc.width = _slider_width * _allow;
    }
    
    public function complete() : void {
      _progressbar_mc.visible = false;
      _progressbar_mc.width = 0;
    }

  }

}
