## Next.js & Lingui: Building a Multi-Lingual Website

[![GitHub release (latest SemVer including pre-releases)](https://img.shields.io/github/v/release/nekofar/nextjs-lingui-template?include_prereleases)](https://github.com/nekofar/nextjs-lingui-template/releases)
[![GitHub Workflow Status (branch)](https://img.shields.io/github/actions/workflow/status/nekofar/nextjs-lingui-template/build.yml)](https://github.com/nekofar/nextjs-lingui-template/actions/workflows/build.yml)
[![GitHub](https://img.shields.io/github/license/nekofar/nextjs-lingui-template)](https://github.com/nekofar/nextjs-lingui-template/blob/master/LICENSE)
[![X (formerly Twitter) Follow](https://img.shields.io/badge/follow-%40nekofar-ffffff?logo=x&style=flat)](https://x.com/nekofar)
[![Farcaster (Warpcast) Follow](https://img.shields.io/badge/follow-%40nekofar-855DCD.svg?logo=data:image/svg%2bxml;base64,PHN2ZyB3aWR0aD0iMzIzIiBoZWlnaHQ9IjI5NyIgdmlld0JveD0iMCAwIDMyMyAyOTciIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxwYXRoIGQ9Ik01NS41ODY3IDAuNzMzMzM3SDI2My40MTNWMjk2LjI2N0gyMzIuOTA3VjE2MC44OTNIMjMyLjYwN0MyMjkuMjM2IDEyMy40NzkgMTk3Ljc5MiA5NC4xNiAxNTkuNSA5NC4xNkMxMjEuMjA4IDk0LjE2IDg5Ljc2NDIgMTIzLjQ3OSA4Ni4zOTI2IDE2MC44OTNIODYuMDkzM1YyOTYuMjY3SDU1LjU4NjdWMC43MzMzMzdaIiBmaWxsPSJ3aGl0ZSIvPgo8cGF0aCBkPSJNMC4yOTMzMzUgNDIuNjhMMTIuNjg2NyA4NC42MjY3SDIzLjE3MzNWMjU0LjMyQzE3LjkwODIgMjU0LjMyIDEzLjY0IDI1OC41ODggMTMuNjQgMjYzLjg1M1YyNzUuMjkzSDExLjczMzNDNi40NjgyMiAyNzUuMjkzIDIuMiAyNzkuNTYyIDIuMiAyODQuODI3VjI5Ni4yNjdIMTA4Ljk3M1YyODQuODI3QzEwOC45NzMgMjc5LjU2MiAxMDQuNzA1IDI3NS4yOTMgOTkuNDQgMjc1LjI5M0g5Ny41MzMzVjI2My44NTNDOTcuNTMzMyAyNTguNTg4IDkzLjI2NTEgMjU0LjMyIDg4IDI1NC4zMkg3Ni41NlY0Mi42OEgwLjI5MzMzNVoiIGZpbGw9IndoaXRlIi8+CjxwYXRoIGQ9Ik0yMzQuODEzIDI1NC4zMkMyMjkuNTQ4IDI1NC4zMiAyMjUuMjggMjU4LjU4OCAyMjUuMjggMjYzLjg1M1YyNzUuMjkzSDIyMy4zNzNDMjE4LjEwOCAyNzUuMjkzIDIxMy44NCAyNzkuNTYyIDIxMy44NCAyODQuODI3VjI5Ni4yNjdIMzIwLjYxM1YyODQuODI3QzMyMC42MTMgMjc5LjU2MiAzMTYuMzQ1IDI3NS4yOTMgMzExLjA4IDI3NS4yOTNIMzA5LjE3M1YyNjMuODUzQzMwOS4xNzMgMjU4LjU4OCAzMDQuOTA1IDI1NC4zMiAyOTkuNjQgMjU0LjMyVjg0LjYyNjdIMzEwLjEyN0wzMjIuNTIgNDIuNjhIMjQ2LjI1M1YyNTQuMzJIMjM0LjgxM1oiIGZpbGw9IndoaXRlIi8+Cjwvc3ZnPgo=&style=flat)](https://warpcast.com/nekofar)
[![Donate](https://img.shields.io/badge/donate-nekofar.crypto-a2b9bc?logo=ko-fi&logoColor=white)](https://ud.me/nekofar.crypto)

### Overview

Welcome to the Next.js and Lingui static site generation (SSG) template project! This repository demonstrates the
state-of-the-art integration of Next.js and Lingui for creating static web apps with multi-lingual support.

Next.js, a powerful React framework, is designed to build server-rendered React applications and SSG sites. In this
context, we're utilizing Next.js's Static Site Generation capabilities to pre-render pages at build time.

Combined with Lingui, an i18n (internationalization) library for JavaScript, we've endeavored to produce a multilingual
static website that effectively caters to a global audience.

Our aim with this template project is to illustrate the procedure of building an international static web app that is
performant, SEO-advantaged, and maintains simplified translation management, courtesy of the capabilities brought about
by the coupling of Next.js's SSG and Lingui.

### Key Features

- **Static Site Generation with Next.js**: Experience the unique advantages of utilizing Next.js in our static web
  application. This includes benefits such as improved performance and SEO, client-side routing, and a more streamlined
  development process.
- **Translation Management with Lingui**: Discover how Lingui simplifies handling translations in our static web app,
  from message extraction to language pluralization and localized formatting.
- **Real-time Language Switching**: Experience an interactive feature of our static web app that enables dynamic
  language switching. This allows users to effortlessly switch between different languages without navigating away from
  their current page.

### Getting Started

Click on `Use this template` to create the repo for your app.

Then, to use this project template, follow these steps:

1. Clone this repository: `git clone https://github.com/your-username/your-repo.git`
2. Navigate to the project directory: `cd your-repo`
3. Install project dependencies: `pnpm install`
4. Start the development server: `pnpm run dev`
5. Open your browser and visit http://localhost:3000 to see the application in action.

### Contributing

We welcome contributions to this project! To contribute, follow these steps:

1. Fork the repository
2. Create a new branch: `git checkout -b your-feature`
3. Make your changes and commit them: `git commit -m "Add your feature"`
4. Push to the branch: `git push origin your-feature`
5. Open a pull request to the main branch of this repository

### License

This project is licensed under the Apache License - see the [LICENSE](LICENSE) file for details.
