/* -----------------------------------------------------------------------------

  CalenStyle - Responsive Event Calendar
  Version 2.0.8
  Copyright (c)2017 Lajpat Shah
  Contributors : https://github.com/nehakadam/CalenStyle/contributors
  Repository : https://github.com/nehakadam/CalenStyle
  Homepage : https://nehakadam.github.io/CalenStyle

 ----------------------------------------------------------------------------- */

/*

	language: Austrian German ("de-at")
	file: CalenStyle-i18n-de-at

*/

(function ($) {
    $.CalenStyle.i18n["de-at"] = $.extend($.CalenStyle.i18n["de-at"], {

        veryShortDayNames: 'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),
		shortDayNames: 'So._Mo._Di._Mi._Do._Fr._Sa.'.split('_'),
		fullDayNames: 'Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag'.split('_'),
		shortMonthNames: 'Jän._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.'.split('_'),
		fullMonthNames: 'Jänner_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),
		numbers: '0_1_2_3_4_5_6_7_8_9'.split('_'),
		eventTooltipContent: "Default",
		formatDates: {},
		miscStrings: {
			today: "Heute",
			week: "Woche",
			allDay: "ganztägige",
			ends: "Ende"
		},
		duration: "Default",
		durationStrings: {
			y: ["Jahre ", "Jahren "],
			M: ["Monate ", "Monaten "],
			w: ["w ", "w "],
			d: ["Tage ", "Tagen "],
			h: ["Stunde ", "Stunde "],
			m: ["Minute ", "Minute "],
			s: ["s ", "s "]
		},
		viewDisplayNames: {
			DetailedMonthView: "Monat",
			MonthView: "Monat",
			WeekView: "Woche",
			DayView: "Tag",
			AgendaView: "Tagesordnung"
		}
	});
})(jQuery);



(function ($) {
    $.CalenStyle.i18n["de"] = $.extend($.CalenStyle.i18n["de"], {
        veryShortDayNames: 'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),
		shortDayNames: 'So._Mo._Di._Mi._Do._Fr._Sa.'.split('_'),
		fullDayNames: 'Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag'.split('_'),
		shortMonthNames: 'Jan._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.'.split('_'),
		fullMonthNames: 'Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),
		numbers: '0_1_2_3_4_5_6_7_8_9'.split('_'),
		eventTooltipContent: "Default",
		formatDates: {},
		miscStrings: {
			today: "Heute",
			week: "Woche",
			allDay: "ganztägige",
			ends: "Ende"
		},
		duration: "Default",
		durationStrings: {
			y: ["Jahre ", "Jahren "],
			M: ["Monate ", "Monaten "],
			w: ["w ", "w "],
			d: ["Tage ", "Tagen "],
			h: ["Stunde ", "Stunde "],
			m: ["Minute ", "Minute "],
			s: ["s ", "s "]
		},
		viewDisplayNames: {
			DetailedMonthView: "Monat",
			MonthView: "Monat",
			WeekView: "Woche",
			DayView: "Tag",
			AgendaView: "Tagesordnung"
		}
    });
})(jQuery);



/*

	language: English
	file: CalenStyle-i18n-en

*/

(function ($) {
    $.CalenStyle.i18n["en"] = $.extend($.CalenStyle.i18n["en"], {
        veryShortDayNames: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
		shortDayNames: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
		fullDayNames: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
		shortMonthNames: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
		fullMonthNames: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
		numbers: "0_1_2_3_4_5_6_7_8_9".split("_"),
		eventTooltipContent: "Default",
		formatDates: {},
		miscStrings: {
			today: "Today",
			week: "Week",
			allDay: "All Day",
			ends: "Ends"
		},
		duration: "Default",
		durationStrings: {
			y: ["year ", "years "],
			M: ["month ", "months "],
			w: ["w ", "w "],
			d: ["d ", "d "],
			h: ["h ", "h "],
			m: ["m ", "m "],
			s: ["s ", "s "]
		},
		viewDisplayNames: {
			DetailedMonthView: "Month",
			MonthView: "Month",
			WeekView: "Week",
			DayView: "Day",
			AgendaView: "Agenda"
		}
    });
})(jQuery);



/*

	language: French
	file: CalenStyle-i18n-fr

*/

(function ($) {
    $.CalenStyle.i18n["fr"] = $.extend($.CalenStyle.i18n["fr"], {
        veryShortDayNames: 'Di_Lu_Ma_Me_Je_Ve_Sa'.split('_'),
		shortDayNames: 'dim._lun._mar._mer._jeu._ven._sam.'.split('_'),
		fullDayNames: 'dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi'.split('_'),
		shortMonthNames: 'janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.'.split('_'),
		fullMonthNames: 'janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre'.split('_'),
		numbers: "0_1_2_3_4_5_6_7_8_9".split("_"),
		eventTooltipContent: "Default",
		formatDates: {},
		miscStrings: {
			today: "Aujourd\'hui",
			week: "semaine",
			allDay: "toute la journée",
			ends: "finir"
		},
		duration: "Default",
		durationStrings: {
			y: ["an ", "ans "],
			M: ["mois ", "mois "],
			w: ["semaine ", "semaine "],
			d: ["jour ", "jours "],
			h: ["heure ", "heures "],
			m: ["minute ", "minutes "],
			s: ["s ", "s "]
		},
		viewDisplayNames: {
			DetailedMonthView: "mois",
			MonthView: "mois",
			WeekView: "semaine",
			DayView: "jour",
			AgendaView: "ordre du jour"
		}
    });
})(jQuery);





/*

	language: Russian
	file: CalenStyle-i18n-ru

*/

(function ($) {
    $.CalenStyle.i18n["ru"] = $.extend($.CalenStyle.i18n["ru"], {
        veryShortDayNames: 'вс_пн_вт_ср_чт_пт_сб'.split('_'),
		shortDayNames: 'вс_пн_вт_ср_чт_пт_сб'.split('_'),
		fullDayNames: 'воскресенье_понедельник_вторник_среда_четверг_пятница_суббота'.split('_'),
		shortMonthNames: 'янв_фев_март_апр_май_июнь_июль_авг_сен_окт_ноя_дек'.split('_'),
		fullMonthNames: 'январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь'.split('_'),
		numbers: "0_1_2_3_4_5_6_7_8_9".split("_"),
		eventTooltipContent: "Default",
		formatDates: {},
		miscStrings: {
			today: "Сегодня",
			week: "Неделя",
			allDay: "весь день",
			ends: "кончать"
		},
		duration: "Default",
		durationStrings: {
			y: ["Год ", "Год "],
			M: ["Месяц ", "Месяц "],
			w: ["w ", "w "],
			d: ["d ", "d "],
			h: ["h ", "h "],
			m: ["m ", "m "],
			s: ["s ", "s "]
		},
		viewDisplayNames: {
			DetailedMonthView: "Месяц",
			MonthView: "Месяц",
			WeekView: "Неделя",
			DayView: "День",
			AgendaView: "повестка дня"
		}
    });
})(jQuery);





/*

	language: Chinese
	file: CalenStyle-i18n-zh-cn

*/

(function ($) {
    $.CalenStyle.i18n["zh-cn"] = $.extend($.CalenStyle.i18n["zh-cn"],
    {
        veryShortDayNames: '日_一_二_三_四_五_六'.split('_'),
		shortDayNames: '周日_周一_周二_周三_周四_周五_周六'.split('_'),
		fullDayNames: '星期日_星期一_星期二_星期三_星期四_星期五_星期六'.split('_'),
		shortMonthNames: '1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月'.split('_'),
		fullMonthNames: '一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月'.split('_'),
		numbers: "0_1_2_3_4_5_6_7_8_9".split("_"),
		eventTooltipContent: "Default",
		formatDates: {
						"hh:mm": function(iDate)
						{
							var iHm = iDate.H * 100 + iDate.m,
							sFormat = "";

				            if (iHm < 600)
				                sFormat = '凌晨';
				            else if (iHm < 900)
				                sFormat = '早上';
				            else if (iHm < 1130)
				                sFormat = '上午';
				            else if (iHm < 1230)
				                sFormat = '中午';
				            else if (iHm < 1800)
				                sFormat = '下午';
				            else
				                sFormat = '晚上';

				        	sFormat += iDate.h + "点" + this.getDateInFormat({"iDate": iDate}, "mm", false, true);

				        	return sFormat;
						},

						"HH:mm": function(iDate)
						{
							var iHm = iDate.H * 100 + iDate.m,
							sFormat = "";

				            if (iHm < 600)
				                sFormat = '凌晨';
				            else if (iHm < 900)
				                sFormat = '早上';
				            else if (iHm < 1130)
				                sFormat = '上午';
				            else if (iHm < 1230)
				                sFormat = '中午';
				            else if (iHm < 1800)
				                sFormat = '下午';
				            else
				                sFormat = '晚上';

				        	sFormat += iDate.h + "点" + this.getDateInFormat({"iDate": iDate}, "mm", false, true);

				        	return sFormat;
						}
		},
		miscStrings: {
			today: "今天",
			week: "星期",
			allDay: "整天",
			ends: "结束"
		},
		duration: "Default",
		durationStrings: {
			y: ["岁 ", "岁 "],
			M: ["月 ", "月 "],
			w: ["周 ", "周 "],
			d: ["日 ", "日 "],
			h: ["钟头 ", "钟头 "],
			m: ["分钟 ", "分钟 "],
			s: ["秒 ", "秒 "]
		},
		viewDisplayNames: {
			DetailedMonthView: "月份",
			MonthView: "月份",
			WeekView: "星期",
			DayView: "白天",
			AgendaView: "应办事项"
		}
    });
})(jQuery);

