## CalenStyle - Event Calendar 


## What is CalenStyle?

CalenStyle is a **Responsive** jQuery **Drag & Drop** Event Calendar Library for Web, Mobile Sites, Android, iOS & Windows Phone.
 
## Where can I use CalenStyle?
You can use CalenStyle in your 
- Web applications 
- Small viewing section on a webpage
- Mobile websites
- Native mobile applications using webview
- Hybrid mobile applications created using Phonegap, Titanium etc.  

## Design Themes 
CalenStyle includes many design themes for representing events in colorful & informative manner. Themes were designed keeping in mind a need to show event calendar on small screens like mobile devices & in a small viewing section on a web page. But they work equally well on large screens like desktop browsers. Few theme examples are shown below:<br/>
### Full Calendar (Drag & Drop)
![](https://raw.github.com/nehakadam/CalenStyle/gh-pages/content/images/full_calendar.jpg)
### Timeline View (Agenda)
![](https://raw.github.com/nehakadam/CalenStyle/gh-pages/content/images/timeline.png)
### Planner View (Agenda)
![](https://raw.github.com/nehakadam/CalenStyle/gh-pages/content/images/planner.png)
### Dot & Line View (Event Indicator)
![](https://raw.github.com/nehakadam/CalenStyle/gh-pages/content/images/event_listing-dots.png)

## Browser Support
- Chrome, Firefox, Safari, Opera, IE 9+
- Android 2.3+, iOS 6+, Windows Phone 8


##Installations

- npm

  `npm install calenstyle`

- bower

  `bower install calenstyle`
  
- composer

  `composer require nehakadam/calenstyle`

##CDN
[CalenStyle is hosted on jsDelivr](http://www.jsdelivr.com/projects/jquery.calenstyle).

Files - Latest

```
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/jquery.calenstyle/latest/calenstyle.min.css" />
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery.calenstyle/latest/calenstyle.min.js"></script>
<!-- For i18n -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery.calenstyle/latest/i18n/calenstyle-i18n.js"></script>
```

Files - Particular Version

```
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/jquery.calenstyle/<version>/calenstyle.min.css" />
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery.calenstyle/<version>/calenstyle.min.js"></script>
<!-- For i18n -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery.calenstyle/<version>/i18n/calenstyle-i18n.js"></script>
```

## Authors
[Neha Kadam](https://github.com/nehakadam): Developer<br/> 
[Lajpat Shah](https://github.com/lajpatshah): Concept & Design Contributor

## Thank You
- [All Contributors](https://github.com/nehakadam/DateTimePicker/contributors)

<br/> <br/> 

Copyright 2017 [Lajpat Shah](https://github.com/lajpatshah)

##License

Licensed under the MIT License
