<?xml version='1.0' encoding='utf-8' standalone='yes'?>
<instrumentationManifest xmlns="http://schemas.microsoft.com/win/2004/08/events" xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://schemas.microsoft.com/win/2004/08/events eventman.xsd">
	<instrumentation>
		<events>
			<provider guid="{37dcd579-e844-4c80-9c8b-a10850b6fac6}" messageFileName="%WinDir%\System32\drivers\BthPS3.sys" name="Nefarius BthPS3 Profile Driver" resourceFileName="%WinDir%\System32\drivers\BthPS3.sys" symbol="DriverControlGuid">
				<channels>
					<importChannel chid="SYSTEM" name="System"/>
				</channels>
				<templates>
					<template tid="tid_load_template">
						<data inType="win:Pointer" name="DriverObjPtr" outType="win:HexInt64"/>
						<data inType="win:UInt32" name="Status" outType="win:NTSTATUS"/>
					</template>
					<template tid="tid_unload_template">
						<data inType="win:Pointer" name="DriverObjPtr" outType="win:HexInt64"/>
					</template>
					<template tid="tid_hci_version_template">
						<data inType="win:UInt32" name="Version" outType="xs:unsignedInt"/>
					</template>
					<template tid="tid_remote_device_name">
						<data inType="win:UInt64" name="Address" outType="win:HexInt64"/>
						<data inType="win:AnsiString" name="Name" outType="win:Utf8"/>
					</template>
					<template tid="tid_remote_device_identified">
						<data inType="win:UInt64" name="Address" outType="win:HexInt64"/>
						<data inType="win:UnicodeString" name="Model" outType="xs:string"/>
					</template>
					<template tid="tid_remote_device_not_identified">
						<data inType="win:UInt64" name="Address" outType="win:HexInt64"/>
					</template>
					<template tid="tid_filter_auto_enable">
						<data inType="win:UInt32" name="DelayInSeconds" outType="xs:unsignedInt"/>
					</template>
					<template tid="tid_child_device_created">
						<data inType="win:UInt64" name="Address" outType="win:HexInt64"/>
						<data inType="win:AnsiString" name="Name" outType="win:Utf8"/>
						<data inType="win:UInt32" name="SlotIndex" outType="xs:unsignedInt"/>
						<data inType="win:UInt32" name="Status" outType="win:NTSTATUS"/>
					</template>
					<template tid="tid_child_device_destroyed">
						<data inType="win:UInt32" name="SlotIndex" outType="xs:unsignedInt"/>
						<data inType="win:UnicodeString" name="HardwareId" outType="xs:string"/>
						<data inType="win:UInt32" name="Status" outType="win:NTSTATUS"/>
					</template>
					<template tid="tid_filter_enabled">
						<data inType="win:UInt32" name="Status" outType="win:NTSTATUS"/>
					</template>
					<template tid="tid_l2cap_remote_connect">
						<data inType="win:UInt32" name="PSM" outType="xs:unsignedInt"/>
						<data inType="win:UInt32" name="Status" outType="win:NTSTATUS"/>
					</template>
					<template tid="tid_power_policy">
						<data inType="win:UInt32" name="Status" outType="win:NTSTATUS"/>
					</template>
					<template tid="tid_remote_device_online">
						<data inType="win:UInt64" name="Address" outType="win:HexInt64"/>
					</template>
					<template tid="tid_failed_with_ntstatus">
						<data inType="win:AnsiString" name="ScopeName" outType="win:Utf8"/>
						<data inType="win:UnicodeString" name="FunctionName" outType="xs:string"/>
						<data inType="win:UInt32" name="Status" outType="win:NTSTATUS"/>
					</template>
					<template tid="tid_remote_device_disconnected">
						<data inType="win:UInt64" name="Address" outType="win:HexInt64"/>
						<data inType="win:UInt32" name="Status" outType="win:NTSTATUS"/>
					</template>
				</templates>
				<events>
					<event value="1" channel="SYSTEM" level="win:Informational" message="$(string.StartEvent.EventMessage)" opcode="win:Start" symbol="StartEvent" template="tid_load_template"/>
					<event value="2" channel="SYSTEM" level="win:Informational" message="$(string.UnloadEvent.EventMessage)" opcode="win:Stop" symbol="UnloadEvent" template="tid_unload_template"/>
					<event value="3" channel="SYSTEM" level="win:Informational" message="$(string.HciVersion.EventMessage)" opcode="win:Info" symbol="HciVersion" template="tid_hci_version_template"/>
					<event value="4" channel="SYSTEM" level="win:Error" message="$(string.HciVersionTooLow.EventMessage)" opcode="win:Info" symbol="HciVersionTooLow" template="tid_hci_version_template"/>
					<event value="5" channel="SYSTEM" level="win:Informational" message="$(string.RemoteDeviceName.EventMessage)" opcode="win:Info" symbol="RemoteDeviceName" template="tid_remote_device_name"/>
					<event value="6" channel="SYSTEM" level="win:Informational" message="$(string.RemoteDeviceIdentified.EventMessage)" opcode="win:Info" symbol="RemoteDeviceIdentified" template="tid_remote_device_identified"/>
					<event value="7" channel="SYSTEM" level="win:Error" message="$(string.RemoteDeviceNotIdentified.EventMessage)" opcode="win:Info" symbol="RemoteDeviceNotIdentified" template="tid_remote_device_not_identified"/>
					<event value="8" channel="SYSTEM" level="win:Informational" message="$(string.AutoDisableFilter.EventMessage)" opcode="win:Info" symbol="AutoDisableFilter"/>
					<event value="9" channel="SYSTEM" level="win:Informational" message="$(string.AutoEnableFilter.EventMessage)" opcode="win:Info" symbol="AutoEnableFilter" template="tid_filter_auto_enable"/>
					<event value="10" channel="SYSTEM" level="win:Informational" message="$(string.ChildDeviceCreationSuccessful.EventMessage)" opcode="win:Info" symbol="ChildDeviceCreationSuccessful" template="tid_child_device_created"/>
					<event value="11" channel="SYSTEM" level="win:Error" message="$(string.ChildDeviceCreationFailed.EventMessage)" opcode="win:Info" symbol="ChildDeviceCreationFailed" template="tid_child_device_created"/>
					<event value="12" channel="SYSTEM" level="win:Informational" message="$(string.ChildDeviceDestructionSuccessful.EventMessage)" opcode="win:Info" symbol="ChildDeviceDestructionSuccessful" template="tid_child_device_destroyed"/>
					<event value="13" channel="SYSTEM" level="win:Error" message="$(string.ChildDeviceDestructionFailed.EventMessage)" opcode="win:Info" symbol="ChildDeviceDestructionFailed" template="tid_child_device_destroyed"/>
					<event value="14" channel="SYSTEM" level="win:Informational" message="$(string.FilterAutoEnabledSuccessfully.EventMessage)" opcode="win:Info" symbol="FilterAutoEnabledSuccessfully"/>
					<event value="15" channel="SYSTEM" level="win:Error" message="$(string.FilterAutoEnabledFailed.EventMessage)" opcode="win:Info" symbol="FilterAutoEnabledFailed" template="tid_filter_enabled"/>
					<event value="16" channel="SYSTEM" level="win:Error" message="$(string.L2CAPRemoteConnectFailed.EventMessage)" opcode="win:Info" symbol="L2CAPRemoteConnectFailed" template="tid_l2cap_remote_connect"/>
					<event value="17" channel="SYSTEM" level="win:Warning" message="$(string.PowerPolicyIdleSettingsFailed.EventMessage)" opcode="win:Info" symbol="PowerPolicyIdleSettingsFailed"/>
					<event value="18" channel="SYSTEM" level="win:Error" message="$(string.WdfDeviceAssignS0IdleSettingsFailed.EventMessage)" opcode="win:Info" symbol="WdfDeviceAssignS0IdleSettingsFailed" template="tid_power_policy"/>
					<event value="19" channel="SYSTEM" level="win:Informational" message="$(string.HidControlChannelConnected.EventMessage)" opcode="win:Info" symbol="HidControlChannelConnected"/>
					<event value="20" channel="SYSTEM" level="win:Informational" message="$(string.HidInterruptChannelConnected.EventMessage)" opcode="win:Info" symbol="HidInterruptChannelConnected"/>
					<event value="21" channel="SYSTEM" level="win:Informational" message="$(string.RemoteDeviceOnline.EventMessage)" opcode="win:Info" symbol="RemoteDeviceOnline" template="tid_remote_device_online"/>
					<event value="22" channel="SYSTEM" level="win:Error" message="$(string.FailedWithNTStatus.EventMessage)" opcode="win:Info" symbol="FailedWithNTStatus" template="tid_failed_with_ntstatus"/>
					<event value="23" channel="SYSTEM" level="win:Informational" message="$(string.RemoteDisconnectCompleted.EventMessage)" opcode="win:Info" symbol="RemoteDisconnectCompleted" template="tid_remote_device_disconnected"/>
				</events>
			</provider>
		</events>
	</instrumentation>
	<localization xmlns="http://schemas.microsoft.com/win/2004/08/events">
		<resources culture="en-US">
			<stringTable>
				<string id="StartEvent.EventMessage" value="Driver loaded (obj: %1, status: %2)"/>
				<string id="UnloadEvent.EventMessage" value="Driver unloaded (obj: %1)"/>
				<string id="HciVersion.EventMessage" value="Host radio HCI major version: %1"/>
				<string id="HciVersionTooLow.EventMessage" value="Host radio HCI major version %1 too low, can't continue driver startup. You need a newer Bluetooth Host Radio to use this driver."/>
				<string id="RemoteDeviceName.EventMessage" value="Device %1 reported name: %2"/>
				<string id="RemoteDeviceIdentified.EventMessage" value="Device %1 identified as %2 compatible"/>
				<string id="RemoteDeviceNotIdentified.EventMessage" value="Device %1 not identified or denied, dropping connection. Consult the online documentation for potential solutions."/>
				<string id="AutoDisableFilter.EventMessage" value="Auto-disabling filter driver option set, filter disabled"/>
				<string id="AutoEnableFilter.EventMessage" value="Auto-enabling filter driver option set, re-enabling filter driver in %1 seconds"/>
				<string id="ChildDeviceCreationSuccessful.EventMessage" value="Successfully created PDO for %1 (%2) and assigned slot index %3"/>
				<string id="ChildDeviceCreationFailed.EventMessage" value="Failed to create PDO for %1 (%2), slot index %3, status: %4"/>
				<string id="ChildDeviceDestructionSuccessful.EventMessage" value="Successfully destroyed PDO in slot %1 (%2)"/>
				<string id="ChildDeviceDestructionFailed.EventMessage" value="Failed to destroy PDO in slot %1 (%2), status: %3"/>
				<string id="FilterAutoEnabledSuccessfully.EventMessage" value="Filter enabled successfully"/>
				<string id="FilterAutoEnabledFailed.EventMessage" value="Failed to enable filter, status: %1"/>
				<string id="L2CAPRemoteConnectFailed.EventMessage" value="Remote connect for L2CAP channel with PSM %1, status: %2"/>
				<string id="PowerPolicyIdleSettingsFailed.EventMessage" value="Could not assign idle settings: the calling driver is not the device's power policy owner and device not in RAW mode. If DsHidMini is installed and operative this warning can be ignored."/>
				<string id="WdfDeviceAssignS0IdleSettingsFailed.EventMessage" value="WdfDeviceAssignS0IdleSettings failed with status %1"/>
				<string id="HidControlChannelConnected.EventMessage" value="HID Control Channel connection established"/>
				<string id="HidInterruptChannelConnected.EventMessage" value="HID Interrupt Channel connection established"/>
				<string id="RemoteDeviceOnline.EventMessage" value="Device %1 has both L2CAP channels connected and is ready to operate"/>
				<string id="FailedWithNTStatus.EventMessage" value="[%1] %2 failed with NTSTATUS %3"/>
				<string id="RemoteDisconnectCompleted.EventMessage" value="Device %1 disconnected with NTSTATUS %2"/>
			</stringTable>
		</resources>
	</localization>
</instrumentationManifest>