# Gitbrew: Your LLM-Powered GitHub Companion 🚀✨

Welcome to Gitbrew, the innovative tool that harnesses the power of language models to streamline your GitHub experience. Gitbrew is designed to assist developers in managing repositories, handling issues, reviewing pull requests, and generating beautiful READMEs with ease.

***

### Table of Contents
- [Introduction](#introduction)
- [Features](#features)
- [Examples](#examples)
- [Installation](#Installation)
- [Usage](#usage)
- [Contributing](#contributing)
***
## Introduction👋
Gitbrew is a command-line application that simplifies your GitHub workflow. It uses advanced language models to interpret natural language commands, generate git commands, handle GitHub issues, and create comprehensive READMEs for your projects. Gitbrew is your go-to utility for a more efficient and intelligent way to interact with GitHub.
***
## Features🌟
- **Command Handling**: Process user input to generate and execute git commands safely with user confirmation.
- **Issue Management**: Manage GitHub issues by listing, creating, finding duplicates, and identifying similar issues.
- **Pull Request Review**: Automate the review of GitHub pull requests with insightful comments and suggestions.
- **Readme Generation**: Generate visually appealing READMEs with structured content and visual elements.
- **Interactive Shell Interface**: Use Gitbrew's interactive CLI to perform a variety of GitHub-related tasks.
***
## Examples🌟
### Readme generation
```terminal
? What would you like to do?  Generate a Readme
? Enter the repository url:   https://github.com/<username>/<repositoryname>
100%|██████████████████████████████████████████████████████████████| 2/2 [00:47<00:00, 23.85s/it]
? What would you like to save the file as?   Readme.md
```
![Readme.md](https://github.com/navneetdesai/gitbrew/raw/main/examples/images/readme_example.png)
***
### Pull Request Review
```terminal
? What would you like to do?  Review a pull request
Enter the pull request URL: https://github.com/<username>/<repositoryname>/pull/<number>
```
![Pull Request Review](https://github.com/navneetdesai/gitbrew/raw/main/examples/images/review1.png)
![Pull Request Review](https://github.com/navneetdesai/gitbrew/raw/main/examples/images/review2.png)
![Pull Request Review](https://github.com/navneetdesai/gitbrew/raw/main/examples/images/review3.png)

***
### Natural language interface for git
![gitbrew](https://github.com/navneetdesai/gitbrew/raw/main/examples/images/gitbrew1.png)
***
![gitbrew](https://github.com/navneetdesai/gitbrew/raw/main/examples/images/gitbrew2.png)
***
![gitbrew](https://github.com/navneetdesai/gitbrew/raw/main/examples/images/gitbrew3.png)
***




## Installation🛠️
```bash
pip install gitbrew
```

## Usage💻
1. **Run `gitbrew` in your Terminal:**
   ```bash
   gitbrew
   ```
   This will launch the Gitbrew interactive shell.
2. Provide the API keys for GitHub, openai, pinecone etc
3. Start using Gitbrew!

## Contributing🤝🌐
Contributions and feature requests are welcome! 

### Issues and Feature Requests
Please use the [issue tracker](https://github.com/navneetdesai/gitbrew/issues) to report any bugs or file feature requests.

### Development
1. Fork and clone the repository.
2. Make your changes and commit them with a descriptive commit message.
3. Install pre-commit hooks by running `pre-commit install`.
4. Push your changes to your fork and submit a pull request.


---

Thank you for checking out Gitbrew! 🚀✨ \
This readme was generated by gitbrew! 🤖
