/*
    Copyright (C) 2015-2023, Navaro, All Rights Reserved
    SPDX-License-Identifier: MIT

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
 */

#ifndef __STORAGE_H__
#define __STORAGE_H__

#include <stdint.h>
#include "system_config.h"

/*
 * Emulation of non volatile memory in RAM.
 */

/*===========================================================================*/
/* External declarations.                                                    */
/*===========================================================================*/

#ifdef __cplusplus
extern "C" {
#endif

	int32_t     ramdrv_init (void) ;
	int32_t     ramdrv_start (void) ;
	int32_t     ramdrv_stop (void) ;


	int32_t     ramdrv_read (uint32_t addr, uint32_t len, uint8_t * data) ;
	int32_t     ramdrv_write (uint32_t addr, uint32_t len, const uint8_t * data) ;
	int32_t     ramdrv_erase (uint32_t addr_start, uint32_t addr_end) ;


#ifdef __cplusplus
}
#endif

#endif /* __STORAGE_H__ */
