# codedesign.dev

![License](https://img.shields.io/github/license/nauvalazhar/code-design?style=flat-square) ![top](https://img.shields.io/github/languages/top/nauvalazhar/code-design?style=flat-square) <!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-13-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END --> 


As a developer, it's important to continually challenge yourself and improve your skills. Code The Design was created with this goal in mind. We believe that the best way to learn and grow is by tackling real-life projects and challenges, rather than just following along with tutorials or practicing with contrived exercises.

That's why we've created a platform that offers a wide variety of challenges, inspired by real-world designs and use cases. These challenges are meant to push you to think creatively, problem-solve, and develop your skills as a developer.

We understand that everyone has different levels of experience and expertise, which is why we've included a subjective difficulty rating for each challenge. This allows you to choose challenges that are appropriate for your current skill level, and gradually work your way up as you improve.

We also understand that the website is in a very early stage and far from being stable (see our [roadmap](https://github.com/nauvalazhar/code-design/issues/12)). Our focus is on getting the website visible as soon as possible, which is why we don't currently offer pre-exported assets and specific objectives for the challenges. However, we provide Figma design files for each challenge, which you can learn how the designs work and use to export any assets you need.

We hope that Code The Design will serve as a valuable resource for you as you work to improve your skills and become a more confident and capable developer. Happy coding!

## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://nauv.al"><img src="https://avatars.githubusercontent.com/u/14899175?v=4?s=100" width="100px;" alt="Nauval"/><br /><sub><b>Nauval</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=nauvalazhar" title="Code">💻</a> <a href="#design-nauvalazhar" title="Design">🎨</a> <a href="#ideas-nauvalazhar" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/nauvalazhar/code-design/commits?author=nauvalazhar" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://wiscaksono.me/"><img src="https://avatars.githubusercontent.com/u/63142229?v=4?s=100" width="100px;" alt="Wisnu Wicaksono"/><br /><sub><b>Wisnu Wicaksono</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=wiscaksono" title="Code">💻</a> <a href="#design-wiscaksono" title="Design">🎨</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://fiqry.dev"><img src="https://avatars.githubusercontent.com/u/25787603?v=4?s=100" width="100px;" alt="Fiqry choerudin"/><br /><sub><b>Fiqry choerudin</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=fiqryq" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://mrtampan.github.io/"><img src="https://avatars.githubusercontent.com/u/33930946?v=4?s=100" width="100px;" alt="Achmad Rivaldi"/><br /><sub><b>Achmad Rivaldi</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=mrtampan" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://perdidev.github.io"><img src="https://avatars.githubusercontent.com/u/108800230?v=4?s=100" width="100px;" alt="Perdi"/><br /><sub><b>Perdi</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=perdiDev" title="Code">💻</a> <a href="#design-perdiDev" title="Design">🎨</a> <a href="https://github.com/nauvalazhar/code-design/commits?author=perdiDev" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://hendraaagil.dev"><img src="https://avatars.githubusercontent.com/u/54741166?v=4?s=100" width="100px;" alt="Hendra Agil"/><br /><sub><b>Hendra Agil</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=hendraaagil" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://up2dul.com"><img src="https://avatars.githubusercontent.com/u/36098718?v=4?s=100" width="100px;" alt="Abdul Malik"/><br /><sub><b>Abdul Malik</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=up2dul" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://haikel.my.id"><img src="https://avatars.githubusercontent.com/u/77146709?v=4?s=100" width="100px;" alt="ハキム"/><br /><sub><b>ハキム</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=haikelz" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/iamyuu"><img src="https://avatars.githubusercontent.com/u/45778229?v=4?s=100" width="100px;" alt="Yusuf"/><br /><sub><b>Yusuf</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=iamyuu" title="Code">💻</a> <a href="#design-iamyuu" title="Design">🎨</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mahdanidn"><img src="https://avatars.githubusercontent.com/u/50037482?v=4?s=100" width="100px;" alt="M. Mahdani Rahmatullah"/><br /><sub><b>M. Mahdani Rahmatullah</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=mahdanidn" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://alfanjauhari.com"><img src="https://avatars.githubusercontent.com/u/57592351?v=4?s=100" width="100px;" alt="Alfan Jauhari"/><br /><sub><b>Alfan Jauhari</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=alfanjauhari" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://sglkc.my.id"><img src="https://avatars.githubusercontent.com/u/31957516?v=4?s=100" width="100px;" alt="Seya"/><br /><sub><b>Seya</b></sub></a><br /><a href="https://github.com/nauvalazhar/code-design/commits?author=sglkc" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/altafsyah"><img src="https://avatars.githubusercontent.com/u/57579846?v=4?s=100" width="100px;" alt="Altaf Syah"/><br /><sub><b>Altaf Syah</b></sub></a><br /><a href="#design-altafsyah" title="Design">🎨</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

## UI Designers

<table width="100%">
  <tr>
    <td align="center"><img src="https://avatars.githubusercontent.com/u/14899175?v=4" width="100" alt="Nauval"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/taufik.jpeg" width="100" alt="Taufik Hidayatulloh"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/mahyu.jpeg" width="100" alt="Mahyu Aspant"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/fauzan.jpeg" width="100" alt="Muhammad Fauzan Alkhairi"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/rafiq.png" width="100" alt="Rafiq Al Hafizh Adha"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/syauqi.jpeg" width="100" alt="Syauqizaidan Khairan Khalaf"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/yohana.jpeg" width="100" alt="Yohana Marlina"></td>
  </tr>
  <tr>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Nauval</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@mhd">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Taufik Hidayatulloh</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@opik">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Mahyu Aspant</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@mahyuaspant">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Muhammad Fauzan Alkhairi</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@muhammadfauzana">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Rafiq Al Hafizh Adha</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@rafiqadha">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Syauqizaidan Khairan Khalaf</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@syaufy">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Yohana Marlina</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@yohanamarlina">Visit Profile</a></sub>
    </td>
  </tr>
  <tr>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/dimas.jpeg" width="100" alt="Dimas Rizky Maulana"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/glenn.jpeg" width="100" alt="Glenn Vhalado"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/brainstew.jpeg" width="100" alt="BrainStew Studio"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/irham.jpeg" width="100" alt="Irham Shidiq"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/dzaki.jpeg" width="100" alt="Dzaki Muzhaffar"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/afin.jpeg" width="100" alt="Muhammad Afin"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/arie.jpeg" width="100" alt="Arie"></td>
  </tr>
  <tr>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Dimas Rizky Maulana</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@dimasrizkym">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Glenn Vhalado</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@glennvhalado">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>BrainStew Studio</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@brainstewstudio">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Irham Shidiq</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@irhammshidiq">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Dzaki Muzhaffar</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@dzakiimuzh">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Muhammad Afin</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@maafin_ui">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Arie</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@ariar">Visit Profile</a></sub>
    </td>
  </tr>
  <tr>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/irvan.jpeg" width="100" alt="Irvan"></td>
    <td align="center"><img src="https://code-design-avo7jempo-nauvals-projects-a308cc0f.vercel.app/users/alfian.jpeg" width="100" alt="Alfian"></td>
    <td align="center"><img src="https://mwzzrmbvlkcquvnwsijg.supabase.co/storage/v1/object/public/codedesign/users/fadhil.jpeg" width="100" alt="Fadhil"></td>
  </tr>
  <tr>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Irvan Moses</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@irvan">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Muhammad Alfian</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@alpi">Visit Profile</a></sub>
    </td>
    <td align="center" valign="top" width="14.28%">
      <sub><b>Fadhil</b></sub>
      <br>
      <sub><a href="https://www.figma.com/@fdhlnrzzmn">Visit Profile</a></sub>
    </td>
  </tr>
</table>

## Contributing

See our [contributing](https://github.com/nauvalazhar/code-design/blob/main/CONTRIBUTING.md) document for more information and UI design contributions, please consult the [UI Design Contribution Guideline](https://github.com/nauvalazhar/code-design/blob/main/CONTRIBUTING_DESIGN.md) document.

## License
[MIT License](https://github.com/nauvalazhar/code-design/blob/main/LICENSE)

