# UI Design Contribution Guideline
Thank you for your interest in contributing to the design collection! 
The purpose of this guide is to provide you with the information you need to make meaningful contributions to the project.

## Design Guidelines
In order to maintain a consistent style and user experience across the designs in the collection, please follow these design guidelines:
- Use Figma. We all here love Figma, so you are.
- Create at least two pages:
  - **Thumbnail**: Contains all of your design thumbnail information, such as Figma Community file cover, Dribbble shot cover, etc.
  - **UI Design** or **Design**: Contains all of your UI design frames, contents, components, etc.
- Publish your UI design as a Figma Community file.

We don't have any design standards for now, but you may follow these general design tips from us:
- Use a clean design style that focuses on readability and usability.
- Use a limited typography that is consistent with your overall UI design.
- Avoid clutter and distractions. Keep the UI design focused on the most important information.
- Consider the user's experience and how they will interact with the design.

## Submitting a New Design
To contribute a new design to the collection, follow these steps:
1. Go to the [New Issue page](https://github.com/nauvalazhar/code-design/issues/new/choose)
2. Select the "Submit UI Design" template
3. Fill out all the questions
4. Wait for the review process

## Review Process
The repository maintainers will review your issue and provide feedback or suggestions for changes. If your design is accepted, it will be published into our site. If changes are needed, you'll be asked to make them and let the maintainers know.

## Conclusion
Thank you for your contributions! By submitting a new design, you are helping to make the collection even better and more valuable to users. We look forward to reviewing your UI design contribution!

> This guideline is new, you may see old UI designs are not following these guidelines.
