---
has_children: false
published: true
layout: default
nav_order: 102
title: Configuration
published_at: 2020-06-05 02:05:00
---
<!--
THIS FILE IS GENERATED BY NOTOMA AUTOMATICALLY, DON'T EDIT IT!
Notion link for this article: https://www.notion.so/a5fc5c39d10f4d038425c0ef8bfaa760
-->

Notoma loads configuration via environment variables, or an `.env` file. The easiest way to configure Notoma is to take a look at the [`.env.sample`](https://github.com/nategadzhi/notoma/blob/master/.env.sample) [file in the repository,](https://github.com/nategadzhi/notoma/blob/master/.env.sample) and tweak it to your liking.

```bash
NOTOMA_NOTION_TOKEN_V2 = your_secret_notion_cookie_token_v2
NOTOMA_NOTION_BLOG_URL = https://www.notion.so/respawn/7b46cea379bd4d45b68860c2fa35a2d4?v=b4609f6aae0d4fc1adc65a73f72d0e21

# If your blog database doesn't have the layout property, Notoma will use the default layout. 
NOTOMA_DEFAULT_LAYOUT = default 

# Permalink patttern to use for @links in your Notion pages.
NOTOMA_PERMALINK_PATTERN = https://$baseurl/$title/

# Base URL to use when assembling @links
NOTOMA_BASE_URL = nategadzhi.notoma.io
```

#### Supported permalink substitutions
{: .mt-8 }

*Note: the permalink format* __*must match*__ *whatever format you're using in your blog engine. It's on you to set and make sure the format matches. If they don't match, the @links won't work, and you'll likely see some 404 pages.*

When Notoma processes @links, it'll try to build a link by taking `NOTOMA_PERMALINK_PATTERN` from the config, and substituting it's parts:
- Notoma will use all the keys from the front matter that are available. That means you can use any Notion property you add in your URLS, as long as it's a string.
- Notoma will automatically slugify title for you the same way it does for file names.
- Notoma will automatically add `year`, `month` and `day` to the substitutions mapping, although they're numeric and the date formatting in permalinks is not currently supported.

