/*
 * Decompiled with CFR 0.152.
 */
package com.sam.netty_tcp.server;

import com.sam.netty_tcp.server.PipelineFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.GlobalEventExecutor;

public class NettyServer {
    private final EventLoopGroup bossLoopGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerLoopGroup = new NioEventLoopGroup();
    private final ChannelGroup channelGroup = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
    private final Class<? extends PipelineFactory> pipelineFactoryClass;

    public NettyServer(Class<? extends PipelineFactory> pipelineFactoryType) {
        this.pipelineFactoryClass = pipelineFactoryType;
    }

    public final void startup(int port) throws Exception {
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossLoopGroup, this.workerLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 1024)).option(ChannelOption.AUTO_CLOSE, true)).option(ChannelOption.SO_REUSEADDR, true)).childOption(ChannelOption.SO_KEEPALIVE, true).childOption(ChannelOption.TCP_NODELAY, true);
        PipelineFactory pipelineFactory = this.pipelineFactoryClass.newInstance();
        ChannelInitializer<SocketChannel> initializer = pipelineFactory.createInitializer();
        bootstrap.childHandler(initializer);
        try {
            ChannelFuture channelFuture = bootstrap.bind(port).sync();
            this.channelGroup.add(channelFuture.channel());
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    public final void shutdown() throws Exception {
        this.channelGroup.close();
        this.bossLoopGroup.shutdownGracefully();
        this.workerLoopGroup.shutdownGracefully();
    }
}

