/*
 * Decompiled with CFR 0.152.
 */
package com.sam.netty_tcp.server;

import com.sam.netty_tcp.entity.Message;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;

public class MessageHandler
extends SimpleChannelInboundHandler<Message> {
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
        this.handleMessage(ctx, msg);
    }

    private void handleMessage(ChannelHandlerContext ctx, Message msg) {
        System.out.println("Message Received : " + msg.getMessage());
        ByteBuf buf = Unpooled.wrappedBuffer("Hey Sameer Here!!!!".getBytes());
        final WriteListener listener = new WriteListener(){

            @Override
            public void messageRespond(boolean success) {
                System.out.println(success ? "reply success" : "reply fail");
            }
        };
        ctx.writeAndFlush(buf).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (listener != null) {
                    listener.messageRespond(future.isSuccess());
                }
            }
        });
    }

    public static interface WriteListener {
        public void messageRespond(boolean var1);
    }
}

