/*
 * Decompiled with CFR 0.152.
 */
package com.sam.netty_tcp.client;

import com.sam.netty_tcp.client.NettyHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;

public class Client {
    int port;
    Channel channel;
    EventLoopGroup workGroup = new NioEventLoopGroup();

    public Client(int port) {
        this.port = port;
    }

    public ChannelFuture startup() throws Exception {
        Bootstrap b = new Bootstrap();
        b.group(this.workGroup);
        b.channel(NioSocketChannel.class);
        b.option(ChannelOption.SO_KEEPALIVE, true);
        b.handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) throws Exception {
                socketChannel.pipeline().addLast(new NettyHandler());
            }
        });
        ChannelFuture channelFuture = b.connect("127.0.0.1", this.port).sync();
        this.channel = channelFuture.channel();
        return channelFuture;
    }

    public void shutdown() {
        this.workGroup.shutdownGracefully();
    }
}

