/*
 * Decompiled with CFR 0.152.
 */
package com.sam.netty_tcp;

import com.sam.netty_tcp.client.Client;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;

public class ClientMain {
    public static void main(String[] args) {
        try {
            System.out.println("Creating new Client");
            Client client = new Client(11111);
            ChannelFuture channelFuture = client.startup();
            System.out.println("New Client is created");
            Thread.sleep(5000L);
            if (channelFuture.isSuccess()) {
                channelFuture.channel().writeAndFlush(Unpooled.wrappedBuffer("Hello".getBytes())).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        System.out.println(future.isSuccess() ? "Message sent to server : Hello" : "Message sending failed");
                    }
                });
            }
            Thread.sleep(5000L);
            client.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Try Starting Server First !!");
        }
    }
}

