/*
 * Decompiled with CFR 0.152.
 */
package com.sam.netty_udp.server;

import com.sam.netty_udp.server.PipelineFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.GlobalEventExecutor;

public class NettyServer {
    private final EventLoopGroup bossLoopGroup = new NioEventLoopGroup();
    private final ChannelGroup channelGroup = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
    private final Class<? extends PipelineFactory> pipelineFactoryClass;

    public NettyServer(Class<? extends PipelineFactory> pipelineFactoryType) {
        this.pipelineFactoryClass = pipelineFactoryType;
    }

    public final void startup(int port) throws Exception {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.bossLoopGroup)).channel(NioDatagramChannel.class)).option(ChannelOption.AUTO_CLOSE, true)).option(ChannelOption.SO_BROADCAST, true);
        PipelineFactory pipelineFactory = this.pipelineFactoryClass.newInstance();
        ChannelInitializer<DatagramChannel> initializer = pipelineFactory.createInitializer();
        bootstrap.handler(initializer);
        try {
            ChannelFuture channelFuture = bootstrap.bind(port).sync();
            this.channelGroup.add(channelFuture.channel());
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    public final void shutdown() throws Exception {
        this.channelGroup.close();
        this.bossLoopGroup.shutdownGracefully();
    }
}

