/*
 * Decompiled with CFR 0.152.
 */
package com.sam.netty_udp.client;

import com.sam.netty_udp.client.NettyHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;

public class Client {
    int port;
    Channel channel;
    EventLoopGroup workGroup = new NioEventLoopGroup();

    public Client(int port) {
        this.port = port;
    }

    public ChannelFuture startup() throws Exception {
        Bootstrap b = new Bootstrap();
        b.group(this.workGroup);
        b.channel(NioDatagramChannel.class);
        b.handler(new ChannelInitializer<DatagramChannel>(){

            @Override
            protected void initChannel(DatagramChannel datagramChannel) throws Exception {
                datagramChannel.pipeline().addLast(new NettyHandler());
            }
        });
        ChannelFuture channelFuture = b.connect("127.0.0.1", this.port).sync();
        this.channel = channelFuture.channel();
        return channelFuture;
    }

    public void shutdown() {
        this.workGroup.shutdownGracefully();
    }
}

