(add-tests-with-string-output-noboot "test self"
  [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (string-append "hello" ", " "there"))
   => "\"hello, there\"\n"]
  [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (member 'x '(w x y z)))
   => "(x y z)\n"]
   [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (list? '(x y . z)))
   => "#f\n"]
  [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (length-vararg '(x y . z)))
   => "2\n"]
  [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (reverse '(1 2 3)))
   => "(3 2 1)\n"]
  [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (for-each display '(1 2 3))
     4)
   => "1234\n"]
  [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (for-each (lambda (x y) (display (+ x y))) '(1 2 3) '(6 5 4))
     7)
   => "7777\n"]
  [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (printf "hello\n")
     1)
   => "hello\n1\n"]
  [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (printf "hello ~s and ~s for ~a\n" "here" "there" 1)
     1)
   => "hello here and there for 1\n1\n"]
  [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (+ 2 4))
   => "6\n"]
  [(let ()
     (load "self.scm")
     (load "reader.scm")
     (load "compiler.scm")
     (string-append "foo" "bar"))
   => "\"foobar\"\n"]
)
