/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.eclipse.core.proxy;

import com.google.appengine.eclipse.core.AppEngineCorePlugin;
import com.google.appengine.eclipse.core.AppEngineCorePluginLog;
import com.google.appengine.eclipse.core.sdk.AppEngineBridge;
import com.google.appengine.tools.admin.AdminException;
import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.UpdateFailureEvent;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateProgressEvent;
import com.google.appengine.tools.admin.UpdateSuccessEvent;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.appengine.tools.info.Version;
import com.google.apphosting.runtime.security.WhiteList;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.deploy.DeploymentSet;
import com.google.gdt.eclipse.core.sdk.SdkUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.management.ReflectionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.xml.sax.SAXParseException;

public class AppEngineBridgeImpl
implements AppEngineBridge {
    private static final String APPENGINE_API_JAR_NAME_REGEX = "appengine-api-.*sdk.*\\.jar";
    private static final IPath APPENGINE_TOOLS_API_JAR_PATH = new Path("lib/appengine-tools-api.jar");
    private static final String MIN_SUPPORTED_VERSION = "0.0.0";
    private static final VersionComparator VERSION_COMPARATOR = new VersionComparator();

    static AppAdmin createAppAdmin(AppEngineBridge.DeployOptions options) throws IOException {
        AppAdminFactory appAdminFactory = new AppAdminFactory();
        if (options.getJavaExecutableOSPath() != null) {
            appAdminFactory.setJavaExecutable(new File(options.getJavaExecutableOSPath()));
        }
        if (options.getJavaCompilerExecutableOSPath() != null) {
            appAdminFactory.setJavaCompiler(new File(options.getJavaCompilerExecutableOSPath()));
        }
        Application app = Application.readApplication((String)options.getDeployFolderOSPath());
        PrintWriter errorWriter = new PrintWriter(options.getErrorStream(), true);
        AppAdminFactory.ConnectOptions appEngineConnectOptions = new AppAdminFactory.ConnectOptions();
        appEngineConnectOptions.setOauthToken(options.getOAuth2Token());
        String appengineServer = System.getenv("APPENGINE_SERVER");
        if (appengineServer != null) {
            appEngineConnectOptions.setServer(appengineServer);
        }
        appAdminFactory.setJarSplittingEnabled(true);
        AppAdmin appAdmin = appAdminFactory.createAppAdmin(appEngineConnectOptions, app, errorWriter);
        return appAdmin;
    }

    private static void getLibs(File dir, List<File> list) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                AppEngineBridgeImpl.getLibs(f, list);
            } else if (f.getName().endsWith(".jar")) {
                list.add(f);
            }
            ++n2;
        }
    }

    public AppEngineBridgeImpl() throws CoreException {
        if (!this.hasSdkInfo() || !this.isCompatibleVersion()) {
            throw new CoreException(StatusUtilities.newErrorStatus((String)"App Engine SDK version must be greater than 0.0.0 in order to work with this plugin.", (String)AppEngineCorePlugin.PLUGIN_ID));
        }
    }

    public IStatus deploy(IProgressMonitor monitor, AppEngineBridge.DeployOptions options) throws IOException {
        UpdateCheck updateCheck = new UpdateCheck(SdkInfo.getDefaultServer());
        if (updateCheck.allowedToCheckForUpdates()) {
            updateCheck.maybePrintNagScreen(new PrintStream(options.getOutputStream(), true));
        }
        AppAdmin appAdmin = null;
        try {
            appAdmin = AppEngineBridgeImpl.createAppAdmin(options);
        }
        catch (AppEngineConfigException e) {
            if (e.getCause() instanceof SAXParseException) {
                String msg = e.getCause().getMessage();
                if (msg.contains("Failed to read schema document") && msg.contains("backends.xsd")) {
                    return new Status(4, AppEngineCorePlugin.PLUGIN_ID, "Deploying a project with backends requires App Engine SDK 1.5.0 or greater.", (Throwable)e);
                }
                throw e;
            }
            throw e;
        }
        DeploymentSet deploymentSet = options.getDeploymentSet();
        DeployUpdateListener deployUpdateListener = new DeployUpdateListener(monitor, deploymentSet, new PrintWriter(options.getOutputStream(), true), new PrintWriter(options.getErrorStream(), true));
        try {
            if (deploymentSet.getDeployFrontend()) {
                deployUpdateListener.setDeploymentUnitName("frontend");
                deployUpdateListener.println("\n------------ Deploying frontend ------------");
                appAdmin.update((UpdateListener)deployUpdateListener);
            }
            for (String backendName : deploymentSet.getBackendNames()) {
                deployUpdateListener.setDeploymentUnitName(backendName);
                deployUpdateListener.println("\n------------ Deploying backend \"" + backendName + "\" ------------");
                appAdmin.updateBackend(backendName, (UpdateListener)deployUpdateListener);
            }
            return deployUpdateListener.getStatus();
        }
        catch (AdminException e) {
            return new Status(4, AppEngineCorePlugin.PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getAppId(IPath warPath) throws IOException {
        Application app = Application.readApplication((String)warPath.toOSString());
        return app.getAppId();
    }

    public String getAppVersion(IPath warPath) throws IOException {
        Application app = Application.readApplication((String)warPath.toOSString());
        return app.getVersion();
    }

    public List<File> getBuildclasspathFiles() throws ReflectionException {
        return this.getBuildclasspathFiles(true);
    }

    public List<File> getBuildclasspathFiles(boolean getDatanucleusFiles) throws ReflectionException {
        ArrayList<File> classpathFiles = new ArrayList<File>();
        classpathFiles.addAll(this.getSharedLibFiles());
        classpathFiles.add(new Path(SdkInfo.getSdkRoot().getAbsolutePath()).append(APPENGINE_TOOLS_API_JAR_PATH).toFile());
        classpathFiles.addAll(this.getLatestUserLibFiles(getDatanucleusFiles));
        return classpathFiles;
    }

    public List<File> getLatestUserLibFiles(boolean getDatanucleusFiles) throws ReflectionException {
        if (SdkUtils.compareVersionStrings((String)this.getSdkVersion(), (String)"1.6.4") < 0) {
            return this.getUserLibFiles();
        }
        ArrayList<File> userLibFiles = new ArrayList<File>();
        for (String libName : this.getUserLibNames()) {
            if (!getDatanucleusFiles && libName.equals("datanucleus")) continue;
            userLibFiles.addAll(this.getUserLibFiles(libName, this.getLatestVersion(libName)));
        }
        File appengineApiJarFile = null;
        for (File jarFile : this.getUserLibFiles()) {
            if (!jarFile.getName().matches(APPENGINE_API_JAR_NAME_REGEX)) continue;
            appengineApiJarFile = jarFile;
            break;
        }
        if (appengineApiJarFile != null) {
            userLibFiles.add(appengineApiJarFile);
        } else {
            AppEngineCorePluginLog.logError((String)"Unable to find appengine-api-1.0-sdk");
        }
        return userLibFiles;
    }

    public String getLatestVersion(String libName) throws ReflectionException {
        List<String> versions = this.getUserLibVersions(libName);
        String maxVersion = versions.get(0);
        for (String version : versions) {
            if (version.compareTo(maxVersion) <= 0) continue;
            maxVersion = version;
        }
        return maxVersion;
    }

    public String getSdkVersion() {
        return SdkInfo.getLocalVersion().getRelease();
    }

    public List<File> getSharedLibFiles() {
        return SdkInfo.getSharedLibFiles();
    }

    public List<File> getToolsLibFiles() {
        ArrayList<File> toolLibFiles = new ArrayList<File>();
        AppEngineBridgeImpl.getLibs(new File(SdkInfo.getSdkRoot(), "lib" + File.separator + "tools"), toolLibFiles);
        return toolLibFiles;
    }

    public List<File> getToolsLibFiles(String libName, String version) throws ReflectionException {
        return this.getLibFiles(libName, version, Lib.TOOLS);
    }

    public List<String> getToolsLibNames() throws ReflectionException {
        return this.getLibNames(Lib.TOOLS);
    }

    public List<String> getToolsLibVersions(String libName) throws ReflectionException {
        return this.getLibVersions(libName, Lib.TOOLS);
    }

    public List<File> getUserLibFiles() {
        return SdkInfo.getUserLibFiles();
    }

    public List<File> getUserLibFiles(String libName, String version) throws ReflectionException {
        return this.getLibFiles(libName, version, Lib.USER);
    }

    public List<String> getUserLibNames() throws ReflectionException {
        return this.getLibNames(Lib.USER);
    }

    public List<String> getUserLibVersions(String libName) throws ReflectionException {
        return this.getLibVersions(libName, Lib.USER);
    }

    public Set<String> getWhiteList() {
        return WhiteList.getWhiteList();
    }

    private List<File> getLibFiles(String libName, String version, Lib lib) throws ReflectionException {
        Method getFilesForVersion = this.getMethod(this.getOptionalLibClass(), "getFilesForVersion", String.class);
        Method getOptionalLib = this.getMethod(SdkInfo.class, lib.getOptionalLib(), String.class);
        Object optionalLib = this.invoke(getOptionalLib, null, libName);
        if (optionalLib == null) {
            return null;
        }
        List libFiles = (List)this.invoke(getFilesForVersion, optionalLib, version);
        return libFiles;
    }

    private List<String> getLibNames(Lib lib) throws ReflectionException {
        Method getName = this.getMethod(this.getOptionalLibClass(), "getName", new Class[0]);
        Method getOptionalLibs = this.getMethod(SdkInfo.class, lib.getOptionalLibs(), new Class[0]);
        Collection optionalLibs = (Collection)this.invoke(getOptionalLibs, null, new Object[0]);
        ArrayList<String> libs = new ArrayList<String>();
        for (Object optionalLib : optionalLibs) {
            libs.add((String)this.invoke(getName, optionalLib, new Object[0]));
        }
        return libs;
    }

    private List<String> getLibVersions(String libName, Lib lib) throws ReflectionException {
        Method getVersions = this.getMethod(this.getOptionalLibClass(), "getVersions", new Class[0]);
        Method getOptionalLib = this.getMethod(SdkInfo.class, lib.getOptionalLib(), String.class);
        Object x = this.invoke(getOptionalLib, null, libName);
        List libVersions = (List)this.invoke(getVersions, x, new Object[0]);
        return libVersions;
    }

    private Method getMethod(Class<?> clazz, String method, Class<?> ... parameterTypes) throws ReflectionException {
        try {
            return clazz.getMethod(method, parameterTypes);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e, "Unable to load method " + method);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e, "Unable to find method " + method);
        }
    }

    private Class<?> getOptionalLibClass() throws ReflectionException {
        try {
            return SdkInfo.class.getClassLoader().loadClass("com.google.appengine.tools.info.OptionalLib");
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "Unable to load Optional Lib Class. Check if GAE SDK is up to date.");
        }
    }

    private boolean hasSdkInfo() {
        try {
            Class.forName("com.google.appengine.tools.info.SdkInfo", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private Object invoke(Method method, Object obj, Object ... args) throws ReflectionException {
        String errorMessage = "Unable to invoke method: " + method.toString();
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e, errorMessage);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, errorMessage);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e, errorMessage);
        }
    }

    private boolean isCompatibleVersion() {
        Version sdkVersion = SdkInfo.getLocalVersion();
        return VERSION_COMPARATOR.compare(sdkVersion.getRelease(), MIN_SUPPORTED_VERSION) >= 0;
    }

    private static final class DeployUpdateListener
    implements UpdateListener {
        private int deployments;
        private String deploymentUnitName;
        private final int deploymentUnitsCount;
        private final PrintWriter errorWriter;
        private MessageHeaders messageHeaders;
        private final IProgressMonitor monitor;
        private final PrintWriter outputWriter;
        private int percentDone = 0;
        private IStatus status = Status.OK_STATUS;

        private static String getDetailsIfSupported(Object updateEvent) {
            try {
                Method method = updateEvent.getClass().getDeclaredMethod("getDetails", new Class[0]);
                return (String)method.invoke(updateEvent, new Object[0]);
            }
            catch (SecurityException e) {
                AppEngineCorePluginLog.logError((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                AppEngineCorePluginLog.logError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                AppEngineCorePluginLog.logError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                AppEngineCorePluginLog.logError((Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            return null;
        }

        private static boolean isJspCompilationException(Throwable ex) {
            if (ex != null) {
                try {
                    Class<?> jspCompilationExceptionClass = Class.forName("com.google.appengine.tools.admin.JspCompilationException");
                    return jspCompilationExceptionClass.isAssignableFrom(ex.getClass());
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            return false;
        }

        private DeployUpdateListener(IProgressMonitor monitor, DeploymentSet deploymentSet, PrintWriter outputWriter, PrintWriter errorWriter) {
            this.monitor = monitor;
            this.outputWriter = outputWriter;
            this.errorWriter = errorWriter;
            this.deploymentUnitsCount = deploymentSet.getDeploymentUnitsCount();
            this.messageHeaders = new MessageHeaders();
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void onFailure(UpdateFailureEvent event) {
            String details;
            this.monitor.done();
            this.status = new Status(4, AppEngineCorePlugin.PLUGIN_ID, event.getFailureMessage(), event.getCause());
            this.outputWriter.println(event.getFailureMessage());
            if (DeployUpdateListener.isJspCompilationException(event.getCause()) && (details = DeployUpdateListener.getDetailsIfSupported(event)) != null) {
                this.outputWriter.println(details);
            }
        }

        public void onProgress(UpdateProgressEvent event) {
            int worked = event.getPercentageComplete() - this.percentDone;
            this.percentDone += worked;
            this.monitor.worked(worked / this.deploymentUnitsCount);
            String msg = event.getMessage();
            PrefixHeaderPair php = this.messageHeaders.getMessageHeader(msg);
            if (php != null) {
                this.monitor.setTaskName(String.valueOf(php.taskHeader) + " " + this.deploymentUnitName);
                this.outputWriter.println("\n" + php.header + ":");
            }
            this.outputWriter.println("\t" + msg);
            if (this.monitor.isCanceled()) {
                event.cancel();
                this.status = new Status(8, AppEngineCorePlugin.PLUGIN_ID, "User cancelled");
                this.outputWriter.println(this.status.getMessage());
            }
        }

        public void onSuccess(UpdateSuccessEvent event) {
            String details;
            ++this.deployments;
            this.percentDone = 0;
            if (this.deployments == this.deploymentUnitsCount) {
                this.monitor.done();
            }
            if ((details = DeployUpdateListener.getDetailsIfSupported(event)) != null) {
                this.errorWriter.println(details);
            }
            this.outputWriter.println("\nDeployment completed successfully");
        }

        public void println(String s) {
            this.outputWriter.println(s);
        }

        public void setDeploymentUnitName(String name) {
            this.deploymentUnitName = name;
        }

        private static class MessageHeaders {
            private static final PrefixHeaderPair[] prefixHeaderPairs = new PrefixHeaderPair[]{new PrefixHeaderPair("Preparing to deploy", null, "Created staging directory", "Scanning files on local disk"), new PrefixHeaderPair("Deploying", null, "Uploading"), new PrefixHeaderPair("Verifying availability", "Verifying availability of", "Will check again in 1 seconds."), new PrefixHeaderPair("Updating datastore", null, "Uploading index")};
            private int currentPrefixHeaderPair;

            private MessageHeaders() {
            }

            PrefixHeaderPair getMessageHeader(String msg) {
                PrefixHeaderPair php = prefixHeaderPairs[this.currentPrefixHeaderPair];
                String[] stringArray = php.msgPrefixes;
                int n = php.msgPrefixes.length;
                int n2 = 0;
                while (n2 < n) {
                    String prefix = stringArray[n2];
                    if (msg.startsWith(prefix)) {
                        this.currentPrefixHeaderPair = (this.currentPrefixHeaderPair + 1) % prefixHeaderPairs.length;
                        return php;
                    }
                    ++n2;
                }
                return null;
            }
        }

        private static class PrefixHeaderPair {
            final String header;
            final String[] msgPrefixes;
            final String taskHeader;

            PrefixHeaderPair(String header, String taskHeader, String ... msgPrefixes) {
                this.msgPrefixes = msgPrefixes;
                this.header = header;
                this.taskHeader = taskHeader == null ? header : taskHeader;
            }
        }
    }

    private static enum Lib {
        TOOLS("getOptionalToolsLib", "getOptionalToolsLibs"),
        USER("getOptionalUserLib", "getOptionalUserLibs");

        private final String getOptionalLib;
        private final String getOptionalLibs;

        private Lib(String o1, String o2) {
            this.getOptionalLib = o1;
            this.getOptionalLibs = o2;
        }

        public String getOptionalLib() {
            return this.getOptionalLib;
        }

        public String getOptionalLibs() {
            return this.getOptionalLibs;
        }
    }

    private static class VersionComparator
    implements Comparator<String> {
        private VersionComparator() {
        }

        @Override
        public int compare(String version1, String version2) throws NumberFormatException {
            return SdkUtils.compareVersionStrings((String)version1, (String)version2);
        }
    }
}

