/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.connection;

import java.util.HashMap;
import java.util.Map;
import org.datanucleus.Transaction;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.util.StringUtils;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    protected StoreManager storeMgr;
    protected Map options = new HashMap();
    protected String resourceType;

    public AbstractConnectionFactory(StoreManager storeMgr, String resourceType) {
        this.storeMgr = storeMgr;
        this.resourceType = resourceType;
    }

    public ManagedConnection getConnection(Object poolKey, Transaction transaction, Map options) {
        HashMap addedOptions = new HashMap();
        if (options != null) {
            addedOptions.putAll(options);
        }
        addedOptions.putAll(this.options);
        ManagedConnection mconn = this.storeMgr.getConnectionManager().allocateConnection(this, poolKey, transaction, addedOptions);
        ((AbstractManagedConnection)mconn).incrementUseCount();
        return mconn;
    }

    public void close() {
    }

    public String toString() {
        return "ConnectionFactory:" + this.resourceType + "[" + StringUtils.toJVMIDString(this) + "]";
    }
}

