/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public class ResourceSchema {
    private final String name;
    private final Type type;
    private final ImmutableMap<String, ResourcePropertySchema> properties;

    private ResourceSchema(Builder builder) {
        this.name = builder.name;
        this.properties = builder.properties.build();
        this.type = builder.type;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Map<String, ResourcePropertySchema> getProperties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceSchema)) {
            return false;
        }
        ResourceSchema that = (ResourceSchema)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.properties, that.properties) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.properties, this.type);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this.getClass()).add("_name", (Object)this.name).add("_type", (Object)this.type);
        for (Map.Entry property : this.properties.entrySet()) {
            helper.add((String)property.getKey(), property.getValue());
        }
        return helper.toString();
    }

    public static Builder builderForType(Type type) {
        return new Builder(type);
    }

    public static Builder builderWithSchema(ResourceSchema schema) {
        return new Builder(schema);
    }

    public static class Builder {
        private String name;
        private Type type;
        private ImmutableMap.Builder<String, ResourcePropertySchema> properties = ImmutableMap.builder();

        private Builder(Type type) {
            Preconditions.checkNotNull((Object)type);
            this.type = type;
            this.name = null;
        }

        private Builder(ResourceSchema schema) {
            Preconditions.checkNotNull((Object)schema);
            this.name = schema.name;
            this.type = schema.type;
            this.properties.putAll((Map)schema.properties);
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addProperty(String name, ResourcePropertySchema propertySchema) {
            this.properties.put((Object)name, (Object)propertySchema);
            return this;
        }

        public ResourceSchema build() {
            return new ResourceSchema(this);
        }
    }
}

