/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.auth.EndpointsPeerAuthenticator;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.PeerAuthenticator;
import com.google.api.server.spi.config.Singleton;
import com.google.api.server.spi.request.Attribute;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class PeerAuth {
    private static final Logger logger = Logger.getLogger(PeerAuth.class.getName());
    private static volatile Map<Class<? extends PeerAuthenticator>, PeerAuthenticator> peerAuthenticatorInstances = new HashMap<Class<? extends PeerAuthenticator>, PeerAuthenticator>();
    private static final PeerAuthenticator DEFAULT_PEER_AUTHENTICATOR = new EndpointsPeerAuthenticator();
    private static final Function<Class<? extends PeerAuthenticator>, PeerAuthenticator> INSTANTIATE_PEER_AUTHENTICATOR = new Function<Class<? extends PeerAuthenticator>, PeerAuthenticator>(){

        public PeerAuthenticator apply(Class<? extends PeerAuthenticator> clazz) {
            try {
                if (clazz.getAnnotation(Singleton.class) != null) {
                    if (!peerAuthenticatorInstances.containsKey(clazz)) {
                        peerAuthenticatorInstances.put(clazz, clazz.newInstance());
                    }
                    return (PeerAuthenticator)peerAuthenticatorInstances.get(clazz);
                }
                return clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                String string = String.valueOf(clazz.getName());
                logger.log(Level.WARNING, string.length() != 0 ? "Could not instantiate peer authenticator: ".concat(string) : new String("Could not instantiate peer authenticator: "));
                return null;
            }
        }
    };
    private final HttpServletRequest request;
    private final Attribute attr;
    private final ApiMethodConfig config;

    @VisibleForTesting
    PeerAuth(HttpServletRequest request) {
        this.request = request;
        this.attr = Attribute.from(request);
        this.config = (ApiMethodConfig)this.attr.get("endpoints:Api-Method-Config");
    }

    static PeerAuth from(HttpServletRequest request) {
        return new PeerAuth(request);
    }

    @VisibleForTesting
    Iterable<PeerAuthenticator> getPeerAuthenticatorInstances() {
        List<Class<? extends PeerAuthenticator>> classes = this.config.getPeerAuthenticators();
        return classes == null ? ImmutableList.of((Object)DEFAULT_PEER_AUTHENTICATOR) : Iterables.filter((Iterable)Iterables.transform(classes, INSTANTIATE_PEER_AUTHENTICATOR), (Predicate)Predicates.notNull());
    }

    boolean authorizePeer() {
        if (!this.attr.isEnabled("endpoints:Restrict-Servlet")) {
            return true;
        }
        Iterable<PeerAuthenticator> peerAuthenticators = this.getPeerAuthenticatorInstances();
        if (peerAuthenticators != null) {
            for (PeerAuthenticator peerAuthenticator : peerAuthenticators) {
                if (peerAuthenticator.authenticate(this.request)) continue;
                return false;
            }
        }
        return true;
    }
}

